/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.server;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import javax.annotation.PostConstruct;
import org.prebid.server.handler.ExceptionHandler;
import org.prebid.server.vertx.ContextRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"server.http.enabled"}, havingValue="true")
public class HttpServerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerConfiguration.class);
    @Autowired
    private ContextRunner contextRunner;
    @Autowired
    private Vertx vertx;
    @Autowired
    private HttpServerOptions httpServerOptions;
    @Autowired
    private ExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier(value="router")
    private Router router;
    @Value(value="#{'${http.port:${server.http.port}}'}")
    private Integer httpPort;
    @Value(value="#{'${vertx.http-server-instances:${server.http.server-instances}}'}")
    private Integer httpServerNum;

    @PostConstruct
    public void startHttpServer() {
        logger.info((Object)"Starting {0} instances of Http Server to serve requests on port {1,number,#}", new Object[]{this.httpServerNum, this.httpPort});
        this.contextRunner.runOnNewContext(this.httpServerNum.intValue(), promise -> this.vertx.createHttpServer(this.httpServerOptions).exceptionHandler((Handler)this.exceptionHandler).requestHandler((Handler)this.router).listen(this.httpPort.intValue(), (Handler)promise));
        logger.info((Object)"Successfully started {0} instances of Http Server", new Object[]{this.httpServerNum});
    }
}

