/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.izettle.metrics.influxdb.InfluxDbHttpSender;
import com.izettle.metrics.influxdb.InfluxDbReporter;
import com.izettle.metrics.influxdb.InfluxDbSender;
import io.vertx.core.Closeable;
import io.vertx.core.Vertx;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.metric.AccountMetricsVerbosityResolver;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.Metrics;
import org.prebid.server.spring.config.metrics.MetricsConfiguration;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.prebid.server.vertx.CloseableAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/metrics-config/metrics.yaml"}, factory=YamlPropertySourceFactory.class)
public class MetricsConfiguration {
    public static final String METRIC_REGISTRY_NAME = "metric-registry";
    @Autowired(required=false)
    private List<ScheduledReporter> reporters = Collections.emptyList();
    @Autowired
    private Vertx vertx;

    @Bean
    @ConditionalOnProperty(prefix="metrics.graphite", name={"enabled"}, havingValue="true")
    ScheduledReporter graphiteReporter(GraphiteProperties graphiteProperties, MetricRegistry metricRegistry) {
        Graphite graphite = new Graphite(graphiteProperties.getHost(), graphiteProperties.getPort().intValue());
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(graphiteProperties.getPrefix()).build(graphite);
        reporter.start((long)graphiteProperties.getInterval().intValue(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    @ConditionalOnProperty(prefix="metrics.influxdb", name={"enabled"}, havingValue="true")
    ScheduledReporter influxdbReporter(InfluxdbProperties influxdbProperties, MetricRegistry metricRegistry) throws Exception {
        InfluxDbHttpSender influxDbSender = new InfluxDbHttpSender(influxdbProperties.getProtocol(), influxdbProperties.getHost(), influxdbProperties.getPort().intValue(), influxdbProperties.getDatabase(), influxdbProperties.getAuth(), TimeUnit.SECONDS, influxdbProperties.getConnectTimeout().intValue(), influxdbProperties.getReadTimeout().intValue(), influxdbProperties.getPrefix());
        Map tags = (Map)ObjectUtils.defaultIfNull((Object)influxdbProperties.getTags(), Collections.emptyMap());
        InfluxDbReporter reporter = InfluxDbReporter.forRegistry((MetricRegistry)metricRegistry).withTags(tags).build((InfluxDbSender)influxDbSender);
        reporter.start((long)influxdbProperties.getInterval().intValue(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    @ConditionalOnProperty(prefix="metrics.console", name={"enabled"}, havingValue="true")
    ScheduledReporter consoleReporter(ConsoleProperties consoleProperties, MetricRegistry metricRegistry) {
        ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)metricRegistry).build();
        reporter.start((long)consoleProperties.getInterval().intValue(), TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    Metrics metrics(@Value(value="${metrics.metricType}") CounterType counterType, MetricRegistry metricRegistry, AccountMetricsVerbosityResolver accountMetricsVerbosityResolver) {
        return new Metrics(metricRegistry, counterType, accountMetricsVerbosityResolver);
    }

    @Bean
    MetricRegistry metricRegistry(@Value(value="${metrics.jmx.enabled}") boolean jmxEnabled) {
        boolean alreadyExists = SharedMetricRegistries.names().contains(METRIC_REGISTRY_NAME);
        MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)METRIC_REGISTRY_NAME);
        if (!alreadyExists && jmxEnabled) {
            metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
            metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        }
        return metricRegistry;
    }

    @Bean
    AccountMetricsVerbosityResolver accountMetricsVerbosity(AccountsProperties accountsProperties) {
        return new AccountMetricsVerbosityResolver(accountsProperties.getDefaultVerbosity(), accountsProperties.getBasicVerbosity(), accountsProperties.getDetailedVerbosity());
    }

    @PostConstruct
    void registerReporterCloseHooks() {
        this.reporters.stream().map(CloseableAdapter::new).forEach(closeable -> this.vertx.getOrCreateContext().addCloseHook((Closeable)closeable));
    }
}

