/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountBidValidationConfig;
import org.prebid.server.settings.model.AccountEventsConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.settings.model.AccountTargetingConfig;

public final class AccountAuctionConfig {
    @JsonProperty(value="price-granularity")
    private final String priceGranularity;
    @JsonProperty(value="banner-cache-ttl")
    private final Integer bannerCacheTtl;
    @JsonProperty(value="video-cache-ttl")
    private final Integer videoCacheTtl;
    @JsonProperty(value="truncate-target-attr")
    private final Integer truncateTargetAttr;
    @JsonProperty(value="default-integration")
    private final String defaultIntegration;
    @JsonProperty(value="debug-allow")
    private final Boolean debugAllow;
    @JsonProperty(value="bid-validations")
    private final AccountBidValidationConfig bidValidations;
    private final AccountEventsConfig events;
    @JsonProperty(value="price-floors")
    private final AccountPriceFloorsConfig priceFloors;
    private final AccountTargetingConfig targeting;

    @ConstructorProperties(value={"priceGranularity", "bannerCacheTtl", "videoCacheTtl", "truncateTargetAttr", "defaultIntegration", "debugAllow", "bidValidations", "events", "priceFloors", "targeting"})
    AccountAuctionConfig(String priceGranularity, Integer bannerCacheTtl, Integer videoCacheTtl, Integer truncateTargetAttr, String defaultIntegration, Boolean debugAllow, AccountBidValidationConfig bidValidations, AccountEventsConfig events, AccountPriceFloorsConfig priceFloors, AccountTargetingConfig targeting) {
        this.priceGranularity = priceGranularity;
        this.bannerCacheTtl = bannerCacheTtl;
        this.videoCacheTtl = videoCacheTtl;
        this.truncateTargetAttr = truncateTargetAttr;
        this.defaultIntegration = defaultIntegration;
        this.debugAllow = debugAllow;
        this.bidValidations = bidValidations;
        this.events = events;
        this.priceFloors = priceFloors;
        this.targeting = targeting;
    }

    public static AccountAuctionConfigBuilder builder() {
        return new AccountAuctionConfigBuilder();
    }

    public AccountAuctionConfigBuilder toBuilder() {
        return new AccountAuctionConfigBuilder().priceGranularity(this.priceGranularity).bannerCacheTtl(this.bannerCacheTtl).videoCacheTtl(this.videoCacheTtl).truncateTargetAttr(this.truncateTargetAttr).defaultIntegration(this.defaultIntegration).debugAllow(this.debugAllow).bidValidations(this.bidValidations).events(this.events).priceFloors(this.priceFloors).targeting(this.targeting);
    }

    public String getPriceGranularity() {
        return this.priceGranularity;
    }

    public Integer getBannerCacheTtl() {
        return this.bannerCacheTtl;
    }

    public Integer getVideoCacheTtl() {
        return this.videoCacheTtl;
    }

    public Integer getTruncateTargetAttr() {
        return this.truncateTargetAttr;
    }

    public String getDefaultIntegration() {
        return this.defaultIntegration;
    }

    public Boolean getDebugAllow() {
        return this.debugAllow;
    }

    public AccountBidValidationConfig getBidValidations() {
        return this.bidValidations;
    }

    public AccountEventsConfig getEvents() {
        return this.events;
    }

    public AccountPriceFloorsConfig getPriceFloors() {
        return this.priceFloors;
    }

    public AccountTargetingConfig getTargeting() {
        return this.targeting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAuctionConfig)) {
            return false;
        }
        AccountAuctionConfig other = (AccountAuctionConfig)o;
        Integer this$bannerCacheTtl = this.getBannerCacheTtl();
        Integer other$bannerCacheTtl = other.getBannerCacheTtl();
        if (this$bannerCacheTtl == null ? other$bannerCacheTtl != null : !((Object)this$bannerCacheTtl).equals(other$bannerCacheTtl)) {
            return false;
        }
        Integer this$videoCacheTtl = this.getVideoCacheTtl();
        Integer other$videoCacheTtl = other.getVideoCacheTtl();
        if (this$videoCacheTtl == null ? other$videoCacheTtl != null : !((Object)this$videoCacheTtl).equals(other$videoCacheTtl)) {
            return false;
        }
        Integer this$truncateTargetAttr = this.getTruncateTargetAttr();
        Integer other$truncateTargetAttr = other.getTruncateTargetAttr();
        if (this$truncateTargetAttr == null ? other$truncateTargetAttr != null : !((Object)this$truncateTargetAttr).equals(other$truncateTargetAttr)) {
            return false;
        }
        Boolean this$debugAllow = this.getDebugAllow();
        Boolean other$debugAllow = other.getDebugAllow();
        if (this$debugAllow == null ? other$debugAllow != null : !((Object)this$debugAllow).equals(other$debugAllow)) {
            return false;
        }
        String this$priceGranularity = this.getPriceGranularity();
        String other$priceGranularity = other.getPriceGranularity();
        if (this$priceGranularity == null ? other$priceGranularity != null : !this$priceGranularity.equals(other$priceGranularity)) {
            return false;
        }
        String this$defaultIntegration = this.getDefaultIntegration();
        String other$defaultIntegration = other.getDefaultIntegration();
        if (this$defaultIntegration == null ? other$defaultIntegration != null : !this$defaultIntegration.equals(other$defaultIntegration)) {
            return false;
        }
        AccountBidValidationConfig this$bidValidations = this.getBidValidations();
        AccountBidValidationConfig other$bidValidations = other.getBidValidations();
        if (this$bidValidations == null ? other$bidValidations != null : !this$bidValidations.equals(other$bidValidations)) {
            return false;
        }
        AccountEventsConfig this$events = this.getEvents();
        AccountEventsConfig other$events = other.getEvents();
        if (this$events == null ? other$events != null : !this$events.equals(other$events)) {
            return false;
        }
        AccountPriceFloorsConfig this$priceFloors = this.getPriceFloors();
        AccountPriceFloorsConfig other$priceFloors = other.getPriceFloors();
        if (this$priceFloors == null ? other$priceFloors != null : !this$priceFloors.equals(other$priceFloors)) {
            return false;
        }
        AccountTargetingConfig this$targeting = this.getTargeting();
        AccountTargetingConfig other$targeting = other.getTargeting();
        return !(this$targeting == null ? other$targeting != null : !this$targeting.equals(other$targeting));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $bannerCacheTtl = this.getBannerCacheTtl();
        result = result * 59 + ($bannerCacheTtl == null ? 43 : ((Object)$bannerCacheTtl).hashCode());
        Integer $videoCacheTtl = this.getVideoCacheTtl();
        result = result * 59 + ($videoCacheTtl == null ? 43 : ((Object)$videoCacheTtl).hashCode());
        Integer $truncateTargetAttr = this.getTruncateTargetAttr();
        result = result * 59 + ($truncateTargetAttr == null ? 43 : ((Object)$truncateTargetAttr).hashCode());
        Boolean $debugAllow = this.getDebugAllow();
        result = result * 59 + ($debugAllow == null ? 43 : ((Object)$debugAllow).hashCode());
        String $priceGranularity = this.getPriceGranularity();
        result = result * 59 + ($priceGranularity == null ? 43 : $priceGranularity.hashCode());
        String $defaultIntegration = this.getDefaultIntegration();
        result = result * 59 + ($defaultIntegration == null ? 43 : $defaultIntegration.hashCode());
        AccountBidValidationConfig $bidValidations = this.getBidValidations();
        result = result * 59 + ($bidValidations == null ? 43 : $bidValidations.hashCode());
        AccountEventsConfig $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : $events.hashCode());
        AccountPriceFloorsConfig $priceFloors = this.getPriceFloors();
        result = result * 59 + ($priceFloors == null ? 43 : $priceFloors.hashCode());
        AccountTargetingConfig $targeting = this.getTargeting();
        result = result * 59 + ($targeting == null ? 43 : $targeting.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAuctionConfig(priceGranularity=" + this.getPriceGranularity() + ", bannerCacheTtl=" + this.getBannerCacheTtl() + ", videoCacheTtl=" + this.getVideoCacheTtl() + ", truncateTargetAttr=" + this.getTruncateTargetAttr() + ", defaultIntegration=" + this.getDefaultIntegration() + ", debugAllow=" + this.getDebugAllow() + ", bidValidations=" + this.getBidValidations() + ", events=" + this.getEvents() + ", priceFloors=" + this.getPriceFloors() + ", targeting=" + this.getTargeting() + ")";
    }
}

