/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Set;
import org.prebid.server.json.deserializer.CommaSeparatedStringAsListOfIntegersDeserializer;
import org.prebid.server.proto.request.CookieSyncRequest;

public final class CookieSyncRequest {
    private final Set<String> bidders;
    private final Integer gdpr;
    private final String gdprConsent;
    private final String usPrivacy;
    private final String gpp;
    @JsonDeserialize(using=CommaSeparatedStringAsListOfIntegersDeserializer.class)
    private final List<Integer> gppSid;
    @JsonProperty(value="coopSync")
    private final Boolean coopSync;
    private final Boolean debug;
    private final Integer limit;
    private final String account;
    @JsonProperty(value="filterSettings")
    private final FilterSettings filterSettings;

    @ConstructorProperties(value={"bidders", "gdpr", "gdprConsent", "usPrivacy", "gpp", "gppSid", "coopSync", "debug", "limit", "account", "filterSettings"})
    CookieSyncRequest(Set<String> bidders, Integer gdpr, String gdprConsent, String usPrivacy, String gpp, List<Integer> gppSid, Boolean coopSync, Boolean debug, Integer limit, String account, FilterSettings filterSettings) {
        this.bidders = bidders;
        this.gdpr = gdpr;
        this.gdprConsent = gdprConsent;
        this.usPrivacy = usPrivacy;
        this.gpp = gpp;
        this.gppSid = gppSid;
        this.coopSync = coopSync;
        this.debug = debug;
        this.limit = limit;
        this.account = account;
        this.filterSettings = filterSettings;
    }

    public static CookieSyncRequestBuilder builder() {
        return new CookieSyncRequestBuilder();
    }

    public CookieSyncRequestBuilder toBuilder() {
        return new CookieSyncRequestBuilder().bidders(this.bidders).gdpr(this.gdpr).gdprConsent(this.gdprConsent).usPrivacy(this.usPrivacy).gpp(this.gpp).gppSid(this.gppSid).coopSync(this.coopSync).debug(this.debug).limit(this.limit).account(this.account).filterSettings(this.filterSettings);
    }

    public Set<String> getBidders() {
        return this.bidders;
    }

    public Integer getGdpr() {
        return this.gdpr;
    }

    public String getGdprConsent() {
        return this.gdprConsent;
    }

    public String getUsPrivacy() {
        return this.usPrivacy;
    }

    public String getGpp() {
        return this.gpp;
    }

    public List<Integer> getGppSid() {
        return this.gppSid;
    }

    public Boolean getCoopSync() {
        return this.coopSync;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getAccount() {
        return this.account;
    }

    public FilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieSyncRequest)) {
            return false;
        }
        CookieSyncRequest other = (CookieSyncRequest)o;
        Integer this$gdpr = this.getGdpr();
        Integer other$gdpr = other.getGdpr();
        if (this$gdpr == null ? other$gdpr != null : !((Object)this$gdpr).equals(other$gdpr)) {
            return false;
        }
        Boolean this$coopSync = this.getCoopSync();
        Boolean other$coopSync = other.getCoopSync();
        if (this$coopSync == null ? other$coopSync != null : !((Object)this$coopSync).equals(other$coopSync)) {
            return false;
        }
        Boolean this$debug = this.getDebug();
        Boolean other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Set this$bidders = this.getBidders();
        Set other$bidders = other.getBidders();
        if (this$bidders == null ? other$bidders != null : !((Object)this$bidders).equals(other$bidders)) {
            return false;
        }
        String this$gdprConsent = this.getGdprConsent();
        String other$gdprConsent = other.getGdprConsent();
        if (this$gdprConsent == null ? other$gdprConsent != null : !this$gdprConsent.equals(other$gdprConsent)) {
            return false;
        }
        String this$usPrivacy = this.getUsPrivacy();
        String other$usPrivacy = other.getUsPrivacy();
        if (this$usPrivacy == null ? other$usPrivacy != null : !this$usPrivacy.equals(other$usPrivacy)) {
            return false;
        }
        String this$gpp = this.getGpp();
        String other$gpp = other.getGpp();
        if (this$gpp == null ? other$gpp != null : !this$gpp.equals(other$gpp)) {
            return false;
        }
        List this$gppSid = this.getGppSid();
        List other$gppSid = other.getGppSid();
        if (this$gppSid == null ? other$gppSid != null : !((Object)this$gppSid).equals(other$gppSid)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        FilterSettings this$filterSettings = this.getFilterSettings();
        FilterSettings other$filterSettings = other.getFilterSettings();
        return !(this$filterSettings == null ? other$filterSettings != null : !this$filterSettings.equals(other$filterSettings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $gdpr = this.getGdpr();
        result = result * 59 + ($gdpr == null ? 43 : ((Object)$gdpr).hashCode());
        Boolean $coopSync = this.getCoopSync();
        result = result * 59 + ($coopSync == null ? 43 : ((Object)$coopSync).hashCode());
        Boolean $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Set $bidders = this.getBidders();
        result = result * 59 + ($bidders == null ? 43 : ((Object)$bidders).hashCode());
        String $gdprConsent = this.getGdprConsent();
        result = result * 59 + ($gdprConsent == null ? 43 : $gdprConsent.hashCode());
        String $usPrivacy = this.getUsPrivacy();
        result = result * 59 + ($usPrivacy == null ? 43 : $usPrivacy.hashCode());
        String $gpp = this.getGpp();
        result = result * 59 + ($gpp == null ? 43 : $gpp.hashCode());
        List $gppSid = this.getGppSid();
        result = result * 59 + ($gppSid == null ? 43 : ((Object)$gppSid).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        FilterSettings $filterSettings = this.getFilterSettings();
        result = result * 59 + ($filterSettings == null ? 43 : $filterSettings.hashCode());
        return result;
    }

    public String toString() {
        return "CookieSyncRequest(bidders=" + this.getBidders() + ", gdpr=" + this.getGdpr() + ", gdprConsent=" + this.getGdprConsent() + ", usPrivacy=" + this.getUsPrivacy() + ", gpp=" + this.getGpp() + ", gppSid=" + this.getGppSid() + ", coopSync=" + this.getCoopSync() + ", debug=" + this.getDebug() + ", limit=" + this.getLimit() + ", account=" + this.getAccount() + ", filterSettings=" + this.getFilterSettings() + ")";
    }
}

