/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.vendorlist;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.Metrics;
import org.prebid.server.privacy.gdpr.vendorlist.VendorListService;
import org.prebid.server.privacy.gdpr.vendorlist.proto.Vendor;
import org.prebid.server.privacy.gdpr.vendorlist.proto.VendorList;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class VendorListService {
    private static final Logger logger = LoggerFactory.getLogger(VendorListService.class);
    private static final int TCF_VERSION = 2;
    private static final String JSON_SUFFIX = ".json";
    private static final String VERSION_PLACEHOLDER = "{VERSION}";
    private final String cacheDir;
    private final String endpointTemplate;
    private final int defaultTimeoutMs;
    private final long refreshMissingListPeriodMs;
    private final boolean deprecated;
    private final Vertx vertx;
    private final FileSystem fileSystem;
    private final HttpClient httpClient;
    private final Metrics metrics;
    private final String generationVersion;
    protected final JacksonMapper mapper;
    private final Map<Integer, Map<Integer, Vendor>> cache;
    private final Map<Integer, Vendor> fallbackVendorList;
    private final Set<Integer> versionsToFallback;

    public VendorListService(String cacheDir, String endpointTemplate, int defaultTimeoutMs, long refreshMissingListPeriodMs, boolean deprecated, String fallbackVendorListPath, Vertx vertx, FileSystem fileSystem, HttpClient httpClient, Metrics metrics, String generationVersion, JacksonMapper mapper) {
        this.cacheDir = Objects.requireNonNull(cacheDir);
        this.endpointTemplate = Objects.requireNonNull(endpointTemplate);
        this.defaultTimeoutMs = defaultTimeoutMs;
        this.refreshMissingListPeriodMs = refreshMissingListPeriodMs;
        this.deprecated = deprecated;
        this.generationVersion = generationVersion;
        this.vertx = Objects.requireNonNull(vertx);
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.metrics = Objects.requireNonNull(metrics);
        this.mapper = Objects.requireNonNull(mapper);
        VendorListService.createAndCheckWritePermissionsFor((FileSystem)fileSystem, (String)cacheDir);
        this.cache = Objects.requireNonNull(this.createCache(fileSystem, cacheDir));
        Map map = this.fallbackVendorList = StringUtils.isNotBlank((CharSequence)fallbackVendorListPath) ? this.readFallbackVendorList(fallbackVendorListPath) : null;
        if (deprecated) {
            this.validateFallbackVendorListIfDeprecatedVersion();
        }
        this.versionsToFallback = this.fallbackVendorList != null ? ConcurrentHashMap.newKeySet() : null;
    }

    private void validateFallbackVendorListIfDeprecatedVersion() {
        if (Objects.isNull(this.fallbackVendorList)) {
            throw new PreBidException("No fallback vendorList for deprecated version present");
        }
    }

    public Future<Map<Integer, Vendor>> forVersion(int version) {
        if (version <= 0) {
            return Future.failedFuture((String)"TCF %d vendor list for version %s.%d not valid.".formatted(this.getTcfVersion(), this.generationVersion, version));
        }
        Map idToVendor = (Map)this.cache.get(version);
        if (idToVendor != null) {
            return Future.succeededFuture((Object)idToVendor);
        }
        int tcf = this.getTcfVersion();
        if (this.shouldFallback(version)) {
            this.metrics.updatePrivacyTcfVendorListFallbackMetric(tcf);
            return Future.succeededFuture((Object)this.fallbackVendorList);
        }
        this.metrics.updatePrivacyTcfVendorListMissingMetric(tcf);
        logger.info((Object)"TCF {0} vendor list for version {1}.{2} not found, started downloading.", new Object[]{tcf, this.generationVersion, version});
        this.fetchNewVendorListFor(version);
        return Future.failedFuture((String)"TCF %d vendor list for version %s.%d not fetched yet, try again later.".formatted(tcf, this.generationVersion, version));
    }

    private VendorList toVendorList(String content) {
        try {
            return (VendorList)this.mapper.mapper().readValue(content, VendorList.class);
        }
        catch (IOException e) {
            String message = "Cannot parse vendor list from: " + content;
            logger.error((Object)message, (Throwable)e);
            throw new PreBidException(message, (Throwable)e);
        }
    }

    private Map<Integer, Vendor> filterVendorIdToVendors(VendorList vendorList) {
        return vendorList.getVendors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isValid(VendorList vendorList) {
        return vendorList.getVendorListVersion() != null && vendorList.getLastUpdated() != null && MapUtils.isNotEmpty((Map)vendorList.getVendors()) && VendorListService.isValidVendors(vendorList.getVendors().values());
    }

    private static boolean isValidVendors(Collection<Vendor> vendors) {
        return vendors.stream().allMatch(vendor -> vendor != null && vendor.getId() != null && vendor.getPurposes() != null && vendor.getLegIntPurposes() != null && vendor.getFlexiblePurposes() != null && vendor.getSpecialPurposes() != null && vendor.getFeatures() != null && vendor.getSpecialFeatures() != null);
    }

    private int getTcfVersion() {
        return 2;
    }

    private static void createAndCheckWritePermissionsFor(FileSystem fileSystem, String dir) {
        FileProps props;
        FileProps fileProps = props = fileSystem.existsBlocking(dir) ? fileSystem.propsBlocking(dir) : null;
        if (props == null || !props.isDirectory()) {
            try {
                fileSystem.mkdirsBlocking(dir);
            }
            catch (FileSystemException e) {
                throw new PreBidException("Cannot create directory: " + dir, (Throwable)e);
            }
        } else if (!Files.isWritable(Paths.get(dir, new String[0]))) {
            throw new PreBidException("No write permissions for directory: " + dir);
        }
    }

    private Map<Integer, Map<Integer, Vendor>> createCache(FileSystem fileSystem, String cacheDir) {
        Map versionToFileContent = this.readFileSystemCache(fileSystem, cacheDir);
        ConcurrentMap cache = Caffeine.newBuilder().build().asMap();
        for (Map.Entry versionAndFileContent : versionToFileContent.entrySet()) {
            VendorList vendorList = this.toVendorList((String)versionAndFileContent.getValue());
            Map vendorIdToVendors = this.filterVendorIdToVendors(vendorList);
            cache.put(Integer.valueOf((String)versionAndFileContent.getKey()), vendorIdToVendors);
        }
        return cache;
    }

    private Map<String, String> readFileSystemCache(FileSystem fileSystem, String dir) {
        return fileSystem.readDirBlocking(dir).stream().filter(filepath -> filepath.endsWith(".json")).collect(Collectors.toMap(filepath -> StringUtils.removeEnd((String)new File((String)filepath).getName(), (String)".json"), filename -> fileSystem.readFileBlocking(filename).toString()));
    }

    private Map<Integer, Vendor> readFallbackVendorList(String fallbackVendorListPath) {
        String vendorListContent = this.fileSystem.readFileBlocking(fallbackVendorListPath).toString();
        VendorList vendorList = this.toVendorList(vendorListContent);
        if (!this.isValid(vendorList)) {
            throw new PreBidException("Fallback vendor list parsed but has invalid data: " + vendorListContent);
        }
        return this.filterVendorIdToVendors(vendorList);
    }

    private boolean shouldFallback(int version) {
        return this.deprecated || this.versionsToFallback != null && this.versionsToFallback.contains(version);
    }

    private void fetchNewVendorListFor(int version) {
        String url = this.endpointTemplate.replace("{VERSION}", String.valueOf(version));
        this.httpClient.get(url, (long)this.defaultTimeoutMs).map(response -> this.processResponse(response, version)).compose(arg_0 -> this.saveToFile(arg_0)).map(arg_0 -> this.updateCache(arg_0)).otherwise(exception -> this.handleError(exception, version));
    }

    private VendorListResult<VendorList> processResponse(HttpClientResponse response, int version) {
        int statusCode = response.getStatusCode();
        if (statusCode == HttpResponseStatus.NOT_FOUND.code()) {
            throw new MissingVendorListException("Remote server could not found vendor list with version " + this.generationVersion + "." + version);
        }
        if (statusCode != HttpResponseStatus.OK.code()) {
            throw new PreBidException("HTTP status code " + statusCode);
        }
        String body = response.getBody();
        VendorList vendorList = this.toVendorList(body);
        if (!this.isValid(vendorList)) {
            throw new PreBidException("Fetched vendor list parsed but has invalid data: " + body);
        }
        return VendorListResult.of((int)version, (String)body, (Object)vendorList);
    }

    private Future<VendorListResult<VendorList>> saveToFile(VendorListResult<VendorList> vendorListResult) {
        Promise promise = Promise.promise();
        int version = vendorListResult.getVersion();
        String filepath = new File(this.cacheDir, version + ".json").getPath();
        this.fileSystem.writeFile(filepath, Buffer.buffer((String)vendorListResult.getVendorListAsString()), result -> {
            if (result.succeeded()) {
                promise.complete((Object)vendorListResult);
            } else {
                logger.error((Object)"Could not create new vendor list for version {0}.{1}, file: {2}", result.cause(), new Object[]{this.generationVersion, version, filepath});
                promise.fail(result.cause());
            }
        });
        return promise.future();
    }

    private Void updateCache(VendorListResult<VendorList> vendorListResult) {
        int version = vendorListResult.getVersion();
        this.cache.put(version, this.filterVendorIdToVendors((VendorList)vendorListResult.getVendorList()));
        int tcf = this.getTcfVersion();
        this.metrics.updatePrivacyTcfVendorListOkMetric(tcf);
        logger.info((Object)"Created new TCF {0} vendor list for version {1}.{2}", new Object[]{tcf, this.generationVersion, version});
        this.stopUsingFallbackForVersion(version);
        return null;
    }

    private Void handleError(Throwable exception, int version) {
        int tcf = this.getTcfVersion();
        this.metrics.updatePrivacyTcfVendorListErrorMetric(tcf);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Error while obtaining TCF {0} vendor list for version {1}.{2}", exception, new Object[]{tcf, this.generationVersion, version});
        } else {
            logger.warn((Object)"Error while obtaining TCF {0} vendor list for version {1}.{2}: {3}", new Object[]{tcf, this.generationVersion, version, exception.getMessage()});
        }
        this.startUsingFallbackForVersion(version);
        return null;
    }

    private void startUsingFallbackForVersion(int version) {
        if (this.versionsToFallback == null) {
            return;
        }
        this.versionsToFallback.add(version);
        this.vertx.setTimer(this.refreshMissingListPeriodMs, ignored -> this.fetchNewVendorListFor(version));
    }

    private void stopUsingFallbackForVersion(int version) {
        if (this.versionsToFallback == null) {
            return;
        }
        this.versionsToFallback.remove(version);
    }
}

