/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.ccpa;

import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Ccpa {
    public static final Ccpa EMPTY = Ccpa.of(null);
    private static final int LENGTH = 4;
    private static final int VERSION_INDEX = 0;
    private static final int EXPLICIT_NOTICE_INDEX = 1;
    private static final int OPT_OUT_SALE_INDEX = 2;
    private static final int SERVICE_PROVIDER_AGREEMENT_INDEX = 3;
    private static final String ENFORCED_SIGNAL = "Y";
    private static final String NOT_ENFORCED_SIGNAL = "N";
    private static final String NOT_DEFINED_SIGNAL = "-";
    private final String usPrivacy;

    public boolean isNotEmpty() {
        return StringUtils.isNotEmpty((CharSequence)this.usPrivacy);
    }

    public boolean isEnforced() {
        try {
            Ccpa.validateUsPrivacy((String)this.usPrivacy);
        }
        catch (PreBidException e) {
            return false;
        }
        String optOutSale = Character.toString(this.usPrivacy.charAt(2));
        return StringUtils.equalsIgnoreCase((CharSequence)optOutSale, (CharSequence)"Y");
    }

    public static boolean isValid(String consent) {
        try {
            Ccpa.validateUsPrivacy((String)consent);
            return true;
        }
        catch (PreBidException e) {
            return false;
        }
    }

    public static void validateUsPrivacy(String consent) {
        if (StringUtils.length((CharSequence)consent) != 4) {
            throw new PreBidException("us_privacy must contain 4 characters");
        }
        if (consent.charAt(0) != '1') {
            throw new PreBidException("us_privacy must specify version 1");
        }
        Ccpa.agreementSpecified((char)consent.charAt(1), (String)"explicit notice");
        Ccpa.agreementSpecified((char)consent.charAt(2), (String)"opt-out sale");
        Ccpa.agreementSpecified((char)consent.charAt(3), (String)"limited service provider agreement");
    }

    private static void agreementSpecified(char agreement, String agreementType) {
        boolean isAppropriateValue = StringUtils.equalsAnyIgnoreCase((CharSequence)Character.toString(agreement), (CharSequence[])new CharSequence[]{"N", "Y", "-"});
        if (!isAppropriateValue) {
            throw new PreBidException("us_privacy must specify 'N' or 'n', 'Y' or 'y', '-' for the " + agreementType);
        }
    }

    @ConstructorProperties(value={"usPrivacy"})
    private Ccpa(String usPrivacy) {
        this.usPrivacy = usPrivacy;
    }

    public static Ccpa of(String usPrivacy) {
        return new Ccpa(usPrivacy);
    }

    public String getUsPrivacy() {
        return this.usPrivacy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ccpa)) {
            return false;
        }
        Ccpa other = (Ccpa)o;
        String this$usPrivacy = this.getUsPrivacy();
        String other$usPrivacy = other.getUsPrivacy();
        return !(this$usPrivacy == null ? other$usPrivacy != null : !this$usPrivacy.equals(other$usPrivacy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $usPrivacy = this.getUsPrivacy();
        result = result * 59 + ($usPrivacy == null ? 43 : $usPrivacy.hashCode());
        return result;
    }

    public String toString() {
        return "Ccpa(usPrivacy=" + this.getUsPrivacy() + ")";
    }
}

