/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.ResettingCounter;
import org.prebid.server.metric.UpdatableMetrics;

class UpdatableMetrics {
    private final MetricRegistry metricRegistry;
    private final Function<MetricName, String> nameCreator;
    private final MetricIncrementer incrementer;
    private final CounterType counterType;
    private final Map<MetricName, String> metricNames;

    UpdatableMetrics(MetricRegistry metricRegistry, CounterType counterType, Function<MetricName, String> nameCreator) {
        this.metricRegistry = metricRegistry;
        this.counterType = counterType;
        this.nameCreator = nameCreator;
        this.metricNames = new EnumMap(MetricName.class);
        this.incrementer = switch (1.$SwitchMap$org$prebid$server$metric$CounterType[counterType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> (registry, metricName, value) -> registry.counter(metricName, ResettingCounter::new).inc(value);
            case 2 -> (registry, metricName, value) -> registry.counter(metricName).inc(value);
            case 3 -> (registry, metricName, value) -> registry.meter(metricName).mark(value);
        };
    }

    void incCounter(MetricName metricName) {
        this.incCounter(metricName, 1L);
    }

    void incCounter(MetricName metricName, long value) {
        this.incrementer.accept(this.metricRegistry, this.name(metricName), value);
    }

    void updateTimer(MetricName metricName, long millis) {
        this.metricRegistry.timer(this.name(metricName)).update(millis, TimeUnit.MILLISECONDS);
    }

    void updateHistogram(MetricName metricName, long value) {
        this.metricRegistry.histogram(this.name(metricName)).update(value);
    }

    void createGauge(MetricName metricName, LongSupplier supplier) {
        this.metricRegistry.gauge(this.name(metricName), () -> supplier::getAsLong);
    }

    void removeMetric(MetricName metricName) {
        this.metricRegistry.remove(this.name(metricName));
    }

    private String name(MetricName metricName) {
        return this.metricNames.computeIfAbsent(metricName, key -> (String)this.nameCreator.apply(metricName));
    }

    public CounterType getCounterType() {
        return this.counterType;
    }
}

