/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.prebid.server.metric.model.AccountMetricsVerbosityLevel;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountMetricsConfig;

public class AccountMetricsVerbosityResolver {
    private final AccountMetricsVerbosityLevel defaultVerbosity;
    private final Map<String, AccountMetricsVerbosityLevel> accountVerbosityLevels;

    public AccountMetricsVerbosityResolver(AccountMetricsVerbosityLevel defaultVerbosity, List<String> basicVerbosity, List<String> detailedVerbosity) {
        this.defaultVerbosity = Objects.requireNonNull(defaultVerbosity);
        this.accountVerbosityLevels = new HashMap();
        Objects.requireNonNull(basicVerbosity).forEach(accountId -> this.accountVerbosityLevels.put(accountId, AccountMetricsVerbosityLevel.basic));
        Objects.requireNonNull(detailedVerbosity).forEach(accountId -> this.accountVerbosityLevels.put(accountId, AccountMetricsVerbosityLevel.detailed));
    }

    public AccountMetricsVerbosityLevel forAccount(Account account) {
        AccountMetricsConfig metricsConfig = account.getMetrics();
        AccountMetricsVerbosityLevel accountVerbosity = metricsConfig != null ? metricsConfig.getVerbosityLevel() : null;
        return accountVerbosity != null ? accountVerbosity : this.accountVerbosityLevels.getOrDefault(account.getId(), this.defaultVerbosity);
    }
}

