/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import io.vertx.core.logging.Logger;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.prebid.server.log.Criteria;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Criteria {
    private static final String TAG_SEPARATOR = "-";
    private static final String TAGGED_MESSAGE_PATTERN = "[%s]: %s";
    private static final String TAGGED_RESPONSE_PATTERN = "[%s]: %s - %s";
    public static final String BID_RESPONSE = "BidResponse";
    public static final String RESOLVED_BID_REQUEST = "Resolved BidRequest";
    private final String account;
    private final String bidder;
    private final String lineItemId;
    private final String tag;
    private final BiConsumer<Logger, Object> loggerLevel;

    public static Criteria create(String account, String bidder, String lineItemId, BiConsumer<Logger, Object> loggerLevel) {
        return new Criteria(account, bidder, lineItemId, Criteria.makeTag((String)account, (String)bidder, (String)lineItemId), loggerLevel);
    }

    public void log(Criteria criteria, Logger logger, Object message, Consumer<Object> defaultLogger) {
        if (this.isMatched(criteria)) {
            this.loggerLevel.accept(logger, "[%s]: %s".formatted(this.tag, message));
        } else {
            defaultLogger.accept(message);
        }
    }

    public void logResponse(String bidResponse, Logger logger) {
        if (this.isMatchedToString(bidResponse)) {
            this.loggerLevel.accept(logger, "[%s]: %s - %s".formatted(this.tag, "BidResponse", bidResponse));
        }
    }

    public void logResponseAndRequest(String bidResponse, String bidRequest, Logger logger) {
        if (this.isMatchedToString(bidResponse + bidRequest)) {
            this.loggerLevel.accept(logger, "[%s]: %s - %s".formatted(this.tag, "BidResponse", bidResponse));
            this.loggerLevel.accept(logger, "[%s]: %s - %s".formatted(this.tag, "Resolved BidRequest", bidRequest));
        }
    }

    private boolean isMatched(Criteria criteria) {
        return !(criteria == null || this.account != null && !this.account.equals(criteria.account) || this.bidder != null && !this.bidder.equals(criteria.bidder) || this.lineItemId != null && !this.lineItemId.equals(criteria.lineItemId));
    }

    private boolean isMatchedToString(String value) {
        return !(this.account != null && !value.contains(this.account) || this.bidder != null && !value.contains(this.bidder) || this.lineItemId != null && !value.contains(this.lineItemId));
    }

    private static String makeTag(String account, String bidder, String lineItemId) {
        return Stream.of(account, bidder, lineItemId).filter(Objects::nonNull).collect(Collectors.joining("-"));
    }

    public static CriteriaBuilder builder() {
        return new CriteriaBuilder();
    }

    public String getAccount() {
        return this.account;
    }

    public String getBidder() {
        return this.bidder;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public String getTag() {
        return this.tag;
    }

    public BiConsumer<Logger, Object> getLoggerLevel() {
        return this.loggerLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Criteria)) {
            return false;
        }
        Criteria other = (Criteria)o;
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$bidder = this.getBidder();
        String other$bidder = other.getBidder();
        if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
            return false;
        }
        String this$lineItemId = this.getLineItemId();
        String other$lineItemId = other.getLineItemId();
        if (this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        BiConsumer this$loggerLevel = this.getLoggerLevel();
        BiConsumer other$loggerLevel = other.getLoggerLevel();
        return !(this$loggerLevel == null ? other$loggerLevel != null : !this$loggerLevel.equals(other$loggerLevel));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $bidder = this.getBidder();
        result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
        String $lineItemId = this.getLineItemId();
        result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        BiConsumer $loggerLevel = this.getLoggerLevel();
        result = result * 59 + ($loggerLevel == null ? 43 : $loggerLevel.hashCode());
        return result;
    }

    public String toString() {
        return "Criteria(account=" + this.getAccount() + ", bidder=" + this.getBidder() + ", lineItemId=" + this.getLineItemId() + ", tag=" + this.getTag() + ", loggerLevel=" + this.getLoggerLevel() + ")";
    }

    @ConstructorProperties(value={"account", "bidder", "lineItemId", "tag", "loggerLevel"})
    public Criteria(String account, String bidder, String lineItemId, String tag, BiConsumer<Logger, Object> loggerLevel) {
        this.account = account;
        this.bidder = bidder;
        this.lineItemId = lineItemId;
        this.tag = tag;
        this.loggerLevel = loggerLevel;
    }
}

