/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.prebid.server.json.deserializer.IntegerFlagDeserializer;

public class IntegerFlagDeserializer
extends StdDeserializer<Integer> {
    public IntegerFlagDeserializer() {
        super(Integer.class);
    }

    public Integer deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        return switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[parser.getCurrentToken().ordinal()]) {
            case 1 -> parser.getValueAsInt();
            case 2 -> 0;
            case 3 -> 1;
            default -> {
                ctxt.reportWrongTokenException(JsonToken.class, JsonToken.VALUE_NUMBER_INT, "Failed to parse field %s to Integer type with a reason: Expected type boolean or integer(`0` or `1`).".formatted(parser.getCurrentName()), new Object[0]);
                throw new AssertionError();
            }
        };
    }
}

