/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommaSeparatedStringAsListOfIntegersDeserializer
extends StdDeserializer<List<Integer>> {
    public CommaSeparatedStringAsListOfIntegersDeserializer() {
        super(List.class);
    }

    public List<Integer> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String value;
        if (parser.getCurrentToken() != JsonToken.VALUE_STRING) {
            CommaSeparatedStringAsListOfIntegersDeserializer.reportWrongTokenException((JsonParser)parser, (DeserializationContext)context);
        }
        if ((value = parser.getValueAsString()) == null) {
            CommaSeparatedStringAsListOfIntegersDeserializer.reportWrongTokenException((JsonParser)parser, (DeserializationContext)context);
        }
        try {
            return CommaSeparatedStringAsListOfIntegersDeserializer.parseList((String)value);
        }
        catch (NumberFormatException e) {
            CommaSeparatedStringAsListOfIntegersDeserializer.reportPropertyInputMismatch((JsonParser)parser, (DeserializationContext)context, (String)e.getMessage());
            throw new AssertionError();
        }
    }

    private static void reportWrongTokenException(JsonParser parser, DeserializationContext context) throws IOException {
        context.reportWrongTokenException(JsonToken.class, JsonToken.VALUE_STRING, "Failed to parse field %s to List<Integer> type with a reason: Expected comma-separated string.".formatted(parser.getCurrentName()), new Object[0]);
    }

    private static List<Integer> parseList(String value) throws NumberFormatException {
        return Arrays.stream(value.split(",")).map(StringUtils::strip).filter(StringUtils::isNotBlank).map(Integer::parseInt).toList();
    }

    private static void reportPropertyInputMismatch(JsonParser parser, DeserializationContext context, String cause) throws IOException {
        context.reportPropertyInputMismatch(JsonToken.class, parser.getCurrentName(), "Failed to parse field %s to List<Integer> type with a reason: NumberFormatException %s".formatted(parser.getCurrentName(), cause), new Object[0]);
    }
}

