/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.health;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.jdbc.JDBCClient;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.prebid.server.health.PeriodicHealthChecker;
import org.prebid.server.health.model.Status;
import org.prebid.server.health.model.StatusResponse;

public class DatabaseHealthChecker
extends PeriodicHealthChecker {
    private static final String NAME = "database";
    private final JDBCClient jdbcClient;
    private StatusResponse status;

    public DatabaseHealthChecker(Vertx vertx, JDBCClient jdbcClient, long refreshPeriod) {
        super(vertx, refreshPeriod);
        this.jdbcClient = Objects.requireNonNull(jdbcClient);
    }

    public StatusResponse status() {
        return this.status;
    }

    public String name() {
        return NAME;
    }

    void updateStatus() {
        Promise connectionPromise = Promise.promise();
        this.jdbcClient.getConnection((Handler)connectionPromise);
        connectionPromise.future().onComplete(result -> {
            this.status = StatusResponse.of((String)(result.succeeded() ? Status.UP.name() : Status.DOWN.name()), (ZonedDateTime)ZonedDateTime.now(Clock.systemUTC()));
        });
    }
}

