/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler.openrtb2;

import com.iab.openrtb.request.BidRequest;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.time.Clock;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.prebid.server.analytics.model.AuctionEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.ExchangeService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.requestfactory.AuctionRequestFactory;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.exception.BlacklistedAccountException;
import org.prebid.server.exception.BlacklistedAppException;
import org.prebid.server.exception.InvalidAccountConfigException;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.UnauthorizedAccountException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.log.HttpInteractionLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.version.PrebidVersionProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuctionHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(AuctionHandler.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private final double logSamplingRate;
    private final AuctionRequestFactory auctionRequestFactory;
    private final ExchangeService exchangeService;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final Metrics metrics;
    private final Clock clock;
    private final HttpInteractionLogger httpInteractionLogger;
    private final PrebidVersionProvider prebidVersionProvider;
    private final JacksonMapper mapper;

    public AuctionHandler(double logSamplingRate, AuctionRequestFactory auctionRequestFactory, ExchangeService exchangeService, AnalyticsReporterDelegator analyticsDelegator, Metrics metrics, Clock clock, HttpInteractionLogger httpInteractionLogger, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        this.logSamplingRate = logSamplingRate;
        this.auctionRequestFactory = Objects.requireNonNull(auctionRequestFactory);
        this.exchangeService = Objects.requireNonNull(exchangeService);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
        this.httpInteractionLogger = Objects.requireNonNull(httpInteractionLogger);
        this.prebidVersionProvider = Objects.requireNonNull(prebidVersionProvider);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        long startTime = this.clock.millis();
        AuctionEvent.AuctionEventBuilder auctionEventBuilder = AuctionEvent.builder().httpContext(HttpRequestContext.from((RoutingContext)routingContext));
        this.auctionRequestFactory.fromRequest(routingContext, startTime).map(arg_0 -> this.updateAppAndNoCookieAndImpsMetrics(arg_0)).map(context -> (AuctionContext)AuctionHandler.addToEvent((Object)context, arg_0 -> ((AuctionEvent.AuctionEventBuilder)auctionEventBuilder).auctionContext(arg_0), (Object)context)).compose(arg_0 -> ((ExchangeService)this.exchangeService).holdAuction(arg_0)).map(context -> (AuctionContext)AuctionHandler.addToEvent((Object)context, arg_0 -> ((AuctionEvent.AuctionEventBuilder)auctionEventBuilder).auctionContext(arg_0), (Object)context)).map(context -> (AuctionContext)AuctionHandler.addToEvent((Object)context.getBidResponse(), arg_0 -> ((AuctionEvent.AuctionEventBuilder)auctionEventBuilder).bidResponse(arg_0), (Object)context)).onComplete(context -> this.handleResult(context, auctionEventBuilder, routingContext, startTime));
    }

    private static <T, R> R addToEvent(T field, Consumer<T> consumer, R result) {
        consumer.accept(field);
        return result;
    }

    private AuctionContext updateAppAndNoCookieAndImpsMetrics(AuctionContext context) {
        if (!context.isRequestRejected()) {
            BidRequest bidRequest = context.getBidRequest();
            UidsCookie uidsCookie = context.getUidsCookie();
            List imps = bidRequest.getImp();
            this.metrics.updateAppAndNoCookieAndImpsRequestedMetrics(bidRequest.getApp() != null, uidsCookie.hasLiveUids(), imps.size());
            this.metrics.updateImpTypesMetrics(imps);
        }
        return context;
    }

    private void handleResult(AsyncResult<AuctionContext> responseResult, AuctionEvent.AuctionEventBuilder auctionEventBuilder, RoutingContext routingContext, long startTime) {
        Object body;
        HttpResponseStatus status;
        List<Object> errorMessages;
        MetricName metricRequestStatus;
        boolean responseSucceeded = responseResult.succeeded();
        AuctionContext auctionContext = responseSucceeded ? (AuctionContext)responseResult.result() : null;
        MetricName requestType = responseSucceeded ? auctionContext.getRequestTypeMetric() : MetricName.openrtb2web;
        HttpServerResponse response = routingContext.response();
        this.enrichWithCommonHeaders(response);
        if (responseSucceeded) {
            metricRequestStatus = MetricName.ok;
            errorMessages = Collections.emptyList();
            status = HttpResponseStatus.OK;
            this.enrichWithSuccessfulHeaders(response);
            body = this.mapper.encodeToString((Object)((AuctionContext)responseResult.result()).getBidResponse());
        } else {
            Throwable exception = responseResult.cause();
            if (exception instanceof InvalidRequestException) {
                InvalidRequestException invalidRequestException = (InvalidRequestException)exception;
                metricRequestStatus = MetricName.badinput;
                errorMessages = invalidRequestException.getMessages().stream().map(msg -> "Invalid request format: " + msg).toList();
                message = String.join((CharSequence)"\n", errorMessages);
                String referer = routingContext.request().headers().get(HttpUtil.REFERER_HEADER);
                conditionalLogger.info("%s, Referer: %s".formatted(message, referer), this.logSamplingRate);
                status = HttpResponseStatus.BAD_REQUEST;
                body = message;
            } else if (exception instanceof UnauthorizedAccountException) {
                metricRequestStatus = MetricName.badinput;
                message = exception.getMessage();
                conditionalLogger.info((String)message, this.logSamplingRate);
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.UNAUTHORIZED;
                body = message;
            } else if (exception instanceof BlacklistedAppException || exception instanceof BlacklistedAccountException) {
                metricRequestStatus = exception instanceof BlacklistedAccountException ? MetricName.blacklisted_account : MetricName.blacklisted_app;
                message = "Blacklisted: " + exception.getMessage();
                logger.debug(message);
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.FORBIDDEN;
                body = message;
            } else if (exception instanceof InvalidAccountConfigException) {
                metricRequestStatus = MetricName.bad_requests;
                message = exception.getMessage();
                conditionalLogger.error(exception.getMessage(), this.logSamplingRate);
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.BAD_REQUEST;
                body = message;
            } else {
                metricRequestStatus = MetricName.err;
                logger.error((Object)"Critical error while running the auction", exception);
                message = exception.getMessage();
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                body = "Critical error while running the auction: " + (String)message;
            }
        }
        AuctionEvent auctionEvent = auctionEventBuilder.status(Integer.valueOf(status.code())).errors(errorMessages).build();
        PrivacyContext privacyContext = auctionContext != null ? auctionContext.getPrivacyContext() : null;
        TcfContext tcfContext = privacyContext != null ? privacyContext.getTcfContext() : TcfContext.empty();
        this.respondWith(routingContext, status, (String)body, startTime, requestType, metricRequestStatus, auctionEvent, tcfContext);
        this.httpInteractionLogger.maybeLogOpenrtb2Auction(auctionContext, routingContext, status.code(), (String)body);
    }

    private void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body, long startTime, MetricName requestType, MetricName metricRequestStatus, AuctionEvent event, TcfContext tcfContext) {
        boolean responseSent = HttpUtil.executeSafely((RoutingContext)routingContext, (Endpoint)Endpoint.openrtb2_auction, response -> response.exceptionHandler(throwable -> this.handleResponseException(throwable, requestType)).setStatusCode(status.code()).end(body));
        if (responseSent) {
            this.metrics.updateRequestTimeMetric(MetricName.request_time, this.clock.millis() - startTime);
            this.metrics.updateRequestTypeMetric(requestType, metricRequestStatus);
            this.analyticsDelegator.processEvent((Object)event, tcfContext);
        } else {
            this.metrics.updateRequestTypeMetric(requestType, MetricName.networkerr);
        }
    }

    private void handleResponseException(Throwable throwable, MetricName requestType) {
        logger.warn((Object)"Failed to send auction response: {0}", new Object[]{throwable.getMessage()});
        this.metrics.updateRequestTypeMetric(requestType, MetricName.networkerr);
    }

    private void enrichWithCommonHeaders(HttpServerResponse response) {
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)response.headers(), (CharSequence)HttpUtil.X_PREBID_HEADER, (CharSequence)this.prebidVersionProvider.getNameVersionRecord());
    }

    private void enrichWithSuccessfulHeaders(HttpServerResponse response) {
        response.headers().add(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
    }
}

