/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler.openrtb2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.analytics.model.AmpEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.AmpResponsePostProcessor;
import org.prebid.server.auction.ExchangeService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.Tuple2;
import org.prebid.server.auction.requestfactory.AmpRequestFactory;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.exception.BlacklistedAccountException;
import org.prebid.server.exception.BlacklistedAppException;
import org.prebid.server.exception.InvalidAccountConfigException;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.exception.UnauthorizedAccountException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.log.HttpInteractionLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponse;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponsePrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtModules;
import org.prebid.server.proto.openrtb.ext.response.ExtResponseDebug;
import org.prebid.server.proto.response.AmpResponse;
import org.prebid.server.proto.response.ExtAmpVideoPrebid;
import org.prebid.server.proto.response.ExtAmpVideoResponse;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.version.PrebidVersionProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class AmpHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(AmpHandler.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    public static final String PREBID_EXT = "prebid";
    private static final MetricName REQUEST_TYPE_METRIC = MetricName.amp;
    private final AmpRequestFactory ampRequestFactory;
    private final ExchangeService exchangeService;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final Metrics metrics;
    private final Clock clock;
    private final BidderCatalog bidderCatalog;
    private final Set<String> biddersSupportingCustomTargeting;
    private final AmpResponsePostProcessor ampResponsePostProcessor;
    private final HttpInteractionLogger httpInteractionLogger;
    private final PrebidVersionProvider prebidVersionProvider;
    private final JacksonMapper mapper;
    private final double logSamplingRate;

    public AmpHandler(AmpRequestFactory ampRequestFactory, ExchangeService exchangeService, AnalyticsReporterDelegator analyticsDelegator, Metrics metrics, Clock clock, BidderCatalog bidderCatalog, Set<String> biddersSupportingCustomTargeting, AmpResponsePostProcessor ampResponsePostProcessor, HttpInteractionLogger httpInteractionLogger, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper, double logSamplingRate) {
        this.ampRequestFactory = Objects.requireNonNull(ampRequestFactory);
        this.exchangeService = Objects.requireNonNull(exchangeService);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.biddersSupportingCustomTargeting = Objects.requireNonNull(biddersSupportingCustomTargeting);
        this.ampResponsePostProcessor = Objects.requireNonNull(ampResponsePostProcessor);
        this.httpInteractionLogger = Objects.requireNonNull(httpInteractionLogger);
        this.prebidVersionProvider = Objects.requireNonNull(prebidVersionProvider);
        this.mapper = Objects.requireNonNull(mapper);
        this.logSamplingRate = logSamplingRate;
    }

    public void handle(RoutingContext routingContext) {
        long startTime = this.clock.millis();
        AmpEvent.AmpEventBuilder ampEventBuilder = AmpEvent.builder().httpContext(HttpRequestContext.from((RoutingContext)routingContext));
        this.ampRequestFactory.fromRequest(routingContext, startTime).map(context -> (AuctionContext)AmpHandler.addToEvent((Object)context, arg_0 -> ((AmpEvent.AmpEventBuilder)ampEventBuilder).auctionContext(arg_0), (Object)context)).map(arg_0 -> this.updateAppAndNoCookieAndImpsMetrics(arg_0)).compose(arg_0 -> ((ExchangeService)this.exchangeService).holdAuction(arg_0)).map(context -> (AuctionContext)AmpHandler.addToEvent((Object)context, arg_0 -> ((AmpEvent.AmpEventBuilder)ampEventBuilder).auctionContext(arg_0), (Object)context)).map(context -> (AuctionContext)AmpHandler.addToEvent((Object)context.getBidResponse(), arg_0 -> ((AmpEvent.AmpEventBuilder)ampEventBuilder).bidResponse(arg_0), (Object)context)).compose(context -> this.prepareAmpResponse(context, routingContext)).map(result -> (Tuple2)AmpHandler.addToEvent((Object)((AmpResponse)result.getLeft()).getTargeting(), arg_0 -> ((AmpEvent.AmpEventBuilder)ampEventBuilder).targeting(arg_0), (Object)result)).onComplete(responseResult -> this.handleResult(responseResult, ampEventBuilder, routingContext, startTime));
    }

    private static <T, R> R addToEvent(T field, Consumer<T> consumer, R result) {
        consumer.accept(field);
        return result;
    }

    private AuctionContext updateAppAndNoCookieAndImpsMetrics(AuctionContext context) {
        if (!context.isRequestRejected()) {
            BidRequest bidRequest = context.getBidRequest();
            UidsCookie uidsCookie = context.getUidsCookie();
            List imps = bidRequest.getImp();
            this.metrics.updateAppAndNoCookieAndImpsRequestedMetrics(bidRequest.getApp() != null, uidsCookie.hasLiveUids(), imps.size());
            this.metrics.updateImpTypesMetrics(imps);
        }
        return context;
    }

    private Future<Tuple2<AmpResponse, AuctionContext>> prepareAmpResponse(AuctionContext context, RoutingContext routingContext) {
        BidRequest bidRequest = context.getBidRequest();
        BidResponse bidResponse = context.getBidResponse();
        AmpResponse ampResponse = this.toAmpResponse(bidResponse);
        return this.ampResponsePostProcessor.postProcess(bidRequest, bidResponse, ampResponse, routingContext).map(resultAmpResponse -> Tuple2.of((Object)resultAmpResponse, (Object)context));
    }

    private Map<String, String> targetingFrom(Bid bid, String bidder) {
        Map targeting;
        ExtBidPrebid extBidPrebid;
        ObjectNode bidExt = bid.getExt();
        if (bidExt == null || !bidExt.hasNonNull("prebid")) {
            return Collections.emptyMap();
        }
        try {
            extBidPrebid = (ExtBidPrebid)this.mapper.mapper().convertValue((Object)bidExt.get("prebid"), ExtBidPrebid.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Critical error while unpacking AMP targets: " + e.getMessage(), (Throwable)e);
        }
        Map map = targeting = extBidPrebid != null ? extBidPrebid.getTargeting() : null;
        if (targeting != null && targeting.keySet().stream().anyMatch(key -> key != null && key.startsWith("hb_cache_id"))) {
            return this.enrichWithCustomTargeting(targeting, bidExt, bidder);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> enrichWithCustomTargeting(Map<String, String> targeting, ObjectNode bidExt, String bidder) {
        Map customTargeting = this.customTargetingFrom(bidExt, bidder);
        if (!customTargeting.isEmpty()) {
            HashMap<String, String> enrichedTargeting = new HashMap<String, String>(targeting);
            enrichedTargeting.putAll(customTargeting);
            return enrichedTargeting;
        }
        return targeting;
    }

    private Map<String, String> customTargetingFrom(ObjectNode extBidBidder, String bidder) {
        if (extBidBidder != null && this.biddersSupportingCustomTargeting.contains(bidder) && this.bidderCatalog.isValidName(bidder)) {
            return this.bidderCatalog.bidderByName(bidder).extractTargeting(extBidBidder);
        }
        return Collections.emptyMap();
    }

    private AmpResponse toAmpResponse(BidResponse bidResponse) {
        List seatBids = bidResponse.getSeatbid();
        HashMap targeting = new HashMap(seatBids == null ? Collections.emptyMap() : seatBids.stream().filter(Objects::nonNull).filter(seatBid -> seatBid.getBid() != null).flatMap(seatBid -> seatBid.getBid().stream().filter(Objects::nonNull).flatMap(bid -> this.targetingFrom(bid, seatBid.getSeat()).entrySet().stream())).map(entry -> Tuple2.of((Object)((String)entry.getKey()), (Object)TextNode.valueOf((String)((String)entry.getValue())))).collect(Collectors.toMap(Tuple2::getLeft, Tuple2::getRight, (value1, value2) -> value2)));
        Map additionalTargeting = this.extractAdditionalTargeting(bidResponse);
        targeting.putAll(additionalTargeting);
        return AmpResponse.of(targeting, (ExtAmpVideoResponse)AmpHandler.extResponseFrom((BidResponse)bidResponse));
    }

    private Map<String, JsonNode> extractAdditionalTargeting(BidResponse bidResponse) {
        ExtBidResponse extBidResponse = bidResponse.getExt();
        ExtBidResponsePrebid prebid = extBidResponse != null ? extBidResponse.getPrebid() : null;
        Map<String, JsonNode> targeting = prebid != null ? prebid.getTargeting() : null;
        return targeting != null ? targeting : Collections.emptyMap();
    }

    private static ExtAmpVideoResponse extResponseFrom(BidResponse bidResponse) {
        ExtBidResponse ext = bidResponse.getExt();
        ExtBidResponsePrebid extPrebid = ext != null ? ext.getPrebid() : null;
        ExtResponseDebug extDebug = ext != null ? ext.getDebug() : null;
        Map extErrors = ext != null ? ext.getErrors() : null;
        Map extWarnings = ext != null ? ext.getWarnings() : null;
        ExtModules extModules = extPrebid != null ? extPrebid.getModules() : null;
        ExtAmpVideoPrebid extAmpVideoPrebid = extModules != null ? ExtAmpVideoPrebid.of((ExtModules)extModules) : null;
        return ObjectUtils.anyNotNull((Object[])new Object[]{extDebug, extErrors, extWarnings, extAmpVideoPrebid}) ? ExtAmpVideoResponse.of((ExtResponseDebug)extDebug, (Map)extErrors, (Map)extWarnings, (ExtAmpVideoPrebid)extAmpVideoPrebid) : null;
    }

    private void handleResult(AsyncResult<Tuple2<AmpResponse, AuctionContext>> responseResult, AmpEvent.AmpEventBuilder ampEventBuilder, RoutingContext routingContext, long startTime) {
        Object body;
        HttpResponseStatus status;
        List<Object> errorMessages;
        MetricName metricRequestStatus;
        boolean responseSucceeded = responseResult.succeeded();
        String origin = AmpHandler.originFrom((RoutingContext)routingContext);
        ampEventBuilder.origin(origin);
        HttpServerResponse response = routingContext.response();
        this.enrichWithCommonHeaders(response, origin);
        if (responseSucceeded) {
            metricRequestStatus = MetricName.ok;
            errorMessages = Collections.emptyList();
            status = HttpResponseStatus.OK;
            this.enrichWithSuccessfulHeaders(response);
            body = this.mapper.encodeToString((Object)((AmpResponse)((Tuple2)responseResult.result()).getLeft()));
        } else {
            Throwable exception = responseResult.cause();
            if (exception instanceof InvalidRequestException) {
                InvalidRequestException invalidRequestException = (InvalidRequestException)exception;
                metricRequestStatus = MetricName.badinput;
                errorMessages = invalidRequestException.getMessages().stream().map(msg -> "Invalid request format: " + msg).toList();
                message = String.join((CharSequence)"\n", errorMessages);
                conditionalLogger.info("%s, Referer: %s".formatted(message, routingContext.request().headers().get(HttpUtil.REFERER_HEADER)), 100);
                status = HttpResponseStatus.BAD_REQUEST;
                body = message;
            } else if (exception instanceof UnauthorizedAccountException) {
                metricRequestStatus = MetricName.badinput;
                message = exception.getMessage();
                conditionalLogger.info((String)message, 100);
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.UNAUTHORIZED;
                body = message;
            } else if (exception instanceof BlacklistedAppException || exception instanceof BlacklistedAccountException) {
                metricRequestStatus = exception instanceof BlacklistedAccountException ? MetricName.blacklisted_account : MetricName.blacklisted_app;
                message = "Blacklisted: " + exception.getMessage();
                logger.debug(message);
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.FORBIDDEN;
                body = message;
            } else if (exception instanceof InvalidAccountConfigException) {
                metricRequestStatus = MetricName.bad_requests;
                message = exception.getMessage();
                conditionalLogger.error((String)message, this.logSamplingRate);
                errorMessages = Collections.singletonList(message);
                status = HttpResponseStatus.BAD_REQUEST;
                body = "Invalid account configuration: " + (String)message;
            } else {
                message = exception.getMessage();
                metricRequestStatus = MetricName.err;
                errorMessages = Collections.singletonList(message);
                logger.error((Object)"Critical error while running the auction", exception);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                body = "Critical error while running the auction: " + (String)message;
            }
        }
        int statusCode = status.code();
        AmpEvent ampEvent = ampEventBuilder.status(Integer.valueOf(statusCode)).errors(errorMessages).build();
        AuctionContext auctionContext = responseSucceeded ? (AuctionContext)((Tuple2)responseResult.result()).getRight() : null;
        PrivacyContext privacyContext = auctionContext != null ? auctionContext.getPrivacyContext() : null;
        TcfContext tcfContext = privacyContext != null ? privacyContext.getTcfContext() : TcfContext.empty();
        this.respondWith(routingContext, status, (String)body, startTime, metricRequestStatus, ampEvent, tcfContext);
        this.httpInteractionLogger.maybeLogOpenrtb2Amp(auctionContext, routingContext, statusCode, (String)body);
    }

    private static String originFrom(RoutingContext routingContext) {
        String origin = null;
        List ampSourceOrigin = routingContext.queryParam("__amp_source_origin");
        if (CollectionUtils.isNotEmpty((Collection)ampSourceOrigin)) {
            origin = (String)ampSourceOrigin.get(0);
        }
        if (origin == null) {
            origin = (String)ObjectUtils.defaultIfNull((Object)routingContext.request().headers().get("Origin"), (Object)"");
        }
        return origin;
    }

    private void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body, long startTime, MetricName metricRequestStatus, AmpEvent event, TcfContext tcfContext) {
        boolean responseSent = HttpUtil.executeSafely((RoutingContext)routingContext, (Endpoint)Endpoint.openrtb2_amp, response -> response.exceptionHandler(arg_0 -> this.handleResponseException(arg_0)).setStatusCode(status.code()).end(body));
        if (responseSent) {
            this.metrics.updateRequestTimeMetric(MetricName.request_time, this.clock.millis() - startTime);
            this.metrics.updateRequestTypeMetric(REQUEST_TYPE_METRIC, metricRequestStatus);
            this.analyticsDelegator.processEvent((Object)event, tcfContext);
        } else {
            this.metrics.updateRequestTypeMetric(REQUEST_TYPE_METRIC, MetricName.networkerr);
        }
    }

    private void handleResponseException(Throwable exception) {
        logger.warn((Object)"Failed to send amp response: {0}", new Object[]{exception.getMessage()});
        this.metrics.updateRequestTypeMetric(REQUEST_TYPE_METRIC, MetricName.networkerr);
    }

    private void enrichWithCommonHeaders(HttpServerResponse response, String origin) {
        MultiMap headers = response.headers();
        headers.add("AMP-Access-Control-Allow-Source-Origin", origin).add("Access-Control-Expose-Headers", "AMP-Access-Control-Allow-Source-Origin");
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_PREBID_HEADER, (CharSequence)this.prebidVersionProvider.getNameVersionRecord());
    }

    private void enrichWithSuccessfulHeaders(HttpServerResponse response) {
        MultiMap headers = response.headers();
        headers.add(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
    }
}

