/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.handler.VersionHandler;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class VersionHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(VersionHandler.class);
    private final String endpoint;
    private final String revisionResponseBody;

    public VersionHandler(String version, String commitHash, JacksonMapper mapper, String endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint);
        this.revisionResponseBody = VersionHandler.createRevisionResponseBody((String)version, (String)commitHash, (JacksonMapper)mapper);
    }

    private static String createRevisionResponseBody(String version, String commitHash, JacksonMapper mapper) {
        try {
            return mapper.mapper().writeValueAsString((Object)RevisionResponse.of((String)commitHash, (String)version));
        }
        catch (JsonProcessingException e) {
            logger.error((Object)"/version Critical error when trying to marshal revision response: %s", new Object[]{e.getMessage()});
            return null;
        }
    }

    public void handle(RoutingContext routingContext) {
        if (StringUtils.isNotBlank((CharSequence)this.revisionResponseBody)) {
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, response -> response.end(this.revisionResponseBody));
        } else {
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, response -> response.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end());
        }
    }
}

