/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.log.CriteriaManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class TracerLogHandler
implements Handler<RoutingContext> {
    private static final String ACCOUNT_PARAMETER = "account";
    private static final String LINE_ITEM_PARAMETER = "lineItemId";
    private static final String BIDDER_CODE_PARAMETER = "bidderCode";
    private static final String LOG_LEVEL_PARAMETER = "level";
    private static final String DURATION_IN_SECONDS = "duration";
    private final CriteriaManager criteriaManager;

    public TracerLogHandler(CriteriaManager criteriaManager) {
        this.criteriaManager = Objects.requireNonNull(criteriaManager);
    }

    public void handle(RoutingContext routingContext) {
        int duration;
        MultiMap parameters = routingContext.request().params();
        String accountId = parameters.get("account");
        String bidderCode = parameters.get("bidderCode");
        String lineItemId = parameters.get("lineItemId");
        if (StringUtils.isBlank((CharSequence)accountId) && StringUtils.isBlank((CharSequence)lineItemId) && StringUtils.isBlank((CharSequence)bidderCode)) {
            routingContext.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("At least one parameter should ne defined: account, bidderCode, lineItemId");
            return;
        }
        String loggerLevel = parameters.get("level");
        try {
            duration = TracerLogHandler.parseDuration((String)parameters.get("duration"));
        }
        catch (InvalidRequestException e) {
            routingContext.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(e.getMessage());
            return;
        }
        try {
            this.criteriaManager.addCriteria(accountId, bidderCode, lineItemId, loggerLevel, Integer.valueOf(duration));
        }
        catch (IllegalArgumentException e) {
            routingContext.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid parameter: " + e.getMessage());
            return;
        }
        routingContext.response().end();
    }

    private static int parseDuration(String rawDuration) {
        if (rawDuration == null) {
            throw new InvalidRequestException("duration parameter should be defined");
        }
        try {
            return Integer.parseInt(rawDuration);
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException("duration parameter should be defined as integer, but was " + rawDuration);
        }
    }
}

