/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.creator.ActivityInfrastructureCreator;
import org.prebid.server.analytics.model.NotificationEvent;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.auction.gpp.model.GppContextCreator;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.deals.UserService;
import org.prebid.server.deals.events.ApplicationEventService;
import org.prebid.server.events.EventRequest;
import org.prebid.server.events.EventUtil;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.handler.NotificationEventHandler;
import org.prebid.server.model.Endpoint;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountEventsConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ResourceUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationEventHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(NotificationEventHandler.class);
    private static final String TRACKING_PIXEL_PNG = "static/tracking-pixel.png";
    private static final String PNG_CONTENT_TYPE = "image/png";
    private final UidsCookieService uidsCookieService;
    private final ApplicationEventService applicationEventService;
    private final UserService userService;
    private final ActivityInfrastructureCreator activityInfrastructureCreator;
    private final AnalyticsReporterDelegator analyticsDelegator;
    private final TimeoutFactory timeoutFactory;
    private final ApplicationSettings applicationSettings;
    private final long defaultTimeoutMillis;
    private final boolean dealsEnabled;
    private final TrackingPixel trackingPixel;

    public NotificationEventHandler(UidsCookieService uidsCookieService, ApplicationEventService applicationEventService, UserService userService, ActivityInfrastructureCreator activityInfrastructureCreator, AnalyticsReporterDelegator analyticsDelegator, TimeoutFactory timeoutFactory, ApplicationSettings applicationSettings, long defaultTimeoutMillis, boolean dealsEnabled) {
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.applicationEventService = applicationEventService;
        this.userService = userService;
        this.activityInfrastructureCreator = Objects.requireNonNull(activityInfrastructureCreator);
        this.analyticsDelegator = Objects.requireNonNull(analyticsDelegator);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.defaultTimeoutMillis = defaultTimeoutMillis;
        this.dealsEnabled = dealsEnabled;
        this.trackingPixel = NotificationEventHandler.createTrackingPixel();
    }

    private static TrackingPixel createTrackingPixel() {
        byte[] bytes;
        try {
            bytes = ResourceUtil.readByteArrayFromClassPath((String)"static/tracking-pixel.png");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load pixel image at static/tracking-pixel.png", e);
        }
        return TrackingPixel.of((String)"image/png", (byte[])bytes);
    }

    public void handle(RoutingContext routingContext) {
        try {
            EventUtil.validateType((RoutingContext)routingContext);
            EventUtil.validateBidId((RoutingContext)routingContext);
            EventUtil.validateTimestamp((RoutingContext)routingContext);
            EventUtil.validateFormat((RoutingContext)routingContext);
            EventUtil.validateAnalytics((RoutingContext)routingContext);
            EventUtil.validateIntegration((RoutingContext)routingContext);
        }
        catch (IllegalArgumentException e) {
            NotificationEventHandler.respondWithBadRequest((RoutingContext)routingContext, (String)e.getMessage());
            return;
        }
        try {
            EventUtil.validateAccountId((RoutingContext)routingContext);
        }
        catch (IllegalArgumentException e) {
            NotificationEventHandler.respondWithUnauthorized((RoutingContext)routingContext, (String)e.getMessage());
            return;
        }
        EventRequest eventRequest = EventUtil.from((RoutingContext)routingContext);
        this.getAccountById(eventRequest.getAccountId()).onComplete(async -> this.handleEvent(async, eventRequest, routingContext));
    }

    private Future<Account> getAccountById(String accountId) {
        return this.applicationSettings.getAccountById(accountId, this.timeoutFactory.create(this.defaultTimeoutMillis)).recover(exception -> NotificationEventHandler.handleAccountExceptionOrFallback((Throwable)exception, (String)accountId));
    }

    private static Future<Account> handleAccountExceptionOrFallback(Throwable exception, String accountId) {
        if (exception instanceof PreBidException) {
            return Future.succeededFuture((Object)Account.builder().id(accountId).auction(AccountAuctionConfig.builder().events(AccountEventsConfig.of((Boolean)false)).build()).build());
        }
        return Future.failedFuture((Throwable)exception);
    }

    private void handleEvent(AsyncResult<Account> async, EventRequest eventRequest, RoutingContext routingContext) {
        if (async.failed()) {
            NotificationEventHandler.respondWithServerError((RoutingContext)routingContext, (String)"Error occurred while fetching account", (Throwable)async.cause());
        } else {
            boolean eventsEnabledForRequest;
            Account account = (Account)async.result();
            String lineItemId = eventRequest.getLineItemId();
            String bidId = eventRequest.getBidId();
            if (this.dealsEnabled && lineItemId != null) {
                this.applicationEventService.publishLineItemWinEvent(lineItemId);
                this.userService.processWinEvent(lineItemId, bidId, this.uidsCookieService.parseFromRequest(routingContext));
            }
            boolean eventsEnabledForAccount = Objects.equals(NotificationEventHandler.accountEventsEnabled((Account)account), true);
            boolean bl = eventsEnabledForRequest = eventRequest.getAnalytics() == EventRequest.Analytics.enabled;
            if (!eventsEnabledForAccount && eventsEnabledForRequest) {
                NotificationEventHandler.respondWithUnauthorized((RoutingContext)routingContext, (String)"Account '%s' doesn't support events".formatted(account.getId()));
                return;
            }
            EventRequest.Type eventType = eventRequest.getType();
            if (eventsEnabledForRequest) {
                NotificationEvent notificationEvent = NotificationEvent.builder().type(eventType == EventRequest.Type.win ? NotificationEvent.Type.win : NotificationEvent.Type.imp).bidId(eventRequest.getBidId()).account(account).bidder(eventRequest.getBidder()).timestamp(eventRequest.getTimestamp()).integration(eventRequest.getIntegration()).httpContext(HttpRequestContext.from((RoutingContext)routingContext)).lineItemId(lineItemId).activityInfrastructure(this.activityInfrastructure(account)).build();
                this.analyticsDelegator.processEvent((Object)notificationEvent);
            }
            this.respondWithOk(routingContext, eventRequest.getFormat() == EventRequest.Format.image);
        }
    }

    private static Boolean accountEventsEnabled(Account account) {
        AccountAuctionConfig accountAuctionConfig = account.getAuction();
        AccountEventsConfig accountEventsConfig = accountAuctionConfig != null ? accountAuctionConfig.getEvents() : null;
        return accountEventsConfig != null ? accountEventsConfig.getEnabled() : null;
    }

    private ActivityInfrastructure activityInfrastructure(Account account) {
        return this.activityInfrastructureCreator.create(account, GppContextCreator.from(null, null).build().getGppContext(), null);
    }

    private void respondWithOk(RoutingContext routingContext, boolean respondWithPixel) {
        if (respondWithPixel) {
            HttpUtil.executeSafely((RoutingContext)routingContext, (Endpoint)Endpoint.event, response -> response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.trackingPixel.getContentType()).end(Buffer.buffer((byte[])this.trackingPixel.getContent())));
        } else {
            HttpUtil.executeSafely((RoutingContext)routingContext, (Endpoint)Endpoint.event, HttpServerResponse::end);
        }
    }

    private static void respondWithBadRequest(RoutingContext routingContext, String message) {
        NotificationEventHandler.respondWith((RoutingContext)routingContext, (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)message);
    }

    private static void respondWithUnauthorized(RoutingContext routingContext, String message) {
        NotificationEventHandler.respondWith((RoutingContext)routingContext, (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED, (String)message);
    }

    private static void respondWithServerError(RoutingContext routingContext, String message, Throwable exception) {
        logger.warn((Object)message, exception);
        String body = "%s: %s".formatted(message, exception.getMessage());
        NotificationEventHandler.respondWith((RoutingContext)routingContext, (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (String)body);
    }

    private static void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body) {
        HttpUtil.executeSafely((RoutingContext)routingContext, (Endpoint)Endpoint.event, response -> response.setStatusCode(status.code()).end(body));
    }
}

