/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.handler.CurrencyRatesHandler;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class CurrencyRatesHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(CurrencyRatesHandler.class);
    private final CurrencyConversionService currencyConversionService;
    private final String endpoint;
    private final JacksonMapper mapper;

    public CurrencyRatesHandler(CurrencyConversionService currencyConversionService, String endpoint, JacksonMapper mapper) {
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.endpoint = Objects.requireNonNull(endpoint);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        try {
            String body = this.mapper.mapper().writeValueAsString((Object)Response.of((boolean)this.currencyConversionService.isExternalRatesActive(), (String)this.currencyConversionService.getCurrencyServerUrl(), (Long)CurrencyRatesHandler.toNanos((Long)this.currencyConversionService.getRefreshPeriod()), (ZonedDateTime)this.currencyConversionService.getLastUpdated(), (Map)this.currencyConversionService.getExternalCurrencyRates()));
            this.respondWithOk(routingContext, body);
        }
        catch (IOException e) {
            this.respondWithServerError(routingContext, (Throwable)e);
        }
    }

    private static Long toNanos(Long refreshPeriod) {
        return refreshPeriod != null ? Long.valueOf(TimeUnit.MILLISECONDS.toNanos(refreshPeriod)) : null;
    }

    private void respondWithOk(RoutingContext routingContext, String body) {
        this.respondWith(routingContext, HttpResponseStatus.OK, body);
    }

    private void respondWithServerError(RoutingContext routingContext, Throwable exception) {
        String message = "Critical error when marshaling latest currency rates update response";
        logger.error((Object)"Critical error when marshaling latest currency rates update response", exception);
        this.respondWith(routingContext, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Critical error when marshaling latest currency rates update response");
    }

    private void respondWith(RoutingContext routingContext, HttpResponseStatus status, String body) {
        HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, response -> response.setStatusCode(status.code()).putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).end(body));
    }
}

