/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.geolocation.model;

import java.beans.ConstructorProperties;
import java.time.ZoneId;
import lombok.NonNull;
import org.prebid.server.geolocation.model.GeoInfo;

public final class GeoInfo {
    @NonNull
    private final String vendor;
    private final String continent;
    private final String country;
    private final String region;
    private final Integer regionCode;
    private final String city;
    private final String metroGoogle;
    private final Integer metroNielsen;
    private final String zip;
    private final String connectionSpeed;
    private final Float lat;
    private final Float lon;
    private final ZoneId timeZone;

    @ConstructorProperties(value={"vendor", "continent", "country", "region", "regionCode", "city", "metroGoogle", "metroNielsen", "zip", "connectionSpeed", "lat", "lon", "timeZone"})
    GeoInfo(@NonNull String vendor, String continent, String country, String region, Integer regionCode, String city, String metroGoogle, Integer metroNielsen, String zip, String connectionSpeed, Float lat, Float lon, ZoneId timeZone) {
        if (vendor == null) {
            throw new NullPointerException("vendor is marked non-null but is null");
        }
        this.vendor = vendor;
        this.continent = continent;
        this.country = country;
        this.region = region;
        this.regionCode = regionCode;
        this.city = city;
        this.metroGoogle = metroGoogle;
        this.metroNielsen = metroNielsen;
        this.zip = zip;
        this.connectionSpeed = connectionSpeed;
        this.lat = lat;
        this.lon = lon;
        this.timeZone = timeZone;
    }

    public static GeoInfoBuilder builder() {
        return new GeoInfoBuilder();
    }

    public GeoInfoBuilder toBuilder() {
        return new GeoInfoBuilder().vendor(this.vendor).continent(this.continent).country(this.country).region(this.region).regionCode(this.regionCode).city(this.city).metroGoogle(this.metroGoogle).metroNielsen(this.metroNielsen).zip(this.zip).connectionSpeed(this.connectionSpeed).lat(this.lat).lon(this.lon).timeZone(this.timeZone);
    }

    @NonNull
    public String getVendor() {
        return this.vendor;
    }

    public String getContinent() {
        return this.continent;
    }

    public String getCountry() {
        return this.country;
    }

    public String getRegion() {
        return this.region;
    }

    public Integer getRegionCode() {
        return this.regionCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getMetroGoogle() {
        return this.metroGoogle;
    }

    public Integer getMetroNielsen() {
        return this.metroNielsen;
    }

    public String getZip() {
        return this.zip;
    }

    public String getConnectionSpeed() {
        return this.connectionSpeed;
    }

    public Float getLat() {
        return this.lat;
    }

    public Float getLon() {
        return this.lon;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoInfo)) {
            return false;
        }
        GeoInfo other = (GeoInfo)o;
        Integer this$regionCode = this.getRegionCode();
        Integer other$regionCode = other.getRegionCode();
        if (this$regionCode == null ? other$regionCode != null : !((Object)this$regionCode).equals(other$regionCode)) {
            return false;
        }
        Integer this$metroNielsen = this.getMetroNielsen();
        Integer other$metroNielsen = other.getMetroNielsen();
        if (this$metroNielsen == null ? other$metroNielsen != null : !((Object)this$metroNielsen).equals(other$metroNielsen)) {
            return false;
        }
        Float this$lat = this.getLat();
        Float other$lat = other.getLat();
        if (this$lat == null ? other$lat != null : !((Object)this$lat).equals(other$lat)) {
            return false;
        }
        Float this$lon = this.getLon();
        Float other$lon = other.getLon();
        if (this$lon == null ? other$lon != null : !((Object)this$lon).equals(other$lon)) {
            return false;
        }
        String this$vendor = this.getVendor();
        String other$vendor = other.getVendor();
        if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
            return false;
        }
        String this$continent = this.getContinent();
        String other$continent = other.getContinent();
        if (this$continent == null ? other$continent != null : !this$continent.equals(other$continent)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$metroGoogle = this.getMetroGoogle();
        String other$metroGoogle = other.getMetroGoogle();
        if (this$metroGoogle == null ? other$metroGoogle != null : !this$metroGoogle.equals(other$metroGoogle)) {
            return false;
        }
        String this$zip = this.getZip();
        String other$zip = other.getZip();
        if (this$zip == null ? other$zip != null : !this$zip.equals(other$zip)) {
            return false;
        }
        String this$connectionSpeed = this.getConnectionSpeed();
        String other$connectionSpeed = other.getConnectionSpeed();
        if (this$connectionSpeed == null ? other$connectionSpeed != null : !this$connectionSpeed.equals(other$connectionSpeed)) {
            return false;
        }
        ZoneId this$timeZone = this.getTimeZone();
        ZoneId other$timeZone = other.getTimeZone();
        return !(this$timeZone == null ? other$timeZone != null : !((Object)this$timeZone).equals(other$timeZone));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $regionCode = this.getRegionCode();
        result = result * 59 + ($regionCode == null ? 43 : ((Object)$regionCode).hashCode());
        Integer $metroNielsen = this.getMetroNielsen();
        result = result * 59 + ($metroNielsen == null ? 43 : ((Object)$metroNielsen).hashCode());
        Float $lat = this.getLat();
        result = result * 59 + ($lat == null ? 43 : ((Object)$lat).hashCode());
        Float $lon = this.getLon();
        result = result * 59 + ($lon == null ? 43 : ((Object)$lon).hashCode());
        String $vendor = this.getVendor();
        result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
        String $continent = this.getContinent();
        result = result * 59 + ($continent == null ? 43 : $continent.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $metroGoogle = this.getMetroGoogle();
        result = result * 59 + ($metroGoogle == null ? 43 : $metroGoogle.hashCode());
        String $zip = this.getZip();
        result = result * 59 + ($zip == null ? 43 : $zip.hashCode());
        String $connectionSpeed = this.getConnectionSpeed();
        result = result * 59 + ($connectionSpeed == null ? 43 : $connectionSpeed.hashCode());
        ZoneId $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : ((Object)$timeZone).hashCode());
        return result;
    }

    public String toString() {
        return "GeoInfo(vendor=" + this.getVendor() + ", continent=" + this.getContinent() + ", country=" + this.getCountry() + ", region=" + this.getRegion() + ", regionCode=" + this.getRegionCode() + ", city=" + this.getCity() + ", metroGoogle=" + this.getMetroGoogle() + ", metroNielsen=" + this.getMetroNielsen() + ", zip=" + this.getZip() + ", connectionSpeed=" + this.getConnectionSpeed() + ", lat=" + this.getLat() + ", lon=" + this.getLon() + ", timeZone=" + this.getTimeZone() + ")";
    }
}

