/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.EnrichingApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.settings.model.AccountPriceFloorsFetchConfig;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class PriceFloorsConfigResolver {
    private static final Logger logger = LoggerFactory.getLogger(EnrichingApplicationSettings.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int MIN_MAX_AGE_SEC_VALUE = 600;
    private static final int MIN_PERIODIC_SEC_VALUE = 300;
    private static final int MIN_TIMEOUT_MS_VALUE = 10;
    private static final int MAX_TIMEOUT_MS_VALUE = 10000;
    private static final int MIN_RULES_VALUE = 0;
    private static final int MIN_FILE_SIZE_VALUE = 0;
    private static final int MAX_AGE_SEC_VALUE = Integer.MAX_VALUE;
    private static final int MAX_RULES_VALUE = Integer.MAX_VALUE;
    private static final int MAX_FILE_SIZE_VALUE = Integer.MAX_VALUE;
    private static final int MIN_ENFORCE_RATE_VALUE = 0;
    private static final int MAX_ENFORCE_RATE_VALUE = 100;
    private static final long DEFAULT_MAX_AGE_SEC_VALUE = 86400L;
    private final Account defaultAccount;
    private final Metrics metrics;
    private final AccountPriceFloorsConfig defaultFloorsConfig;

    public PriceFloorsConfigResolver(String defaultAccountConfig, Metrics metrics, JacksonMapper mapper) {
        this.defaultAccount = PriceFloorsConfigResolver.parseAccount((String)defaultAccountConfig, (JacksonMapper)mapper);
        this.defaultFloorsConfig = PriceFloorsConfigResolver.getFloorsConfig((Account)this.defaultAccount);
        this.metrics = Objects.requireNonNull(metrics);
    }

    private static Account parseAccount(String accountConfig, JacksonMapper mapper) {
        try {
            Account account = StringUtils.isNotBlank((CharSequence)accountConfig) ? (Account)mapper.decodeValue(accountConfig, Account.class) : null;
            return PriceFloorsConfigResolver.isNotEmpty(account) ? account : null;
        }
        catch (DecodeException e) {
            throw new IllegalArgumentException("Could not parse default account configuration", e);
        }
    }

    private static AccountPriceFloorsConfig getFloorsConfig(Account account) {
        AccountAuctionConfig auctionConfig = (AccountAuctionConfig)ObjectUtil.getIfNotNull((Object)account, Account::getAuction);
        return (AccountPriceFloorsConfig)ObjectUtil.getIfNotNull((Object)auctionConfig, AccountAuctionConfig::getPriceFloors);
    }

    private static boolean isNotEmpty(Account account) {
        return account != null && !account.equals((Object)Account.builder().build());
    }

    public Future<Account> updateFloorsConfig(Account account) {
        try {
            PriceFloorsConfigResolver.validatePriceFloorConfig((Account)account, (AccountPriceFloorsConfig)this.defaultFloorsConfig);
            return Future.succeededFuture((Object)account);
        }
        catch (PreBidException e) {
            String message = "Account with id '%s' has invalid config: %s".formatted(account.getId(), e.getMessage());
            String accountId = (String)ObjectUtil.getIfNotNull((Object)account, Account::getId);
            if (StringUtils.isNotBlank((CharSequence)accountId)) {
                this.metrics.updateAlertsConfigFailed(account.getId(), MetricName.price_floors);
            }
            conditionalLogger.error(message, 0.01);
            return Future.succeededFuture((Object)this.fallbackToDefaultConfig(account));
        }
    }

    private static void validatePriceFloorConfig(Account account, AccountPriceFloorsConfig defaultFloorsConfig) {
        Integer enforceFloorsRate;
        AccountPriceFloorsConfig floorsConfig = PriceFloorsConfigResolver.getFloorsConfig((Account)account);
        if (floorsConfig == null) {
            return;
        }
        Integer accountEnforceRate = floorsConfig.getEnforceFloorsRate();
        Integer n = enforceFloorsRate = accountEnforceRate != null ? accountEnforceRate : (Integer)ObjectUtil.getIfNotNull((Object)defaultFloorsConfig, AccountPriceFloorsConfig::getEnforceFloorsRate);
        if (enforceFloorsRate != null && PriceFloorsConfigResolver.isNotInRange((long)enforceFloorsRate.intValue(), (long)0L, (long)100L)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage((String)"enforce-floors-rate", (Object)enforceFloorsRate));
        }
        AccountPriceFloorsFetchConfig fetchConfig = (AccountPriceFloorsFetchConfig)ObjectUtil.getIfNotNull((Object)floorsConfig, AccountPriceFloorsConfig::getFetch);
        AccountPriceFloorsFetchConfig defaultFetchConfig = (AccountPriceFloorsFetchConfig)ObjectUtil.getIfNotNull((Object)defaultFloorsConfig, AccountPriceFloorsConfig::getFetch);
        PriceFloorsConfigResolver.validatePriceFloorsFetchConfig((AccountPriceFloorsFetchConfig)fetchConfig, (AccountPriceFloorsFetchConfig)defaultFetchConfig);
    }

    private static void validatePriceFloorsFetchConfig(AccountPriceFloorsFetchConfig fetchConfig, AccountPriceFloorsFetchConfig defaultFetchConfig) {
        Long maxFileSize;
        Long maxRules;
        Long timeout;
        Long periodicSec;
        long maxAgeSec;
        if (fetchConfig == null) {
            return;
        }
        Long accountMaxAgeSec = fetchConfig.getMaxAgeSec();
        Long defaultMaxAgeSec = (Long)ObjectUtil.getIfNotNull((Object)defaultFetchConfig, AccountPriceFloorsFetchConfig::getMaxAgeSec);
        long l = accountMaxAgeSec != null ? accountMaxAgeSec : (maxAgeSec = defaultMaxAgeSec != null ? defaultMaxAgeSec : 86400L);
        if (PriceFloorsConfigResolver.isNotInRange((long)maxAgeSec, (long)600L, (long)Integer.MAX_VALUE)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage((String)"max-age-sec", (Object)maxAgeSec));
        }
        Long accountPeriodicSec = fetchConfig.getPeriodSec();
        Long l2 = periodicSec = accountPeriodicSec != null ? accountPeriodicSec : (Long)ObjectUtil.getIfNotNull((Object)defaultFetchConfig, AccountPriceFloorsFetchConfig::getPeriodSec);
        if (periodicSec != null && PriceFloorsConfigResolver.isNotInRange((long)periodicSec, (long)300L, (long)maxAgeSec)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage((String)"period-sec", (Object)periodicSec));
        }
        Long accountTimeout = fetchConfig.getTimeout();
        Long l3 = timeout = accountTimeout != null ? accountTimeout : (Long)ObjectUtil.getIfNotNull((Object)defaultFetchConfig, AccountPriceFloorsFetchConfig::getTimeout);
        if (timeout != null && PriceFloorsConfigResolver.isNotInRange((long)timeout, (long)10L, (long)10000L)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage((String)"timeout-ms", (Object)timeout));
        }
        Long accountMaxRules = fetchConfig.getMaxRules();
        Long l4 = maxRules = accountMaxRules != null ? accountMaxRules : (Long)ObjectUtil.getIfNotNull((Object)defaultFetchConfig, AccountPriceFloorsFetchConfig::getMaxRules);
        if (maxRules != null && PriceFloorsConfigResolver.isNotInRange((long)maxRules, (long)0L, (long)Integer.MAX_VALUE)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage((String)"max-rules", (Object)maxRules));
        }
        Long accountMaxFileSize = fetchConfig.getMaxFileSize();
        Long l5 = maxFileSize = accountMaxFileSize != null ? accountMaxFileSize : (Long)ObjectUtil.getIfNotNull((Object)defaultFetchConfig, AccountPriceFloorsFetchConfig::getMaxFileSize);
        if (maxFileSize != null && PriceFloorsConfigResolver.isNotInRange((long)maxFileSize, (long)0L, (long)Integer.MAX_VALUE)) {
            throw new PreBidException(PriceFloorsConfigResolver.invalidPriceFloorsPropertyMessage((String)"max-file-size-kb", (Object)maxFileSize));
        }
    }

    private static boolean isNotInRange(long number, long min, long max) {
        return Math.max(min, number) != Math.min(number, max);
    }

    private static String invalidPriceFloorsPropertyMessage(String property, Object value) {
        return "Invalid price-floors property '%s', value passed: %s".formatted(property, value);
    }

    private Account fallbackToDefaultConfig(Account account) {
        AccountAuctionConfig auctionConfig = account.getAuction();
        AccountAuctionConfig defaultAuctionConfig = (AccountAuctionConfig)ObjectUtil.getIfNotNull((Object)this.defaultAccount, Account::getAuction);
        AccountPriceFloorsConfig defaultPriceFloorsConfig = (AccountPriceFloorsConfig)ObjectUtil.getIfNotNull((Object)defaultAuctionConfig, AccountAuctionConfig::getPriceFloors);
        return account.toBuilder().auction(auctionConfig.toBuilder().priceFloors(defaultPriceFloorsConfig).build()).build();
    }
}

