/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.channel.ConnectTimeoutException;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.floors.PriceFloorFetcher;
import org.prebid.server.floors.PriceFloorRulesValidator;
import org.prebid.server.floors.model.PriceFloorData;
import org.prebid.server.floors.model.PriceFloorDebugProperties;
import org.prebid.server.floors.proto.FetchResult;
import org.prebid.server.floors.proto.FetchStatus;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.settings.model.AccountPriceFloorsFetchConfig;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class PriceFloorFetcher {
    private static final Logger logger = LoggerFactory.getLogger(PriceFloorFetcher.class);
    private static final int ACCOUNT_FETCH_TIMEOUT_MS = 5000;
    private static final int MAXIMUM_CACHE_SIZE = 300;
    private static final int MIN_MAX_AGE_SEC_VALUE = 600;
    private static final int MAX_AGE_SEC_VALUE = Integer.MAX_VALUE;
    private static final Pattern CACHE_CONTROL_HEADER_PATTERN = Pattern.compile("^.*max-age=(\\d+).*$");
    private final ApplicationSettings applicationSettings;
    private final Metrics metrics;
    private final Vertx vertx;
    private final TimeoutFactory timeoutFactory;
    private final HttpClient httpClient;
    private final JacksonMapper mapper;
    private final PriceFloorDebugProperties debugProperties;
    private final Set<String> fetchInProgress;
    private final Map<String, AccountFetchContext> fetchedData;

    public PriceFloorFetcher(ApplicationSettings applicationSettings, Metrics metrics, Vertx vertx, TimeoutFactory timeoutFactory, HttpClient httpClient, PriceFloorDebugProperties debugProperties, JacksonMapper mapper) {
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.metrics = Objects.requireNonNull(metrics);
        this.vertx = Objects.requireNonNull(vertx);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.debugProperties = debugProperties;
        this.mapper = Objects.requireNonNull(mapper);
        this.fetchInProgress = new ConcurrentHashSet();
        this.fetchedData = Caffeine.newBuilder().maximumSize(300L).build().asMap();
    }

    public FetchResult fetch(Account account) {
        AccountFetchContext accountFetchContext = (AccountFetchContext)this.fetchedData.get(account.getId());
        return accountFetchContext != null ? FetchResult.of((PriceFloorData)accountFetchContext.getRulesData(), (FetchStatus)accountFetchContext.getFetchStatus()) : this.fetchPriceFloorData(account);
    }

    private FetchResult fetchPriceFloorData(Account account) {
        AccountPriceFloorsFetchConfig fetchConfig = PriceFloorFetcher.getFetchConfig((Account)account);
        Boolean fetchEnabled = (Boolean)ObjectUtil.getIfNotNull((Object)fetchConfig, AccountPriceFloorsFetchConfig::getEnabled);
        if (BooleanUtils.isFalse((Boolean)fetchEnabled)) {
            return FetchResult.of(null, (FetchStatus)FetchStatus.none);
        }
        String accountId = account.getId();
        String fetchUrl = (String)ObjectUtil.getIfNotNull((Object)fetchConfig, AccountPriceFloorsFetchConfig::getUrl);
        if (!this.isUrlValid(fetchUrl)) {
            logger.error((Object)"Malformed fetch.url: '%s', passed for account %s".formatted(fetchUrl, accountId));
            return FetchResult.of(null, (FetchStatus)FetchStatus.error);
        }
        if (!this.fetchInProgress.contains(accountId)) {
            this.fetchPriceFloorDataAsynchronous(fetchConfig, accountId);
        }
        return FetchResult.of(null, (FetchStatus)FetchStatus.inprogress);
    }

    private boolean isUrlValid(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        try {
            HttpUtil.validateUrl((String)url);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static AccountPriceFloorsFetchConfig getFetchConfig(Account account) {
        AccountPriceFloorsConfig priceFloorsConfig = (AccountPriceFloorsConfig)ObjectUtil.getIfNotNull((Object)account.getAuction(), AccountAuctionConfig::getPriceFloors);
        return (AccountPriceFloorsFetchConfig)ObjectUtil.getIfNotNull((Object)priceFloorsConfig, AccountPriceFloorsConfig::getFetch);
    }

    private void fetchPriceFloorDataAsynchronous(AccountPriceFloorsFetchConfig fetchConfig, String accountId) {
        Long accountTimeout = (Long)ObjectUtil.getIfNotNull((Object)fetchConfig, AccountPriceFloorsFetchConfig::getTimeout);
        Long timeout = (Long)ObjectUtils.firstNonNull((Object[])new Long[]{(Long)ObjectUtil.getIfNotNull((Object)this.debugProperties, PriceFloorDebugProperties::getMinTimeoutMs), (Long)ObjectUtil.getIfNotNull((Object)this.debugProperties, PriceFloorDebugProperties::getMaxTimeoutMs), accountTimeout});
        Long maxFetchFileSizeKb = (Long)ObjectUtil.getIfNotNull((Object)fetchConfig, AccountPriceFloorsFetchConfig::getMaxFileSize);
        String fetchUrl = fetchConfig.getUrl();
        this.fetchInProgress.add(accountId);
        this.httpClient.get(fetchUrl, timeout.longValue(), PriceFloorFetcher.resolveMaxFileSize((Long)maxFetchFileSizeKb)).map(httpClientResponse -> this.parseFloorResponse(httpClientResponse, fetchConfig, accountId)).recover(throwable -> this.recoverFromFailedFetching(throwable, fetchUrl, accountId)).map(cacheInfo -> this.updateCache(cacheInfo, fetchConfig, accountId)).map(priceFloorData -> this.createPeriodicTimerForRulesFetch(priceFloorData, fetchConfig, accountId));
    }

    private static long resolveMaxFileSize(Long maxSizeInKBytes) {
        return Objects.equals(maxSizeInKBytes, 0L) ? Long.MAX_VALUE : maxSizeInKBytes * 1024L;
    }

    private ResponseCacheInfo parseFloorResponse(HttpClientResponse httpClientResponse, AccountPriceFloorsFetchConfig fetchConfig, String accountId) {
        int statusCode = httpClientResponse.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("Failed to request for account %s, provider respond with status %s".formatted(accountId, statusCode));
        }
        String body = httpClientResponse.getBody();
        if (StringUtils.isBlank((CharSequence)body)) {
            throw new PreBidException("Failed to parse price floor response for account %s, response body can not be empty".formatted(accountId));
        }
        PriceFloorData priceFloorData = this.parsePriceFloorData(body, accountId);
        PriceFloorRulesValidator.validateRulesData((PriceFloorData)priceFloorData, (Integer)PriceFloorFetcher.resolveMaxRules((Long)fetchConfig.getMaxRules()));
        return ResponseCacheInfo.of((PriceFloorData)priceFloorData, (FetchStatus)FetchStatus.success, (Long)this.cacheTtlFromResponse(httpClientResponse, fetchConfig.getUrl()));
    }

    private PriceFloorData parsePriceFloorData(String body, String accountId) {
        PriceFloorData priceFloorData;
        try {
            priceFloorData = (PriceFloorData)this.mapper.decodeValue(body, PriceFloorData.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Failed to parse price floor response for account %s, cause: %s".formatted(accountId, ExceptionUtils.getMessage((Throwable)e)));
        }
        return priceFloorData;
    }

    private static int resolveMaxRules(Long accountMaxRules) {
        return accountMaxRules != null && !accountMaxRules.equals(0L) ? Math.toIntExact(accountMaxRules) : Integer.MAX_VALUE;
    }

    private Long cacheTtlFromResponse(HttpClientResponse httpClientResponse, String fetchUrl) {
        Matcher cacheHeaderMatcher;
        String cacheControlValue = httpClientResponse.getHeaders().get(HttpHeaders.CACHE_CONTROL);
        Matcher matcher = cacheHeaderMatcher = StringUtils.isNotBlank((CharSequence)cacheControlValue) ? CACHE_CONTROL_HEADER_PATTERN.matcher(cacheControlValue) : null;
        if (cacheHeaderMatcher != null && cacheHeaderMatcher.matches()) {
            try {
                return Long.parseLong(cacheHeaderMatcher.group(1));
            }
            catch (NumberFormatException e) {
                logger.error((Object)"Can't parse Cache Control header '%s', fetch.url: '%s'".formatted(cacheControlValue, fetchUrl));
            }
        }
        return null;
    }

    private PriceFloorData updateCache(ResponseCacheInfo cacheInfo, AccountPriceFloorsFetchConfig fetchConfig, String accountId) {
        long maxAgeTimerId = this.createMaxAgeTimer(accountId, PriceFloorFetcher.resolveCacheTtl((ResponseCacheInfo)cacheInfo, (AccountPriceFloorsFetchConfig)fetchConfig));
        AccountFetchContext fetchContext = AccountFetchContext.of((PriceFloorData)cacheInfo.getRulesData(), (FetchStatus)cacheInfo.getFetchStatus(), (Long)maxAgeTimerId);
        if (cacheInfo.getFetchStatus() == FetchStatus.success || !this.fetchedData.containsKey(accountId)) {
            this.fetchedData.put(accountId, fetchContext);
        }
        this.fetchInProgress.remove(accountId);
        return fetchContext.getRulesData();
    }

    private static long resolveCacheTtl(ResponseCacheInfo cacheInfo, AccountPriceFloorsFetchConfig fetchConfig) {
        Long headerCacheTtl = cacheInfo.getCacheTtl();
        return PriceFloorFetcher.isValidMaxAge((Long)headerCacheTtl, (AccountPriceFloorsFetchConfig)fetchConfig) ? headerCacheTtl : fetchConfig.getMaxAgeSec();
    }

    private static boolean isValidMaxAge(Long headerCacheTtl, AccountPriceFloorsFetchConfig fetchConfig) {
        Long periodSec = fetchConfig.getPeriodSec();
        long minMaxAgeValue = periodSec != null ? Math.max(600L, periodSec) : 600L;
        return headerCacheTtl != null && PriceFloorFetcher.isInMaxAgeRange((long)headerCacheTtl, (long)minMaxAgeValue);
    }

    private static boolean isInMaxAgeRange(long number, long min) {
        return Math.max(min, number) == Math.min(number, Integer.MAX_VALUE);
    }

    private Long createMaxAgeTimer(String accountId, long cacheTtl) {
        Long previousTimerId = (Long)ObjectUtil.getIfNotNull((Object)((AccountFetchContext)this.fetchedData.get(accountId)), AccountFetchContext::getMaxAgeTimerId);
        if (previousTimerId != null) {
            this.vertx.cancelTimer(previousTimerId.longValue());
        }
        Long effectiveCacheTtl = (Long)ObjectUtils.defaultIfNull((Object)((Long)ObjectUtil.getIfNotNull((Object)this.debugProperties, PriceFloorDebugProperties::getMinMaxAgeSec)), (Object)cacheTtl);
        return this.vertx.setTimer(TimeUnit.SECONDS.toMillis(effectiveCacheTtl), id -> this.fetchedData.remove(accountId));
    }

    private Future<ResponseCacheInfo> recoverFromFailedFetching(Throwable throwable, String fetchUrl, String accountId) {
        FetchStatus fetchStatus;
        this.metrics.updatePriceFloorFetchMetric(MetricName.failure);
        if (throwable instanceof TimeoutException || throwable instanceof ConnectTimeoutException) {
            fetchStatus = FetchStatus.timeout;
            logger.error((Object)"Fetch price floor request timeout for fetch.url: '%s', account %s exceeded.".formatted(fetchUrl, accountId));
        } else {
            fetchStatus = FetchStatus.error;
            logger.error((Object)"Failed to fetch price floor from provider for fetch.url: '%s', account = %s with a reason : %s ".formatted(fetchUrl, accountId, throwable.getMessage()));
        }
        return Future.succeededFuture((Object)ResponseCacheInfo.withStatus((FetchStatus)fetchStatus));
    }

    private PriceFloorData createPeriodicTimerForRulesFetch(PriceFloorData priceFloorData, AccountPriceFloorsFetchConfig fetchConfig, String accountId) {
        long accountPeriodicTimeSec = (Long)ObjectUtil.getIfNotNull((Object)fetchConfig, AccountPriceFloorsFetchConfig::getPeriodSec);
        long periodicTimeSec = (Long)ObjectUtils.defaultIfNull((Object)((Long)ObjectUtil.getIfNotNull((Object)this.debugProperties, PriceFloorDebugProperties::getMinPeriodSec)), (Object)accountPeriodicTimeSec);
        this.vertx.setTimer(TimeUnit.SECONDS.toMillis(periodicTimeSec), ignored -> this.periodicFetch(accountId));
        return priceFloorData;
    }

    private void periodicFetch(String accountId) {
        this.accountById(accountId).map(arg_0 -> this.fetchPriceFloorData(arg_0));
    }

    private Future<Account> accountById(String accountId) {
        return StringUtils.isBlank((CharSequence)accountId) ? Future.succeededFuture() : this.applicationSettings.getAccountById(accountId, this.timeoutFactory.create(5000L)).recover(ignored -> Future.succeededFuture());
    }
}

