/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.floors.PriceFloorFetcher;
import org.prebid.server.floors.PriceFloorProcessor;
import org.prebid.server.floors.PriceFloorResolver;
import org.prebid.server.floors.PriceFloorRulesValidator;
import org.prebid.server.floors.model.PriceFloorData;
import org.prebid.server.floors.model.PriceFloorLocation;
import org.prebid.server.floors.model.PriceFloorModelGroup;
import org.prebid.server.floors.model.PriceFloorResult;
import org.prebid.server.floors.model.PriceFloorRules;
import org.prebid.server.floors.proto.FetchResult;
import org.prebid.server.floors.proto.FetchStatus;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebidFloors;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BasicPriceFloorProcessor
implements PriceFloorProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BasicPriceFloorProcessor.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int SKIP_RATE_MIN = 0;
    private static final int SKIP_RATE_MAX = 100;
    private static final int MODEL_WEIGHT_MAX_VALUE = 100;
    private static final int MODEL_WEIGHT_MIN_VALUE = 1;
    private final PriceFloorFetcher floorFetcher;
    private final PriceFloorResolver floorResolver;
    private final JacksonMapper mapper;

    public BasicPriceFloorProcessor(PriceFloorFetcher floorFetcher, PriceFloorResolver floorResolver, JacksonMapper mapper) {
        this.floorFetcher = Objects.requireNonNull(floorFetcher);
        this.floorResolver = Objects.requireNonNull(floorResolver);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public AuctionContext enrichWithPriceFloors(AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        BidRequest bidRequest = auctionContext.getBidRequest();
        List errors = auctionContext.getPrebidErrors();
        List warnings = auctionContext.getDebugWarnings();
        if (BasicPriceFloorProcessor.isPriceFloorsDisabled((Account)account, (BidRequest)bidRequest)) {
            return auctionContext.with(BasicPriceFloorProcessor.disableFloorsForRequest((BidRequest)bidRequest));
        }
        PriceFloorRules floors = this.resolveFloors(account, bidRequest, errors);
        BidRequest updatedBidRequest = this.updateBidRequestWithFloors(bidRequest, floors, errors, warnings);
        return auctionContext.with(updatedBidRequest);
    }

    private static boolean isPriceFloorsDisabled(Account account, BidRequest bidRequest) {
        return BasicPriceFloorProcessor.isPriceFloorsDisabledForAccount((Account)account) || BasicPriceFloorProcessor.isPriceFloorsDisabledForRequest((BidRequest)bidRequest);
    }

    private static BidRequest disableFloorsForRequest(BidRequest bidRequest) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        PriceFloorRules rules = (PriceFloorRules)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getFloors);
        PriceFloorRules updatedRules = (rules != null ? rules.toBuilder() : PriceFloorRules.builder()).enabled(Boolean.valueOf(false)).build();
        ExtRequestPrebid updatedPrebid = (prebid != null ? prebid.toBuilder() : ExtRequestPrebid.builder()).floors(updatedRules).build();
        return bidRequest.toBuilder().ext(ExtRequest.of((ExtRequestPrebid)updatedPrebid)).build();
    }

    private static boolean isPriceFloorsDisabledForAccount(Account account) {
        AccountPriceFloorsConfig priceFloors = (AccountPriceFloorsConfig)ObjectUtil.getIfNotNull((Object)account.getAuction(), AccountAuctionConfig::getPriceFloors);
        return BooleanUtils.isFalse((Boolean)((Boolean)ObjectUtil.getIfNotNull((Object)priceFloors, AccountPriceFloorsConfig::getEnabled)));
    }

    private static boolean isPriceFloorsDisabledForRequest(BidRequest bidRequest) {
        PriceFloorRules requestFloors = BasicPriceFloorProcessor.extractRequestFloors((BidRequest)bidRequest);
        return BooleanUtils.isFalse((Boolean)((Boolean)ObjectUtil.getIfNotNull((Object)requestFloors, PriceFloorRules::getEnabled)));
    }

    private static PriceFloorRules extractRequestFloors(BidRequest bidRequest) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        return (PriceFloorRules)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getFloors);
    }

    private PriceFloorRules resolveFloors(Account account, BidRequest bidRequest, List<String> errors) {
        PriceFloorRules requestFloors = BasicPriceFloorProcessor.extractRequestFloors((BidRequest)bidRequest);
        FetchResult fetchResult = this.floorFetcher.fetch(account);
        FetchStatus fetchStatus = (FetchStatus)ObjectUtil.getIfNotNull((Object)fetchResult, FetchResult::getFetchStatus);
        if (BasicPriceFloorProcessor.shouldUseDynamicData((Account)account) && fetchResult != null && fetchStatus == FetchStatus.success) {
            PriceFloorRules mergedFloors = this.mergeFloors(requestFloors, fetchResult.getRulesData());
            return BasicPriceFloorProcessor.createFloorsFrom((PriceFloorRules)mergedFloors, (FetchStatus)fetchStatus, (PriceFloorLocation)PriceFloorLocation.fetch);
        }
        if (requestFloors != null) {
            try {
                PriceFloorRulesValidator.validateRules((PriceFloorRules)requestFloors, (Integer)Integer.MAX_VALUE);
                return BasicPriceFloorProcessor.createFloorsFrom((PriceFloorRules)requestFloors, (FetchStatus)fetchStatus, (PriceFloorLocation)PriceFloorLocation.request);
            }
            catch (PreBidException e) {
                errors.add("Failed to parse price floors from request, with a reason : %s ".formatted(e.getMessage()));
                conditionalLogger.error("Failed to parse price floors from request with id: '%s', with a reason : %s ".formatted(bidRequest.getId(), e.getMessage()), 0.01);
            }
        }
        return BasicPriceFloorProcessor.createFloorsFrom(null, (FetchStatus)fetchStatus, (PriceFloorLocation)PriceFloorLocation.noData);
    }

    private static boolean shouldUseDynamicData(Account account) {
        AccountAuctionConfig auctionConfig = (AccountAuctionConfig)ObjectUtil.getIfNotNull((Object)account, Account::getAuction);
        AccountPriceFloorsConfig floorsConfig = (AccountPriceFloorsConfig)ObjectUtil.getIfNotNull((Object)auctionConfig, AccountAuctionConfig::getPriceFloors);
        return BooleanUtils.isNotFalse((Boolean)((Boolean)ObjectUtil.getIfNotNull((Object)floorsConfig, AccountPriceFloorsConfig::getUseDynamicData)));
    }

    private PriceFloorRules mergeFloors(PriceFloorRules requestFloors, PriceFloorData providerRulesData) {
        Price floorMinPrice = this.resolveFloorMinPrice(requestFloors);
        return (requestFloors != null ? requestFloors.toBuilder() : PriceFloorRules.builder()).floorMinCur((String)ObjectUtil.getIfNotNull((Object)floorMinPrice, Price::getCurrency)).floorMin((BigDecimal)ObjectUtil.getIfNotNull((Object)floorMinPrice, Price::getValue)).data(providerRulesData).build();
    }

    private Price resolveFloorMinPrice(PriceFloorRules requestFloors) {
        String requestDataCurrency = (String)ObjectUtil.getIfNotNull((Object)((PriceFloorData)ObjectUtil.getIfNotNull((Object)requestFloors, PriceFloorRules::getData)), PriceFloorData::getCurrency);
        String requestFloorMinCur = (String)ObjectUtils.firstNonNull((Object[])new String[]{(String)ObjectUtil.getIfNotNull((Object)requestFloors, PriceFloorRules::getFloorMinCur), requestDataCurrency});
        BigDecimal requestFloorMin = (BigDecimal)ObjectUtil.getIfNotNull((Object)requestFloors, PriceFloorRules::getFloorMin);
        if (StringUtils.isNotBlank((CharSequence)requestFloorMinCur) && BidderUtil.isValidPrice((BigDecimal)requestFloorMin)) {
            return Price.of((String)requestFloorMinCur, (BigDecimal)requestFloorMin);
        }
        return Price.of(null, (BigDecimal)requestFloorMin);
    }

    private static PriceFloorRules createFloorsFrom(PriceFloorRules floors, FetchStatus fetchStatus, PriceFloorLocation location) {
        PriceFloorData floorData = (PriceFloorData)ObjectUtil.getIfNotNull((Object)floors, PriceFloorRules::getData);
        PriceFloorData updatedFloorData = floorData != null ? BasicPriceFloorProcessor.updateFloorData((PriceFloorData)floorData) : null;
        return (floors != null ? floors.toBuilder() : PriceFloorRules.builder()).floorProvider(BasicPriceFloorProcessor.resolveFloorProvider((PriceFloorRules)floors)).fetchStatus(fetchStatus).location(location).data(updatedFloorData).build();
    }

    private static PriceFloorData updateFloorData(PriceFloorData floorData) {
        List modelGroups = floorData.getModelGroups();
        PriceFloorModelGroup modelGroup = CollectionUtils.isNotEmpty((Collection)modelGroups) ? BasicPriceFloorProcessor.selectFloorModelGroup((List)modelGroups) : null;
        return modelGroup != null ? floorData.toBuilder().modelGroups(Collections.singletonList(modelGroup)).build() : floorData;
    }

    private static PriceFloorModelGroup selectFloorModelGroup(List<PriceFloorModelGroup> modelGroups) {
        int overallModelWeight = modelGroups.stream().filter(BasicPriceFloorProcessor::isValidModelGroup).mapToInt(BasicPriceFloorProcessor::resolveModelGroupWeight).sum();
        Collections.shuffle(modelGroups);
        List<PriceFloorModelGroup> groupsByWeight = modelGroups.stream().filter(BasicPriceFloorProcessor::isValidModelGroup).sorted(Comparator.comparing(BasicPriceFloorProcessor::resolveModelGroupWeight)).toList();
        int winWeight = ThreadLocalRandom.current().nextInt(overallModelWeight);
        for (PriceFloorModelGroup modelGroup : groupsByWeight) {
            if ((winWeight -= BasicPriceFloorProcessor.resolveModelGroupWeight((PriceFloorModelGroup)modelGroup)) > 0) continue;
            return modelGroup;
        }
        return groupsByWeight.get(groupsByWeight.size() - 1);
    }

    private static boolean isValidModelGroup(PriceFloorModelGroup modelGroup) {
        Integer skipRate = modelGroup.getSkipRate();
        if (skipRate != null && (skipRate < 0 || skipRate > 100)) {
            return false;
        }
        Integer modelWeight = modelGroup.getModelWeight();
        return modelWeight == null || modelWeight >= 1 && modelWeight <= 100;
    }

    private static int resolveModelGroupWeight(PriceFloorModelGroup modelGroup) {
        return (Integer)ObjectUtils.defaultIfNull((Object)modelGroup.getModelWeight(), (Object)1);
    }

    private static String resolveFloorProvider(PriceFloorRules rules) {
        PriceFloorData floorData = (PriceFloorData)ObjectUtil.getIfNotNull((Object)rules, PriceFloorRules::getData);
        String dataLevelProvider = (String)ObjectUtil.getIfNotNull((Object)floorData, PriceFloorData::getFloorProvider);
        return StringUtils.isNotBlank((CharSequence)dataLevelProvider) ? dataLevelProvider : (String)ObjectUtil.getIfNotNull((Object)rules, PriceFloorRules::getFloorProvider);
    }

    private BidRequest updateBidRequestWithFloors(BidRequest bidRequest, PriceFloorRules floors, List<String> errors, List<String> warnings) {
        Integer requestSkipRate = BasicPriceFloorProcessor.extractSkipRate((PriceFloorRules)floors);
        boolean skipFloors = BasicPriceFloorProcessor.shouldSkipFloors((Integer)requestSkipRate);
        List imps = skipFloors ? bidRequest.getImp() : this.updateImpsWithFloors(floors, bidRequest, errors, warnings);
        ExtRequest extRequest = BasicPriceFloorProcessor.updateExtRequestWithFloors((BidRequest)bidRequest, (PriceFloorRules)floors, (Integer)requestSkipRate, (boolean)skipFloors);
        return bidRequest.toBuilder().imp(imps).ext(extRequest).build();
    }

    private static boolean shouldSkipFloors(Integer skipRate) {
        return skipRate != null && ThreadLocalRandom.current().nextInt(100) < skipRate;
    }

    private static Integer extractSkipRate(PriceFloorRules floors) {
        PriceFloorModelGroup modelGroup = BasicPriceFloorProcessor.extractFloorModelGroup((PriceFloorRules)floors);
        Integer modelGroupSkipRate = (Integer)ObjectUtil.getIfNotNull((Object)modelGroup, PriceFloorModelGroup::getSkipRate);
        if (BasicPriceFloorProcessor.isValidSkipRate((Integer)modelGroupSkipRate)) {
            return modelGroupSkipRate;
        }
        PriceFloorData data = (PriceFloorData)ObjectUtil.getIfNotNull((Object)floors, PriceFloorRules::getData);
        Integer dataSkipRate = (Integer)ObjectUtil.getIfNotNull((Object)data, PriceFloorData::getSkipRate);
        if (BasicPriceFloorProcessor.isValidSkipRate((Integer)dataSkipRate)) {
            return dataSkipRate;
        }
        Integer rootSkipRate = (Integer)ObjectUtil.getIfNotNull((Object)floors, PriceFloorRules::getSkipRate);
        if (BasicPriceFloorProcessor.isValidSkipRate((Integer)rootSkipRate)) {
            return rootSkipRate;
        }
        return null;
    }

    private static boolean isValidSkipRate(Integer value) {
        return value != null && value >= 0 && value <= 100;
    }

    private List<Imp> updateImpsWithFloors(PriceFloorRules effectiveFloors, BidRequest bidRequest, List<String> errors, List<String> warnings) {
        List imps = bidRequest.getImp();
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        PriceFloorRules floors = (PriceFloorRules)ObjectUtils.defaultIfNull((Object)effectiveFloors, (Object)((PriceFloorRules)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getFloors)));
        PriceFloorModelGroup modelGroup = BasicPriceFloorProcessor.extractFloorModelGroup((PriceFloorRules)floors);
        if (modelGroup == null) {
            return imps;
        }
        return CollectionUtils.emptyIfNull((Collection)imps).stream().map(imp -> this.updateImpWithFloors(imp, floors, bidRequest, errors, warnings)).toList();
    }

    private static PriceFloorModelGroup extractFloorModelGroup(PriceFloorRules floors) {
        PriceFloorData data = (PriceFloorData)ObjectUtil.getIfNotNull((Object)floors, PriceFloorRules::getData);
        List modelGroups = (List)ObjectUtil.getIfNotNull((Object)data, PriceFloorData::getModelGroups);
        return CollectionUtils.isNotEmpty((Collection)modelGroups) ? (PriceFloorModelGroup)modelGroups.get(0) : null;
    }

    private Imp updateImpWithFloors(Imp imp, PriceFloorRules floorRules, BidRequest bidRequest, List<String> errors, List<String> warnings) {
        PriceFloorResult priceFloorResult;
        try {
            priceFloorResult = this.floorResolver.resolve(bidRequest, floorRules, imp, warnings);
        }
        catch (IllegalStateException e) {
            errors.add("Cannot resolve bid floor, error: " + e.getMessage());
            return imp;
        }
        if (priceFloorResult == null) {
            return imp;
        }
        return imp.toBuilder().bidfloor(priceFloorResult.getFloorValue()).bidfloorcur(priceFloorResult.getCurrency()).ext(this.updateImpExtWithFloors(imp.getExt(), priceFloorResult)).build();
    }

    private ObjectNode updateImpExtWithFloors(ObjectNode ext, PriceFloorResult priceFloorResult) {
        JsonNode extPrebid = ext.path("prebid");
        ObjectNode extPrebidAsObject = extPrebid.isObject() ? (ObjectNode)extPrebid : this.mapper.mapper().createObjectNode();
        JsonNode impFloorsNode = extPrebid.get("floors");
        ExtImpPrebidFloors prebidFloors = ExtImpPrebidFloors.of((String)priceFloorResult.getFloorRule(), (BigDecimal)priceFloorResult.getFloorRuleValue(), (BigDecimal)priceFloorResult.getFloorValue(), (BigDecimal)BasicPriceFloorProcessor.resolveImpFloorMin((JsonNode)impFloorsNode), (String)BasicPriceFloorProcessor.resolveImpFloorMinCur((JsonNode)impFloorsNode));
        ObjectNode floorsNode = (ObjectNode)this.mapper.mapper().valueToTree((Object)prebidFloors);
        return floorsNode.isEmpty() ? ext : (ObjectNode)ext.set("prebid", extPrebidAsObject.set("floors", (JsonNode)floorsNode));
    }

    private static BigDecimal resolveImpFloorMin(JsonNode impFloorsNode) {
        JsonNode impFloorMinNode = impFloorsNode != null ? impFloorsNode.get("floorMin") : null;
        return impFloorMinNode != null && impFloorMinNode.isNumber() ? impFloorMinNode.decimalValue() : null;
    }

    private static String resolveImpFloorMinCur(JsonNode impFloorsNode) {
        JsonNode impFloorMinCurNode = impFloorsNode != null ? impFloorsNode.get("floorMinCur") : null;
        return impFloorMinCurNode != null && impFloorMinCurNode.isTextual() ? impFloorMinCurNode.asText() : null;
    }

    private static ExtRequest updateExtRequestWithFloors(BidRequest bidRequest, PriceFloorRules floors, Integer skipRate, boolean skipFloors) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        ExtRequestPrebid updatedPrebid = (prebid != null ? prebid.toBuilder() : ExtRequestPrebid.builder()).floors(skipFloors ? BasicPriceFloorProcessor.skippedFloors((PriceFloorRules)floors, (Integer)skipRate) : BasicPriceFloorProcessor.enabledFloors((PriceFloorRules)floors, (Integer)skipRate)).build();
        return ExtRequest.of((ExtRequestPrebid)updatedPrebid);
    }

    private static PriceFloorRules enabledFloors(PriceFloorRules floors, Integer skipRate) {
        return floors.toBuilder().skipRate(skipRate).enabled(Boolean.valueOf(true)).skipped(Boolean.valueOf(false)).build();
    }

    private static PriceFloorRules skippedFloors(PriceFloorRules floors, Integer skipRate) {
        return floors.toBuilder().skipRate(skipRate).enabled(Boolean.valueOf(true)).skipped(Boolean.valueOf(true)).build();
    }
}

