/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.interpret;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.interpret.TerminalExpression;
import org.prebid.server.deals.targeting.model.LookupResult;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;

public abstract class In<T>
implements TerminalExpression {
    protected final TargetingCategory category;
    protected List<T> values;

    public In(TargetingCategory category, List<T> values) {
        this.category = Objects.requireNonNull(category);
        this.values = Collections.unmodifiableList(values);
    }

    public boolean matches(RequestContext context) {
        return this.lookupActualValue(context).anyMatch(this.values::contains);
    }

    protected abstract LookupResult<T> lookupActualValue(RequestContext var1);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof In)) {
            return false;
        }
        In other = (In)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        TargetingCategory this$category = this.category;
        TargetingCategory other$category = other.category;
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        List this$values = this.values;
        List other$values = other.values;
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof In;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TargetingCategory $category = this.category;
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        List $values = this.values;
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }
}

