/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.interpret;

import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.interpret.Expression;

public class DomainMetricAwareExpression
implements Expression {
    private final Expression domainFunction;
    private final String lineItemId;

    public DomainMetricAwareExpression(Expression domainFunction, String lineItemId) {
        this.domainFunction = domainFunction;
        this.lineItemId = lineItemId;
    }

    public boolean matches(RequestContext requestContext) {
        boolean matches = this.domainFunction.matches(requestContext);
        if (matches) {
            requestContext.txnLog().lineItemsMatchedDomainTargeting().add(this.lineItemId);
        }
        return matches;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomainMetricAwareExpression)) {
            return false;
        }
        DomainMetricAwareExpression other = (DomainMetricAwareExpression)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Expression this$domainFunction = this.domainFunction;
        Expression other$domainFunction = other.domainFunction;
        if (this$domainFunction == null ? other$domainFunction != null : !this$domainFunction.equals(other$domainFunction)) {
            return false;
        }
        String this$lineItemId = this.lineItemId;
        String other$lineItemId = other.lineItemId;
        return !(this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DomainMetricAwareExpression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $domainFunction = this.domainFunction;
        result = result * 59 + ($domainFunction == null ? 43 : $domainFunction.hashCode());
        String $lineItemId = this.lineItemId;
        result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
        return result;
    }
}

