/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Segment;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.model.GeoLocation;
import org.prebid.server.deals.targeting.model.LookupResult;
import org.prebid.server.deals.targeting.model.Size;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;
import org.prebid.server.exception.TargetingSyntaxException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.ExtUserTime;
import org.prebid.server.util.StreamUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestContext {
    private static final String EXT_BIDDER = "bidder.";
    private static final String EXT_CONTEXT_DATA = "context.data.";
    private static final String EXT_DATA = "data.";
    private final BidRequest bidRequest;
    private final Imp imp;
    private final TxnLog txnLog;
    private final AttributeReader<Imp> impReader;
    private final AttributeReader<Geo> geoReader;
    private final AttributeReader<Device> deviceReader;
    private final AttributeReader<User> userReader;
    private final AttributeReader<Site> siteReader;
    private final AttributeReader<App> appReader;

    public RequestContext(BidRequest bidRequest, Imp imp, TxnLog txnLog, JacksonMapper mapper) {
        this.bidRequest = Objects.requireNonNull(bidRequest);
        this.imp = Objects.requireNonNull(imp);
        this.txnLog = Objects.requireNonNull(txnLog);
        this.impReader = AttributeReader.forImp();
        this.geoReader = AttributeReader.forGeo((ObjectNode)RequestContext.getExtNode((Object)bidRequest.getDevice(), (T device) -> (FlexibleExtension)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)device, Device::getGeo), Geo::getExt), (JacksonMapper)mapper));
        this.deviceReader = AttributeReader.forDevice((ObjectNode)RequestContext.getExtNode((Object)bidRequest.getDevice(), Device::getExt, (JacksonMapper)mapper));
        this.userReader = AttributeReader.forUser();
        this.siteReader = AttributeReader.forSite();
        this.appReader = AttributeReader.forApp();
    }

    private static <T> ObjectNode getExtNode(T target, Function<T, FlexibleExtension> extExtractor, JacksonMapper mapper) {
        FlexibleExtension ext = target != null ? extExtractor.apply(target) : null;
        return ext != null ? (ObjectNode)mapper.mapper().valueToTree((Object)ext) : null;
    }

    public LookupResult<String> lookupString(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$TargetingCategory$Type[type.ordinal()]) {
            case 1 -> RequestContext.lookupResult((Object[])new String[]{(String)RequestContext.getIfNotNull((Object)this.bidRequest.getSite(), Site::getDomain), (String)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)this.bidRequest.getSite(), Site::getPublisher), Publisher::getDomain)});
            case 2 -> RequestContext.lookupResult((Object[])new String[]{(String)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)this.bidRequest.getSite(), Site::getPublisher), Publisher::getDomain)});
            case 3 -> RequestContext.lookupResult((Object[])new String[]{(String)RequestContext.getIfNotNull((Object)this.bidRequest.getSite(), Site::getPage)});
            case 4 -> RequestContext.lookupResult((Object[])new String[]{(String)RequestContext.getIfNotNull((Object)this.bidRequest.getApp(), App::getBundle)});
            case 5 -> RequestContext.lookupResult((Object[])new String[]{this.imp.getTagid(), (String)this.impReader.readFromExt((Object)this.imp, "gpid", RequestContext::nodeToString), (String)this.impReader.readFromExt((Object)this.imp, "data.pbadslot", RequestContext::nodeToString), (String)this.impReader.readFromExt((Object)this.imp, "data.adserver.adslot", RequestContext::nodeToString)});
            case 6 -> RequestContext.lookupResult((Object[])new String[]{(String)this.geoReader.readFromExt((Object)((Geo)RequestContext.getIfNotNull((Object)this.bidRequest.getDevice(), Device::getGeo)), path, RequestContext::nodeToString)});
            case 7 -> RequestContext.lookupResult((Object[])new String[]{(String)this.deviceReader.readFromExt((Object)this.bidRequest.getDevice(), path, RequestContext::nodeToString)});
            case 8 -> RequestContext.lookupResult((Object[])new String[]{(String)this.impReader.readFromExt((Object)this.imp, "bidder." + path, RequestContext::nodeToString)});
            case 9 -> this.userReader.read((Object)this.bidRequest.getUser(), path, RequestContext::nodeToString, String.class);
            case 10 -> this.getSiteFirstPartyData(path, RequestContext::nodeToString);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<Integer> lookupInteger(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$TargetingCategory$Type[type.ordinal()]) {
            case 11 -> RequestContext.lookupResult((Object[])new Integer[]{(Integer)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)this.imp, Imp::getBanner), Banner::getPos)});
            case 12 -> RequestContext.lookupResult((Object[])new Integer[]{(Integer)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)this.bidRequest.getUser(), User::getExt), ExtUser::getTime), ExtUserTime::getUserdow)});
            case 13 -> RequestContext.lookupResult((Object[])new Integer[]{(Integer)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)RequestContext.getIfNotNull((Object)this.bidRequest.getUser(), User::getExt), ExtUser::getTime), ExtUserTime::getUserhour)});
            case 6 -> RequestContext.lookupResult((Object[])new Integer[]{(Integer)this.geoReader.readFromExt((Object)((Geo)RequestContext.getIfNotNull((Object)this.bidRequest.getDevice(), Device::getGeo)), path, RequestContext::nodeToInteger)});
            case 8 -> RequestContext.lookupResult((Object[])new Integer[]{(Integer)this.impReader.readFromExt((Object)this.imp, "bidder." + path, RequestContext::nodeToInteger)});
            case 9 -> this.userReader.read((Object)this.bidRequest.getUser(), path, RequestContext::nodeToInteger, Integer.class);
            case 10 -> this.getSiteFirstPartyData(path, RequestContext::nodeToInteger);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<List<String>> lookupStrings(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        User user = this.bidRequest.getUser();
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$TargetingCategory$Type[type.ordinal()]) {
            case 14 -> RequestContext.lookupResult((Object[])new List[]{this.getMediaTypes()});
            case 8 -> RequestContext.lookupResult((Object[])new List[]{(List)this.impReader.readFromExt((Object)this.imp, "bidder." + path, RequestContext::nodeToListOfStrings)});
            case 15 -> RequestContext.lookupResult((Object[])new List[]{this.getSegments(category)});
            case 9 -> RequestContext.lookupResult((Object[])new List[]{RequestContext.listOfNonNulls((Object[])new String[]{(String)this.userReader.readFromObject((Object)user, path, String.class)}), (List)this.userReader.readFromExt((Object)user, path, RequestContext::nodeToListOfStrings)});
            case 10 -> this.getSiteFirstPartyData(path, RequestContext::nodeToListOfStrings);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<List<Integer>> lookupIntegers(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        String path = category.path();
        User user = this.bidRequest.getUser();
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$TargetingCategory$Type[type.ordinal()]) {
            case 8 -> RequestContext.lookupResult((Object[])new List[]{(List)this.impReader.readFromExt((Object)this.imp, "bidder." + path, RequestContext::nodeToListOfIntegers)});
            case 9 -> RequestContext.lookupResult((Object[])new List[]{RequestContext.listOfNonNulls((Object[])new Integer[]{(Integer)this.userReader.readFromObject((Object)user, path, Integer.class)}), (List)this.userReader.readFromExt((Object)user, path, RequestContext::nodeToListOfIntegers)});
            case 10 -> this.getSiteFirstPartyData(path, RequestContext::nodeToListOfIntegers);
            default -> LookupResult.empty();
        };
    }

    public LookupResult<List<Size>> lookupSizes(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        if (type != TargetingCategory.Type.size) {
            throw new TargetingSyntaxException("Unexpected category for fetching sizes for: " + type);
        }
        List sizes = ListUtils.union((List)RequestContext.sizesFromBanner((Imp)this.imp), (List)RequestContext.sizesFromVideo((Imp)this.imp));
        return !sizes.isEmpty() ? LookupResult.ofValue((Object)sizes) : LookupResult.empty();
    }

    private static List<Size> sizesFromBanner(Imp imp) {
        List formats = (List)RequestContext.getIfNotNull((Object)imp.getBanner(), Banner::getFormat);
        return ListUtils.emptyIfNull((List)formats).stream().map(format -> Size.of((Integer)format.getW(), (Integer)format.getH())).toList();
    }

    private static List<Size> sizesFromVideo(Imp imp) {
        Video video = imp.getVideo();
        Integer width = video != null ? video.getW() : null;
        Integer height = video != null ? video.getH() : null;
        return width != null && height != null ? Collections.singletonList(Size.of((Integer)width, (Integer)height)) : Collections.emptyList();
    }

    public GeoLocation lookupGeoLocation(TargetingCategory category) {
        TargetingCategory.Type type = category.type();
        if (type != TargetingCategory.Type.location) {
            throw new TargetingSyntaxException("Unexpected category for fetching geo location for: " + type);
        }
        Geo geo = (Geo)RequestContext.getIfNotNull((Object)((Device)RequestContext.getIfNotNull((Object)this.bidRequest, BidRequest::getDevice)), Device::getGeo);
        Float lat = (Float)RequestContext.getIfNotNull((Object)geo, Geo::getLat);
        Float lon = (Float)RequestContext.getIfNotNull((Object)geo, Geo::getLon);
        return lat != null && lon != null ? GeoLocation.of((Float)lat, (Float)lon) : null;
    }

    public TxnLog txnLog() {
        return this.txnLog;
    }

    @SafeVarargs
    private static <T> LookupResult<T> lookupResult(T ... candidates) {
        return LookupResult.of((List)RequestContext.listOfNonNulls((Object[])candidates));
    }

    @SafeVarargs
    private static <T> List<T> listOfNonNulls(T ... candidates) {
        return Stream.of(candidates).filter(Objects::nonNull).toList();
    }

    private static <S, T> T getIfNotNull(S source, Function<S, T> getter) {
        return source != null ? (T)getter.apply(source) : null;
    }

    private List<String> getMediaTypes() {
        ArrayList<String> mediaTypes = new ArrayList<String>();
        if (this.imp.getBanner() != null) {
            mediaTypes.add("banner");
        }
        if (this.imp.getVideo() != null) {
            mediaTypes.add("video");
        }
        if (this.imp.getXNative() != null) {
            mediaTypes.add("native");
        }
        return mediaTypes;
    }

    private <T> LookupResult<T> getSiteFirstPartyData(String path, Function<JsonNode, T> valueExtractor) {
        return RequestContext.lookupResult((Object[])new Object[]{this.impReader.readFromExt((Object)this.imp, "context.data." + path, valueExtractor), this.impReader.readFromExt((Object)this.imp, "data." + path, valueExtractor), this.siteReader.readFromExt((Object)this.bidRequest.getSite(), path, valueExtractor), this.appReader.readFromExt((Object)this.bidRequest.getApp(), path, valueExtractor)});
    }

    private List<String> getSegments(TargetingCategory category) {
        List userData = (List)RequestContext.getIfNotNull((Object)this.bidRequest.getUser(), User::getData);
        List<String> segments = ListUtils.emptyIfNull((List)userData).stream().filter(Objects::nonNull).filter(data -> Objects.equals(data.getId(), category.path())).flatMap(data -> ListUtils.emptyIfNull((List)data.getSegment()).stream()).map(Segment::getId).filter(Objects::nonNull).toList();
        return !segments.isEmpty() ? segments : null;
    }

    private static String toJsonPointer(String path) {
        return Arrays.stream(path.split("\\.")).collect(Collectors.joining("/", "/", ""));
    }

    private static String nodeToString(JsonNode node) {
        return node.isTextual() ? node.asText() : null;
    }

    private static Integer nodeToInteger(JsonNode node) {
        return node.isInt() ? Integer.valueOf(node.asInt()) : null;
    }

    private static List<String> nodeToListOfStrings(JsonNode node) {
        Function<JsonNode, String> valueExtractor = RequestContext::nodeToString;
        return node.isTextual() ? Collections.singletonList(valueExtractor.apply(node)) : RequestContext.nodeToList((JsonNode)node, valueExtractor);
    }

    private static List<Integer> nodeToListOfIntegers(JsonNode node) {
        Function<JsonNode, Integer> valueExtractor = RequestContext::nodeToInteger;
        return node.isInt() ? Collections.singletonList(valueExtractor.apply(node)) : RequestContext.nodeToList((JsonNode)node, valueExtractor);
    }

    private static <T> List<T> nodeToList(JsonNode node, Function<JsonNode, T> valueExtractor) {
        if (!node.isArray()) {
            return null;
        }
        return StreamUtil.asStream((Spliterator)node.spliterator()).map(valueExtractor).filter(Objects::nonNull).toList();
    }
}

