/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.events;

import io.vertx.core.eventbus.EventBus;
import java.util.List;
import java.util.Objects;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.deals.events.AdminEventProcessor;
import org.prebid.server.deals.events.ApplicationEventProcessor;
import org.prebid.server.deals.model.AdminCentralResponse;
import org.prebid.server.vertx.Initializable;

public class EventServiceInitializer
implements Initializable {
    private static final String ADDRESS_EVENT_OPENRTB2_AUCTION = "event.openrtb2-auction";
    private static final String ADDRESS_EVENT_LINE_ITEM_WIN = "event.line-item-win";
    private static final String ADDRESS_EVENT_DELIVERY_UPDATE = "event.delivery-update";
    private static final String ADDRESS_ADMIN_CENTRAL_COMMAND = "event.admin-central";
    private final List<ApplicationEventProcessor> applicationEventProcessors;
    private final List<AdminEventProcessor> adminEventProcessors;
    private final EventBus eventBus;

    public EventServiceInitializer(List<ApplicationEventProcessor> applicationEventProcessors, List<AdminEventProcessor> adminEventProcessors, EventBus eventBus) {
        this.applicationEventProcessors = Objects.requireNonNull(applicationEventProcessors);
        this.adminEventProcessors = Objects.requireNonNull(adminEventProcessors);
        this.eventBus = Objects.requireNonNull(eventBus);
    }

    public void initialize() {
        this.eventBus.localConsumer(ADDRESS_EVENT_OPENRTB2_AUCTION, message -> this.applicationEventProcessors.forEach(recorder -> recorder.processAuctionEvent((AuctionContext)message.body())));
        this.eventBus.localConsumer(ADDRESS_EVENT_LINE_ITEM_WIN, message -> this.applicationEventProcessors.forEach(recorder -> recorder.processLineItemWinEvent((String)message.body())));
        this.eventBus.localConsumer(ADDRESS_EVENT_DELIVERY_UPDATE, message -> this.applicationEventProcessors.forEach(ApplicationEventProcessor::processDeliveryProgressUpdateEvent));
        this.eventBus.localConsumer(ADDRESS_ADMIN_CENTRAL_COMMAND, message -> this.adminEventProcessors.forEach(recorder -> recorder.processAdminCentralEvent((AdminCentralResponse)message.body())));
    }
}

