/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.deals.TargetingService;
import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.TargetingDefinition;
import org.prebid.server.deals.targeting.interpret.And;
import org.prebid.server.deals.targeting.interpret.DomainMetricAwareExpression;
import org.prebid.server.deals.targeting.interpret.Expression;
import org.prebid.server.deals.targeting.interpret.InIntegers;
import org.prebid.server.deals.targeting.interpret.InStrings;
import org.prebid.server.deals.targeting.interpret.IntersectsIntegers;
import org.prebid.server.deals.targeting.interpret.IntersectsSizes;
import org.prebid.server.deals.targeting.interpret.IntersectsStrings;
import org.prebid.server.deals.targeting.interpret.Matches;
import org.prebid.server.deals.targeting.interpret.Not;
import org.prebid.server.deals.targeting.interpret.Or;
import org.prebid.server.deals.targeting.interpret.Within;
import org.prebid.server.deals.targeting.model.GeoRegion;
import org.prebid.server.deals.targeting.model.Size;
import org.prebid.server.deals.targeting.syntax.BooleanOperator;
import org.prebid.server.deals.targeting.syntax.MatchingFunction;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;
import org.prebid.server.exception.TargetingSyntaxException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.StreamUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TargetingService {
    private final JacksonMapper mapper;

    public TargetingService(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public TargetingDefinition parseTargetingDefinition(JsonNode targetingDefinition, String lineItemId) {
        return TargetingDefinition.of((Expression)this.parseNode(targetingDefinition, lineItemId));
    }

    public boolean matchesTargeting(BidRequest bidRequest, Imp imp, TargetingDefinition targetingDefinition, AuctionContext auctionContext) {
        RequestContext requestContext = new RequestContext(bidRequest, imp, auctionContext.getTxnLog(), this.mapper);
        return targetingDefinition.getRootExpression().matches(requestContext);
    }

    private Expression parseNode(JsonNode node, String lineItemId) {
        Map.Entry field = TargetingService.validateIsSingleElementObject((JsonNode)node);
        String fieldName = (String)field.getKey();
        if (BooleanOperator.isBooleanOperator((String)fieldName)) {
            return this.parseBooleanOperator(fieldName, (JsonNode)field.getValue(), lineItemId);
        }
        if (TargetingCategory.isTargetingCategory((String)fieldName)) {
            return this.parseTargetingCategory(fieldName, (JsonNode)field.getValue(), lineItemId);
        }
        throw new TargetingSyntaxException("Expected either boolean operator or targeting category, got " + fieldName);
    }

    private Expression parseBooleanOperator(String fieldName, JsonNode value, String lineItemId) {
        BooleanOperator operator = BooleanOperator.fromString((String)fieldName);
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$BooleanOperator[operator.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new And(TargetingService.parseArray((JsonNode)value, (T node) -> this.parseNode(node, lineItemId)));
            case 2 -> new Or(TargetingService.parseArray((JsonNode)value, (T node) -> this.parseNode(node, lineItemId)));
            case 3 -> new Not(this.parseNode(value, lineItemId));
        };
    }

    private Expression parseTargetingCategory(String fieldName, JsonNode value, String lineItemId) {
        TargetingCategory category = TargetingCategory.fromString((String)fieldName);
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$TargetingCategory$Type[category.type().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new IntersectsSizes(category, TargetingService.parseArrayFunction((JsonNode)value, (MatchingFunction)MatchingFunction.INTERSECTS, arg_0 -> this.parseSize(arg_0)));
            case 2, 3 -> new IntersectsStrings(category, TargetingService.parseArrayFunction((JsonNode)value, (MatchingFunction)MatchingFunction.INTERSECTS, TargetingService::parseString));
            case 4 -> TargetingService.prepareDomainExpression((TargetingCategory)category, (JsonNode)value, (String)lineItemId);
            case 5 -> new DomainMetricAwareExpression(TargetingService.parseStringFunction((TargetingCategory)category, (JsonNode)value), lineItemId);
            case 6, 7, 8 -> TargetingService.parseStringFunction((TargetingCategory)category, (JsonNode)value);
            case 9, 10, 11 -> new InIntegers(category, TargetingService.parseArrayFunction((JsonNode)value, (MatchingFunction)MatchingFunction.IN, TargetingService::parseInteger));
            case 12, 13 -> new InStrings(category, TargetingService.parseArrayFunction((JsonNode)value, (MatchingFunction)MatchingFunction.IN, TargetingService::parseString));
            case 14 -> new Within(category, (GeoRegion)TargetingService.parseSingleObjectFunction((JsonNode)value, (MatchingFunction)MatchingFunction.WITHIN, arg_0 -> this.parseGeoRegion(arg_0)));
            case 15, 16, 17 -> TargetingService.parseTypedFunction((TargetingCategory)category, (JsonNode)value);
        };
    }

    private static Or prepareDomainExpression(TargetingCategory category, JsonNode value, String lineItemId) {
        DomainMetricAwareExpression domainExpression = new DomainMetricAwareExpression(TargetingService.parseStringFunction((TargetingCategory)category, (JsonNode)value), lineItemId);
        TargetingCategory publisherDomainCategory = new TargetingCategory(TargetingCategory.Type.publisherDomain);
        DomainMetricAwareExpression publisherDomainExpression = new DomainMetricAwareExpression(TargetingService.parseStringFunction((TargetingCategory)publisherDomainCategory, (JsonNode)value), lineItemId);
        return new Or(List.of(domainExpression, publisherDomainExpression));
    }

    private static <T> List<T> parseArrayFunction(JsonNode value, MatchingFunction function, Function<JsonNode, T> mapper) {
        return TargetingService.parseArray((JsonNode)TargetingService.validateIsFunction((JsonNode)value, (MatchingFunction)function), mapper);
    }

    private static <T> T parseSingleObjectFunction(JsonNode value, MatchingFunction function, Function<JsonNode, T> mapper) {
        return mapper.apply(TargetingService.validateIsFunction((JsonNode)value, (MatchingFunction)function));
    }

    private static Expression parseStringFunction(TargetingCategory category, JsonNode value) {
        Map.Entry field = TargetingService.validateIsSingleElementObject((JsonNode)value);
        MatchingFunction function = TargetingService.validateCompatibleFunction((Map.Entry)field, (MatchingFunction[])new MatchingFunction[]{MatchingFunction.MATCHES, MatchingFunction.IN});
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$MatchingFunction[function.ordinal()]) {
            case 1 -> new Matches(category, TargetingService.parseString((JsonNode)((JsonNode)field.getValue())));
            case 2 -> TargetingService.createInStringsFunction((TargetingCategory)category, (JsonNode)((JsonNode)field.getValue()));
            default -> throw new IllegalStateException("Unexpected string function " + function.value());
        };
    }

    private static Expression parseTypedFunction(TargetingCategory category, JsonNode value) {
        Map.Entry field = TargetingService.validateIsSingleElementObject((JsonNode)value);
        MatchingFunction function = TargetingService.validateCompatibleFunction((Map.Entry)field, (MatchingFunction[])new MatchingFunction[]{MatchingFunction.MATCHES, MatchingFunction.IN, MatchingFunction.INTERSECTS});
        JsonNode functionValue = (JsonNode)field.getValue();
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$MatchingFunction[function.ordinal()]) {
            case 1 -> new Matches(category, TargetingService.parseString((JsonNode)functionValue));
            case 2 -> TargetingService.parseTypedInFunction((TargetingCategory)category, (JsonNode)functionValue);
            case 3 -> TargetingService.parseTypedIntersectsFunction((TargetingCategory)category, (JsonNode)functionValue);
            default -> throw new IllegalStateException("Unexpected typed function " + function.value());
        };
    }

    private Size parseSize(JsonNode node) {
        Size size;
        TargetingService.validateIsObject((JsonNode)node);
        try {
            size = (Size)this.mapper.mapper().treeToValue((TreeNode)node, Size.class);
        }
        catch (JsonProcessingException e) {
            throw new TargetingSyntaxException("Exception occurred while parsing size: " + e.getMessage(), (Throwable)e);
        }
        if (size.getH() == null || size.getW() == null) {
            throw new TargetingSyntaxException("Height and width in size definition could not be null or missing");
        }
        return size;
    }

    private static String parseString(JsonNode node) {
        TargetingService.validateIsString((JsonNode)node);
        String value = node.textValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new TargetingSyntaxException("String value could not be empty");
        }
        return value;
    }

    private static Integer parseInteger(JsonNode node) {
        TargetingService.validateIsInteger((JsonNode)node);
        return node.intValue();
    }

    private GeoRegion parseGeoRegion(JsonNode node) {
        GeoRegion region;
        TargetingService.validateIsObject((JsonNode)node);
        try {
            region = (GeoRegion)this.mapper.mapper().treeToValue((TreeNode)node, GeoRegion.class);
        }
        catch (JsonProcessingException e) {
            throw new TargetingSyntaxException("Exception occurred while parsing geo region: " + e.getMessage(), (Throwable)e);
        }
        if (region.getLat() == null || region.getLon() == null || region.getRadiusMiles() == null) {
            throw new TargetingSyntaxException("Lat, lon and radiusMiles in geo region definition could not be null or missing");
        }
        return region;
    }

    private static <T> List<T> parseArray(JsonNode node, Function<JsonNode, T> mapper) {
        TargetingService.validateIsArray((JsonNode)node);
        return StreamUtil.asStream((Spliterator)node.spliterator()).map(mapper).toList();
    }

    private static Expression parseTypedInFunction(TargetingCategory category, JsonNode value) {
        return TargetingService.parseTypedArrayFunction((TargetingCategory)category, (JsonNode)value, TargetingService::createInIntegersFunction, TargetingService::createInStringsFunction);
    }

    private static Expression parseTypedIntersectsFunction(TargetingCategory category, JsonNode value) {
        return TargetingService.parseTypedArrayFunction((TargetingCategory)category, (JsonNode)value, TargetingService::createIntersectsIntegersFunction, TargetingService::createIntersectsStringsFunction);
    }

    private static Expression parseTypedArrayFunction(TargetingCategory category, JsonNode value, BiFunction<TargetingCategory, JsonNode, Expression> integerCreator, BiFunction<TargetingCategory, JsonNode, Expression> stringCreator) {
        TargetingService.validateIsArray((JsonNode)value);
        Iterator iterator = value.iterator();
        JsonNodeType dataType = iterator.hasNext() ? ((JsonNode)iterator.next()).getNodeType() : JsonNodeType.STRING;
        return switch (1.$SwitchMap$com$fasterxml$jackson$databind$node$JsonNodeType[dataType.ordinal()]) {
            case 1 -> integerCreator.apply(category, value);
            case 2 -> stringCreator.apply(category, value);
            default -> throw new TargetingSyntaxException("Expected integer or string, got " + dataType);
        };
    }

    private static Expression createInIntegersFunction(TargetingCategory category, JsonNode value) {
        return new InIntegers(category, TargetingService.parseArray((JsonNode)value, TargetingService::parseInteger));
    }

    private static InStrings createInStringsFunction(TargetingCategory category, JsonNode value) {
        return new InStrings(category, TargetingService.parseArray((JsonNode)value, TargetingService::parseString));
    }

    private static Expression createIntersectsStringsFunction(TargetingCategory category, JsonNode value) {
        return new IntersectsStrings(category, TargetingService.parseArray((JsonNode)value, TargetingService::parseString));
    }

    private static Expression createIntersectsIntegersFunction(TargetingCategory category, JsonNode value) {
        return new IntersectsIntegers(category, TargetingService.parseArray((JsonNode)value, TargetingService::parseInteger));
    }

    private static void validateIsObject(JsonNode value) {
        if (!value.isObject()) {
            throw new TargetingSyntaxException("Expected object, got " + value.getNodeType());
        }
    }

    private static Map.Entry<String, JsonNode> validateIsSingleElementObject(JsonNode value) {
        TargetingService.validateIsObject((JsonNode)value);
        if (value.size() != 1) {
            throw new TargetingSyntaxException("Expected only one element in the object, got " + value.size());
        }
        return (Map.Entry)value.fields().next();
    }

    private static void validateIsArray(JsonNode value) {
        if (!value.isArray()) {
            throw new TargetingSyntaxException("Expected array, got " + value.getNodeType());
        }
    }

    private static void validateIsString(JsonNode value) {
        if (!value.isTextual()) {
            throw new TargetingSyntaxException("Expected string, got " + value.getNodeType());
        }
    }

    private static void validateIsInteger(JsonNode value) {
        if (!value.isInt()) {
            throw new TargetingSyntaxException("Expected integer, got " + value.getNodeType());
        }
    }

    private static JsonNode validateIsFunction(JsonNode value, MatchingFunction function) {
        Map.Entry field = TargetingService.validateIsSingleElementObject((JsonNode)value);
        String fieldName = (String)field.getKey();
        if (!MatchingFunction.isMatchingFunction((String)fieldName)) {
            throw new TargetingSyntaxException("Expected matching function, got " + fieldName);
        }
        if (MatchingFunction.fromString((String)fieldName) != function) {
            throw new TargetingSyntaxException("Expected %s matching function, got %s".formatted(function.value(), fieldName));
        }
        return (JsonNode)field.getValue();
    }

    private static MatchingFunction validateCompatibleFunction(Map.Entry<String, JsonNode> field, MatchingFunction ... compatibleFunctions) {
        String fieldName = field.getKey();
        if (!MatchingFunction.isMatchingFunction((String)fieldName)) {
            throw new TargetingSyntaxException("Expected matching function, got " + fieldName);
        }
        MatchingFunction function = MatchingFunction.fromString((String)fieldName);
        if (!Arrays.asList(compatibleFunctions).contains(function)) {
            throw new TargetingSyntaxException("Expected one of %s matching functions, got %s".formatted(Arrays.stream(compatibleFunctions).map(MatchingFunction::value).collect(Collectors.joining(", ")), fieldName));
        }
        return function;
    }
}

