/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.Suspendable;
import org.prebid.server.deals.model.AlertPriority;
import org.prebid.server.deals.model.DeploymentProperties;
import org.prebid.server.deals.model.PlannerProperties;
import org.prebid.server.deals.proto.LineItemMetaData;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class PlannerService
implements Suspendable {
    private static final Logger logger = LoggerFactory.getLogger(PlannerService.class);
    protected static final TypeReference<List<LineItemMetaData>> LINE_ITEM_METADATA_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String BASIC_AUTH_PATTERN = "Basic %s";
    private static final String PG_TRX_ID = "pg-trx-id";
    private static final String INSTANCE_ID_PARAMETER = "instanceId";
    private static final String REGION_PARAMETER = "region";
    private static final String VENDOR_PARAMETER = "vendor";
    private static final String SERVICE_NAME = "planner";
    private static final String PBS_PLANNER_CLIENT_ERROR = "pbs-planner-client-error";
    private static final String PBS_PLANNER_EMPTY_RESPONSE = "pbs-planner-empty-response-error";
    private final LineItemService lineItemService;
    private final DeliveryProgressService deliveryProgressService;
    private final AlertHttpService alertHttpService;
    protected final HttpClient httpClient;
    private final Metrics metrics;
    private final Clock clock;
    private final JacksonMapper mapper;
    protected final String planEndpoint;
    private final long plannerTimeout;
    private final String basicAuthHeader;
    protected final AtomicBoolean isPlannerResponsive;
    private volatile boolean isSuspended;

    public PlannerService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, LineItemService lineItemService, DeliveryProgressService deliveryProgressService, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, JacksonMapper mapper) {
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.deliveryProgressService = Objects.requireNonNull(deliveryProgressService);
        this.alertHttpService = Objects.requireNonNull(alertHttpService);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
        this.mapper = Objects.requireNonNull(mapper);
        this.planEndpoint = PlannerService.buildPlannerMetaDataUrl((String)plannerProperties.getPlanEndpoint(), (String)deploymentProperties.getPbsHostId(), (String)deploymentProperties.getPbsRegion(), (String)deploymentProperties.getPbsVendor());
        this.plannerTimeout = plannerProperties.getTimeoutMs();
        this.basicAuthHeader = PlannerService.authHeader((String)plannerProperties.getUsername(), (String)plannerProperties.getPassword());
        this.isPlannerResponsive = new AtomicBoolean(true);
    }

    public void suspend() {
        this.isSuspended = true;
    }

    protected Future<List<LineItemMetaData>> fetchLineItemMetaData(String plannerUrl, MultiMap headers) {
        logger.info((Object)"Requesting line items metadata and plans from Planner, {0} is {1}", new Object[]{"pg-trx-id", headers.get("pg-trx-id")});
        long startTime = this.clock.millis();
        return this.httpClient.get(plannerUrl, headers, this.plannerTimeout).map(httpClientResponse -> this.processLineItemMetaDataResponse(httpClientResponse, startTime));
    }

    protected MultiMap headers() {
        return MultiMap.caseInsensitiveMultiMap().add(HttpUtil.AUTHORIZATION_HEADER, (CharSequence)this.basicAuthHeader).add("pg-trx-id", UUID.randomUUID().toString());
    }

    protected List<LineItemMetaData> processLineItemMetaDataResponse(HttpClientResponse response, long startTime) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("Failed to fetch data from Planner, HTTP status code " + statusCode);
        }
        String body = response.getBody();
        if (body == null) {
            throw new PreBidException("Failed to fetch data from planner, response can't be null");
        }
        this.metrics.updateRequestTimeMetric(MetricName.planner_request_time, this.clock.millis() - startTime);
        logger.debug((Object)"Received line item metadata and plans from Planner: {0}", new Object[]{body});
        try {
            List lineItemMetaData = (List)this.mapper.decodeValue(body, LINE_ITEM_METADATA_TYPE_REFERENCE);
            this.validateForEmptyResponse(lineItemMetaData);
            this.metrics.updateLineItemsNumberMetric((long)lineItemMetaData.size());
            logger.info((Object)"Received line item metadata from Planner, amount: {0}", new Object[]{lineItemMetaData.size()});
            return lineItemMetaData;
        }
        catch (DecodeException e) {
            String errorMessage = "Cannot parse response: " + body;
            throw new PreBidException(errorMessage, (Throwable)e);
        }
    }

    private void validateForEmptyResponse(List<LineItemMetaData> lineItemMetaData) {
        if (CollectionUtils.isEmpty(lineItemMetaData)) {
            this.alertHttpService.alertWithPeriod("planner", "pbs-planner-empty-response-error", AlertPriority.LOW, "Response without line items was received from planner");
        } else {
            this.alertHttpService.resetAlertCount("pbs-planner-empty-response-error");
        }
    }

    private static String authHeader(String username, String password) {
        return "Basic %s".formatted(Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
    }

    private static String buildPlannerMetaDataUrl(String plannerMetaDataUrl, String pbsHostname, String pbsRegion, String pbsVendor) {
        return "%s?%s=%s&%s=%s&%s=%s".formatted(plannerMetaDataUrl, "instanceId", pbsHostname, "region", pbsRegion, "vendor", pbsVendor);
    }

    public void updateLineItemMetaData() {
        if (this.isSuspended) {
            logger.warn((Object)"Fetch request was not sent to general planner, as planner service is suspended from register endpoint.");
            return;
        }
        MultiMap headers = this.headers();
        this.fetchLineItemMetaData(this.planEndpoint, headers).recover(ignored -> this.startRecoveryProcess(this.planEndpoint, headers)).onComplete(arg_0 -> this.handleInitializationResult(arg_0));
    }

    private Future<List<LineItemMetaData>> startRecoveryProcess(String planEndpoint, MultiMap headers) {
        this.metrics.updatePlannerRequestMetric(false);
        logger.info((Object)"Retry to fetch line items from general planner by uri = {0}", new Object[]{planEndpoint});
        return this.fetchLineItemMetaData(planEndpoint, headers);
    }

    protected void handleInitializationResult(AsyncResult<List<LineItemMetaData>> plannerResponse) {
        if (plannerResponse.succeeded()) {
            this.handleSuccessInitialization(plannerResponse);
        } else {
            this.handleFailedInitialization(plannerResponse);
        }
    }

    private void handleSuccessInitialization(AsyncResult<List<LineItemMetaData>> plannerResponse) {
        this.alertHttpService.resetAlertCount("pbs-planner-client-error");
        this.metrics.updatePlannerRequestMetric(true);
        this.isPlannerResponsive.set(true);
        this.lineItemService.updateIsPlannerResponsive(true);
        this.updateMetaData((List)plannerResponse.result());
    }

    private void handleFailedInitialization(AsyncResult<List<LineItemMetaData>> plannerResponse) {
        String message = "Failed to retrieve line items from GP. Reason: " + plannerResponse.cause().getMessage();
        this.alertHttpService.alertWithPeriod("planner", "pbs-planner-client-error", AlertPriority.MEDIUM, message);
        logger.warn((Object)message);
        this.isPlannerResponsive.set(false);
        this.lineItemService.updateIsPlannerResponsive(false);
        this.metrics.updatePlannerRequestMetric(false);
    }

    private void updateMetaData(List<LineItemMetaData> metaData) {
        this.lineItemService.updateLineItems(metaData, this.isPlannerResponsive.get());
        this.deliveryProgressService.processDeliveryProgressUpdateEvent();
    }
}

