/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.zip.GZIPOutputStream;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DeliveryProgressReportFactory;
import org.prebid.server.deals.Suspendable;
import org.prebid.server.deals.lineitem.DeliveryProgress;
import org.prebid.server.deals.lineitem.LineItemStatus;
import org.prebid.server.deals.model.AlertPriority;
import org.prebid.server.deals.model.DeliveryStatsProperties;
import org.prebid.server.deals.proto.report.DeliveryProgressReport;
import org.prebid.server.deals.proto.report.DeliveryProgressReportBatch;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeliveryStatsService
implements Suspendable {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryStatsService.class);
    private static final String BASIC_AUTH_PATTERN = "Basic %s";
    private static final String PG_TRX_ID = "pg-trx-id";
    private static final String PBS_DELIVERY_CLIENT_ERROR = "pbs-delivery-stats-client-error";
    private static final String SERVICE_NAME = "deliveryStats";
    public static final String GZIP = "gzip";
    private final DeliveryStatsProperties deliveryStatsProperties;
    private final DeliveryProgressReportFactory deliveryProgressReportFactory;
    private final AlertHttpService alertHttpService;
    private final HttpClient httpClient;
    private final Metrics metrics;
    private final Clock clock;
    private final Vertx vertx;
    private final JacksonMapper mapper;
    private final String basicAuthHeader;
    private final NavigableSet<DeliveryProgressReportBatch> requiredBatches;
    private volatile boolean isSuspended;

    public DeliveryStatsService(DeliveryStatsProperties deliveryStatsProperties, DeliveryProgressReportFactory deliveryProgressReportFactory, AlertHttpService alertHttpService, HttpClient httpClient, Metrics metrics, Clock clock, Vertx vertx, JacksonMapper mapper) {
        this.deliveryStatsProperties = Objects.requireNonNull(deliveryStatsProperties);
        this.deliveryProgressReportFactory = Objects.requireNonNull(deliveryProgressReportFactory);
        this.alertHttpService = Objects.requireNonNull(alertHttpService);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.clock = Objects.requireNonNull(clock);
        this.vertx = Objects.requireNonNull(vertx);
        this.metrics = Objects.requireNonNull(metrics);
        this.mapper = Objects.requireNonNull(mapper);
        this.basicAuthHeader = DeliveryStatsService.authHeader((String)deliveryStatsProperties.getUsername(), (String)deliveryStatsProperties.getPassword());
        this.requiredBatches = new ConcurrentSkipListSet<DeliveryProgressReportBatch>(Comparator.comparing(DeliveryProgressReportBatch::getDataWindowEndTimeStamp).thenComparing(DeliveryProgressReportBatch::hashCode));
    }

    public void suspend() {
        this.isSuspended = true;
    }

    public void addDeliveryProgress(DeliveryProgress deliveryProgress, Map<String, LineItemStatus> overallLineItemStatuses) {
        this.requiredBatches.add(this.deliveryProgressReportFactory.batchFromDeliveryProgress(deliveryProgress, overallLineItemStatuses, null, this.deliveryStatsProperties.getLineItemsPerReport(), false));
    }

    public void sendDeliveryProgressReports() {
        this.sendDeliveryProgressReports(ZonedDateTime.now(this.clock));
    }

    public void sendDeliveryProgressReports(ZonedDateTime now) {
        if (this.isSuspended) {
            logger.warn((Object)"Report will not be sent, as service was suspended from register response");
            return;
        }
        long batchesIntervalMs = this.deliveryStatsProperties.getBatchesIntervalMs();
        int batchesCount = this.requiredBatches.size();
        HashSet sentBatches = new HashSet();
        this.requiredBatches.stream().reduce(Future.succeededFuture(), (future, batch) -> future.compose(v -> this.sendBatch(batch, now).map(aVoid -> sentBatches.add(batch)).compose(aVoid -> batchesIntervalMs > 0L && batchesCount > sentBatches.size() ? this.setInterval(batchesIntervalMs) : Future.succeededFuture())), (a, b) -> Promise.promise().future()).onComplete(result -> this.handleDeliveryResult(result, batchesCount, sentBatches));
    }

    protected Future<Void> sendBatch(DeliveryProgressReportBatch deliveryProgressReportBatch, ZonedDateTime now) {
        Promise promise = Promise.promise();
        MultiMap headers = this.headers();
        HashSet sentReports = new HashSet();
        long reportIntervalMs = this.deliveryStatsProperties.getReportsIntervalMs();
        Set reports = deliveryProgressReportBatch.getReports();
        int reportsCount = reports.size();
        reports.stream().reduce(Future.succeededFuture(), (future, report) -> future.compose(v -> this.sendReport(report, headers, now).map(aVoid -> sentReports.add(report))).compose(aVoid -> reportIntervalMs > 0L && reportsCount > sentReports.size() ? this.setInterval(reportIntervalMs) : Future.succeededFuture()), (a, b) -> Promise.promise().future()).onComplete(result -> this.handleBatchDelivery(result, deliveryProgressReportBatch, sentReports, promise));
        return promise.future();
    }

    protected Future<Void> sendReport(DeliveryProgressReport deliveryProgressReport, MultiMap headers, ZonedDateTime now) {
        Promise promise = Promise.promise();
        long startTime = this.clock.millis();
        if (this.isSuspended) {
            logger.warn((Object)"Report will not be sent, as service was suspended from register response");
            promise.complete();
            return promise.future();
        }
        String body = this.mapper.encodeToString((Object)this.deliveryProgressReportFactory.updateReportTimeStamp(deliveryProgressReport, now));
        logger.info((Object)"Sending delivery progress report to Delivery Stats, {0} is {1}", new Object[]{"pg-trx-id", headers.get("pg-trx-id")});
        logger.debug((Object)"Delivery progress report is: {0}", new Object[]{body});
        if (this.deliveryStatsProperties.isRequestCompressionEnabled()) {
            headers.add("Content-Encoding", "gzip");
            this.httpClient.request(HttpMethod.POST, this.deliveryStatsProperties.getEndpoint(), headers, DeliveryStatsService.gzipBody((String)body), this.deliveryStatsProperties.getTimeoutMs()).onComplete(result -> this.handleDeliveryProgressReport(result, deliveryProgressReport, promise, startTime));
        } else {
            this.httpClient.post(this.deliveryStatsProperties.getEndpoint(), headers, body, this.deliveryStatsProperties.getTimeoutMs()).onComplete(result -> this.handleDeliveryProgressReport(result, deliveryProgressReport, promise, startTime));
        }
        return promise.future();
    }

    private void handleDeliveryProgressReport(AsyncResult<HttpClientResponse> result, DeliveryProgressReport deliveryProgressReport, Promise<Void> promise, long startTime) {
        this.metrics.updateRequestTimeMetric(MetricName.delivery_request_time, this.clock.millis() - startTime);
        if (result.failed()) {
            logger.warn((Object)"Cannot send delivery progress report to delivery stats service", result.cause());
            promise.fail((Throwable)new PreBidException("Sending report with id = %s failed in a reason: %s".formatted(deliveryProgressReport.getReportId(), result.cause().getMessage())));
        } else {
            int statusCode = ((HttpClientResponse)result.result()).getStatusCode();
            String reportId = deliveryProgressReport.getReportId();
            if (statusCode == 200 || statusCode == 409) {
                this.handleSuccessfulResponse(deliveryProgressReport, promise, statusCode, reportId);
            } else {
                logger.warn((Object)"HTTP status code {0}", new Object[]{statusCode});
                promise.fail((Throwable)new PreBidException("Delivery stats service responded with status code = %s for report with id = %s".formatted(statusCode, deliveryProgressReport.getReportId())));
            }
        }
    }

    private void handleSuccessfulResponse(DeliveryProgressReport deliveryProgressReport, Promise<Void> promise, int statusCode, String reportId) {
        this.metrics.updateDeliveryRequestMetric(true);
        promise.complete();
        if (statusCode == 409) {
            logger.info((Object)"Delivery stats service respond with 409 duplicated, report with {0} line items and id = {1} was already delivered before and will be removed from from delivery queue", new Object[]{deliveryProgressReport.getLineItemStatus().size(), reportId});
        } else {
            logger.info((Object)"Delivery progress report with {0} line items and id = {1} was successfully sent to delivery stats service", new Object[]{deliveryProgressReport.getLineItemStatus().size(), reportId});
        }
    }

    private Future<Void> setInterval(long interval) {
        Promise promise = Promise.promise();
        this.vertx.setTimer(interval, event -> promise.complete());
        return promise.future();
    }

    private void handleDeliveryResult(AsyncResult<Void> result, int reportBatchesNumber, Set<DeliveryProgressReportBatch> sentBatches) {
        if (result.failed()) {
            logger.warn((Object)"Failed to send {0} report batches, {1} report batches left to send. Reason is: {2}", new Object[]{reportBatchesNumber, reportBatchesNumber - sentBatches.size(), result.cause().getMessage()});
            this.alertHttpService.alertWithPeriod("deliveryStats", "pbs-delivery-stats-client-error", AlertPriority.MEDIUM, "Report was not send to delivery stats service with a reason: " + result.cause().getMessage());
            this.requiredBatches.removeAll(sentBatches);
            this.handleFailedReportDelivery();
        } else {
            this.requiredBatches.clear();
            this.alertHttpService.resetAlertCount("pbs-delivery-stats-client-error");
            logger.info((Object)"{0} report batches were successfully sent.", new Object[]{reportBatchesNumber});
        }
    }

    private void handleBatchDelivery(AsyncResult<Void> result, DeliveryProgressReportBatch deliveryProgressReportBatch, Set<DeliveryProgressReport> sentReports, Promise<Void> promise) {
        String reportId = deliveryProgressReportBatch.getReportId();
        String endTimeWindow = deliveryProgressReportBatch.getDataWindowEndTimeStamp();
        int batchSize = deliveryProgressReportBatch.getReports().size();
        int sentSize = sentReports.size();
        if (result.succeeded()) {
            logger.info((Object)"Batch of reports with reports id = {0}, end time window = {1} and size {2} was successfully sent", new Object[]{reportId, endTimeWindow, batchSize});
            promise.complete();
        } else {
            logger.warn((Object)"Failed to sent batch of reports with reports id = {0} end time windows = {1}. {2} out of {3} were sent.", new Object[]{reportId, endTimeWindow, sentSize, batchSize});
            deliveryProgressReportBatch.removeReports(sentReports);
            promise.fail(result.cause().getMessage());
        }
    }

    protected MultiMap headers() {
        return MultiMap.caseInsensitiveMultiMap().add(HttpUtil.AUTHORIZATION_HEADER, (CharSequence)this.basicAuthHeader).add(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpUtil.APPLICATION_JSON_CONTENT_TYPE).add("pg-trx-id", UUID.randomUUID().toString());
    }

    private static String authHeader(String username, String password) {
        return "Basic %s".formatted(Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] gzipBody(String body) {
        try (ByteArrayOutputStream obj = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(obj);){
                gzip.write(body.getBytes(StandardCharsets.UTF_8));
                gzip.finish();
                byArray = obj.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new PreBidException("Failed to gzip request with a reason : " + e.getMessage());
        }
    }

    private void handleFailedReportDelivery() {
        this.metrics.updateDeliveryRequestMetric(false);
        while (this.requiredBatches.size() > this.deliveryStatsProperties.getCachedReportsNumber()) {
            this.requiredBatches.pollFirst();
        }
    }
}

