/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Pmp;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.model.MatchLineItemsResult;
import org.prebid.server.deals.proto.LineItemSize;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.CriteriaLogManager;
import org.prebid.server.proto.openrtb.ext.request.ExtDeal;
import org.prebid.server.proto.openrtb.ext.request.ExtDealLine;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DealsService {
    private static final Logger logger = LoggerFactory.getLogger(DealsService.class);
    private static final String LINE_FIELD = "line";
    private static final String LINE_BIDDER_FIELD = "bidder";
    private static final String BIDDER_FIELD = "bidder";
    private static final String PG_DEALS_ONLY = "pgdealsonly";
    private final LineItemService lineItemService;
    private final JacksonMapper mapper;
    private final CriteriaLogManager criteriaLogManager;

    public DealsService(LineItemService lineItemService, JacksonMapper mapper, CriteriaLogManager criteriaLogManager) {
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.mapper = Objects.requireNonNull(mapper);
        this.criteriaLogManager = Objects.requireNonNull(criteriaLogManager);
    }

    public BidderRequest matchAndPopulateDeals(BidderRequest bidderRequest, BidderAliases aliases, AuctionContext context) {
        String bidder = bidderRequest.getBidder();
        BidRequest bidRequest = bidderRequest.getBidRequest();
        Map impIdToDeals = this.match(bidRequest, bidder, aliases, context);
        BidRequest modifiedRequest = DealsService.populateDeals((BidRequest)bidRequest, (Map)impIdToDeals, (BiFunction)DealsService.combinerFor((String)bidder, (BidderAliases)aliases));
        return bidderRequest.toBuilder().impIdToDeals(impIdToDeals).bidRequest(modifiedRequest).build();
    }

    private Map<String, List<Deal>> match(BidRequest bidRequest, String bidder, BidderAliases aliases, AuctionContext context) {
        boolean accountHasDeals = this.lineItemService.accountHasDeals(context);
        if (!accountHasDeals) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Deal>> impIdToDeals = new HashMap<String, List<Deal>>();
        for (Imp imp : bidRequest.getImp()) {
            MatchLineItemsResult matchResult = this.lineItemService.findMatchingLineItems(bidRequest, imp, bidder, aliases, context);
            List lineItems = matchResult.getLineItems();
            List<Deal> deals = lineItems.stream().peek(arg_0 -> this.logLineItem(arg_0)).map(lineItem -> this.toDeal(lineItem, imp)).toList();
            if (deals.isEmpty()) continue;
            impIdToDeals.put(imp.getId(), deals);
        }
        return impIdToDeals;
    }

    private void logLineItem(LineItem lineItem) {
        this.criteriaLogManager.log(logger, lineItem.getAccountId(), lineItem.getSource(), lineItem.getLineItemId(), (Object)"LineItem %s is ready to be served".formatted(lineItem.getLineItemId()), arg_0 -> ((Logger)logger).debug(arg_0));
    }

    private Deal toDeal(LineItem lineItem, Imp imp) {
        return Deal.builder().id(lineItem.getDealId()).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)ExtDeal.of((ExtDealLine)DealsService.toExtDealLine((Imp)imp, (LineItem)lineItem)))).build();
    }

    private static ExtDealLine toExtDealLine(Imp imp, LineItem lineItem) {
        List formats = (List)ObjectUtil.getIfNotNull((Object)imp.getBanner(), Banner::getFormat);
        List lineItemSizes = lineItem.getSizes();
        List lineSizes = CollectionUtils.isNotEmpty((Collection)formats) && CollectionUtils.isNotEmpty((Collection)lineItemSizes) ? DealsService.intersectionOf((List)formats, (List)lineItemSizes) : null;
        return ExtDealLine.of((String)lineItem.getLineItemId(), (String)lineItem.getExtLineItemId(), (List)lineSizes, (String)lineItem.getSource());
    }

    private static List<Format> intersectionOf(List<Format> formats, List<LineItemSize> lineItemSizes) {
        HashSet<Format> formatsSet = new HashSet<Format>(formats);
        Set lineItemFormatsSet = lineItemSizes.stream().map(size -> Format.builder().w(size.getW()).h(size.getH()).build()).collect(Collectors.toSet());
        List<Format> matchedSizes = lineItemFormatsSet.stream().filter(formatsSet::contains).toList();
        return CollectionUtils.isNotEmpty(matchedSizes) ? matchedSizes : null;
    }

    private static BiFunction<List<Deal>, List<Deal>, List<Deal>> combinerFor(String bidder, BidderAliases aliases) {
        return (originalDeals, matchedDeals) -> Stream.concat(originalDeals.stream().filter(deal -> DealsService.isDealCorrespondsToBidder((Deal)deal, (String)bidder, (BidderAliases)aliases)), matchedDeals.stream()).map(DealsService::prepareDealForExchange).toList();
    }

    private static boolean isDealCorrespondsToBidder(Deal deal, String bidder, BidderAliases aliases) {
        JsonNode extLineBidder = DealsService.extLineBidder((Deal)deal);
        if (!DealsService.isTextual((JsonNode)extLineBidder)) {
            return true;
        }
        return aliases.isSame(extLineBidder.textValue(), bidder);
    }

    private static JsonNode extLineBidder(Deal deal) {
        ObjectNode ext = deal != null ? deal.getExt() : null;
        JsonNode extLine = ext != null ? ext.get("line") : null;
        return extLine != null ? extLine.get("bidder") : null;
    }

    private static boolean isTextual(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isTextual();
    }

    private static Deal prepareDealForExchange(Deal deal) {
        JsonNode extLineBidder = DealsService.extLineBidder((Deal)deal);
        if (!DealsService.isTextual((JsonNode)extLineBidder)) {
            return deal;
        }
        ObjectNode updatedExt = deal.getExt().deepCopy();
        ObjectNode updatedExtLine = (ObjectNode)updatedExt.get("line");
        updatedExtLine.remove("bidder");
        if (updatedExtLine.isEmpty()) {
            updatedExt.remove("line");
        }
        return deal.toBuilder().ext((ObjectNode)(!updatedExt.isEmpty() ? updatedExt : null)).build();
    }

    public static BidRequest populateDeals(BidRequest bidRequest, Map<String, List<Deal>> impIdToDeals) {
        return DealsService.populateDeals((BidRequest)bidRequest, impIdToDeals, ListUtils::union);
    }

    private static BidRequest populateDeals(BidRequest bidRequest, Map<String, List<Deal>> impIdToDeals, BiFunction<List<Deal>, List<Deal>, List<Deal>> dealsCombiner) {
        List originalImps = bidRequest.getImp();
        List<Imp> updatedImp = originalImps.stream().map(imp -> DealsService.populateDeals((Imp)imp, (List)((List)impIdToDeals.get(imp.getId())), (BiFunction)dealsCombiner)).toList();
        if (updatedImp.stream().allMatch(Objects::isNull)) {
            return bidRequest;
        }
        return bidRequest.toBuilder().imp(IntStream.range(0, originalImps.size()).mapToObj(i -> (Imp)ObjectUtils.defaultIfNull((Object)((Imp)updatedImp.get(i)), (Object)((Imp)originalImps.get(i)))).toList()).build();
    }

    private static Imp populateDeals(Imp imp, List<Deal> matchedDeals, BiFunction<List<Deal>, List<Deal>, List<Deal>> dealsCombiner) {
        Pmp pmp = imp.getPmp();
        List originalDeal = pmp != null ? pmp.getDeals() : null;
        List<Deal> combinedDeals = dealsCombiner.apply(ListUtils.emptyIfNull((List)originalDeal), ListUtils.emptyIfNull(matchedDeals));
        if (CollectionUtils.isEmpty(combinedDeals)) {
            return null;
        }
        Pmp.PmpBuilder pmpBuilder = pmp != null ? pmp.toBuilder() : Pmp.builder();
        return imp.toBuilder().pmp(pmpBuilder.deals(combinedDeals).build()).build();
    }

    public static List<AuctionParticipation> removePgDealsOnlyImpsWithoutDeals(List<AuctionParticipation> auctionParticipations, AuctionContext context) {
        return auctionParticipations.stream().map(auctionParticipation -> DealsService.removePgDealsOnlyImpsWithoutDeals((AuctionParticipation)auctionParticipation, (AuctionContext)context)).filter(Objects::nonNull).toList();
    }

    private static AuctionParticipation removePgDealsOnlyImpsWithoutDeals(AuctionParticipation auctionParticipation, AuctionContext context) {
        BidderRequest bidderRequest = auctionParticipation.getBidderRequest();
        String bidder = bidderRequest.getBidder();
        BidRequest bidRequest = bidderRequest.getBidRequest();
        List imps = bidRequest.getImp();
        Set impsIndicesToRemove = IntStream.range(0, imps.size()).filter(i -> DealsService.isPgDealsOnly((Imp)((Imp)imps.get(i)))).filter(i -> !DealsService.havePgDeal((Imp)((Imp)imps.get(i)), (Map)bidderRequest.getImpIdToDeals())).boxed().collect(Collectors.toSet());
        if (impsIndicesToRemove.isEmpty()) {
            return auctionParticipation;
        }
        if (impsIndicesToRemove.size() == imps.size()) {
            DealsService.logImpsExclusion((AuctionContext)context, (String)bidder, (List)imps);
            return null;
        }
        ArrayList<Imp> impsToRemove = new ArrayList<Imp>();
        ArrayList<Imp> filteredImps = new ArrayList<Imp>();
        for (int i2 = 0; i2 < imps.size(); ++i2) {
            Imp imp = (Imp)imps.get(i2);
            if (impsIndicesToRemove.contains(i2)) {
                impsToRemove.add(imp);
                continue;
            }
            filteredImps.add(imp);
        }
        DealsService.logImpsExclusion((AuctionContext)context, (String)bidder, impsToRemove);
        return auctionParticipation.toBuilder().bidderRequest(bidderRequest.toBuilder().bidRequest(bidRequest.toBuilder().imp(filteredImps).build()).build()).build();
    }

    private static boolean isPgDealsOnly(Imp imp) {
        JsonNode extBidder = imp.getExt().get("bidder");
        if (extBidder == null || !extBidder.isObject()) {
            return false;
        }
        JsonNode pgDealsOnlyNode = extBidder.path("pgdealsonly");
        return pgDealsOnlyNode.isBoolean() && pgDealsOnlyNode.asBoolean();
    }

    private static boolean havePgDeal(Imp imp, Map<String, List<Deal>> impIdToDeals) {
        return impIdToDeals != null && CollectionUtils.isNotEmpty((Collection)impIdToDeals.get(imp.getId()));
    }

    private static void logImpsExclusion(AuctionContext context, String bidder, List<Imp> imps) {
        String impsIds = imps.stream().map(Imp::getId).collect(Collectors.joining(", "));
        context.getDebugWarnings().add("Not calling %s bidder for impressions %s due to %s flag and no available PG line items.".formatted(bidder, impsIds, "pgdealsonly"));
    }
}

