/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.List;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.bidder.UsersyncMethodChooser;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.model.BiddersContext;
import org.prebid.server.cookie.model.CookieSyncContext;
import org.prebid.server.execution.Timeout;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.proto.request.CookieSyncRequest;
import org.prebid.server.settings.model.Account;

public final class CookieSyncContext {
    @JsonIgnore
    private final RoutingContext routingContext;
    @JsonIgnore
    private final UidsCookie uidsCookie;
    private final CookieSyncRequest cookieSyncRequest;
    @JsonIgnore
    private final BiddersContext biddersContext;
    @JsonIgnore
    private final UsersyncMethodChooser usersyncMethodChooser;
    @JsonIgnore
    private final Timeout timeout;
    private final Account account;
    @JsonIgnore
    private final GppContext gppContext;
    private final PrivacyContext privacyContext;
    @JsonIgnore
    private final ActivityInfrastructure activityInfrastructure;
    @JsonIgnore
    private final int limit;
    @JsonIgnore
    private final boolean debug;
    @JsonIgnore
    private final List<String> warnings;

    public CookieSyncContext with(CookieSyncRequest cookieSyncRequest) {
        return this.toBuilder().cookieSyncRequest(cookieSyncRequest).build();
    }

    public CookieSyncContext with(BiddersContext biddersContext) {
        return this.toBuilder().biddersContext(biddersContext).build();
    }

    public CookieSyncContext with(Account account) {
        return this.toBuilder().account(account).build();
    }

    public CookieSyncContext with(PrivacyContext privacyContext) {
        return this.toBuilder().privacyContext(privacyContext).build();
    }

    public CookieSyncContext with(int limit) {
        return this.toBuilder().limit(limit).build();
    }

    @ConstructorProperties(value={"routingContext", "uidsCookie", "cookieSyncRequest", "biddersContext", "usersyncMethodChooser", "timeout", "account", "gppContext", "privacyContext", "activityInfrastructure", "limit", "debug", "warnings"})
    CookieSyncContext(RoutingContext routingContext, UidsCookie uidsCookie, CookieSyncRequest cookieSyncRequest, BiddersContext biddersContext, UsersyncMethodChooser usersyncMethodChooser, Timeout timeout, Account account, GppContext gppContext, PrivacyContext privacyContext, ActivityInfrastructure activityInfrastructure, int limit, boolean debug, List<String> warnings) {
        this.routingContext = routingContext;
        this.uidsCookie = uidsCookie;
        this.cookieSyncRequest = cookieSyncRequest;
        this.biddersContext = biddersContext;
        this.usersyncMethodChooser = usersyncMethodChooser;
        this.timeout = timeout;
        this.account = account;
        this.gppContext = gppContext;
        this.privacyContext = privacyContext;
        this.activityInfrastructure = activityInfrastructure;
        this.limit = limit;
        this.debug = debug;
        this.warnings = warnings;
    }

    public static CookieSyncContextBuilder builder() {
        return new CookieSyncContextBuilder();
    }

    public CookieSyncContextBuilder toBuilder() {
        return new CookieSyncContextBuilder().routingContext(this.routingContext).uidsCookie(this.uidsCookie).cookieSyncRequest(this.cookieSyncRequest).biddersContext(this.biddersContext).usersyncMethodChooser(this.usersyncMethodChooser).timeout(this.timeout).account(this.account).gppContext(this.gppContext).privacyContext(this.privacyContext).activityInfrastructure(this.activityInfrastructure).limit(this.limit).debug(this.debug).warnings(this.warnings);
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public UidsCookie getUidsCookie() {
        return this.uidsCookie;
    }

    public CookieSyncRequest getCookieSyncRequest() {
        return this.cookieSyncRequest;
    }

    public BiddersContext getBiddersContext() {
        return this.biddersContext;
    }

    public UsersyncMethodChooser getUsersyncMethodChooser() {
        return this.usersyncMethodChooser;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public Account getAccount() {
        return this.account;
    }

    public GppContext getGppContext() {
        return this.gppContext;
    }

    public PrivacyContext getPrivacyContext() {
        return this.privacyContext;
    }

    public ActivityInfrastructure getActivityInfrastructure() {
        return this.activityInfrastructure;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CookieSyncContext)) {
            return false;
        }
        CookieSyncContext other = (CookieSyncContext)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        RoutingContext this$routingContext = this.getRoutingContext();
        RoutingContext other$routingContext = other.getRoutingContext();
        if (this$routingContext == null ? other$routingContext != null : !this$routingContext.equals(other$routingContext)) {
            return false;
        }
        UidsCookie this$uidsCookie = this.getUidsCookie();
        UidsCookie other$uidsCookie = other.getUidsCookie();
        if (this$uidsCookie == null ? other$uidsCookie != null : !this$uidsCookie.equals(other$uidsCookie)) {
            return false;
        }
        CookieSyncRequest this$cookieSyncRequest = this.getCookieSyncRequest();
        CookieSyncRequest other$cookieSyncRequest = other.getCookieSyncRequest();
        if (this$cookieSyncRequest == null ? other$cookieSyncRequest != null : !this$cookieSyncRequest.equals(other$cookieSyncRequest)) {
            return false;
        }
        BiddersContext this$biddersContext = this.getBiddersContext();
        BiddersContext other$biddersContext = other.getBiddersContext();
        if (this$biddersContext == null ? other$biddersContext != null : !this$biddersContext.equals(other$biddersContext)) {
            return false;
        }
        UsersyncMethodChooser this$usersyncMethodChooser = this.getUsersyncMethodChooser();
        UsersyncMethodChooser other$usersyncMethodChooser = other.getUsersyncMethodChooser();
        if (this$usersyncMethodChooser == null ? other$usersyncMethodChooser != null : !this$usersyncMethodChooser.equals(other$usersyncMethodChooser)) {
            return false;
        }
        Timeout this$timeout = this.getTimeout();
        Timeout other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !this$timeout.equals(other$timeout)) {
            return false;
        }
        Account this$account = this.getAccount();
        Account other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        GppContext this$gppContext = this.getGppContext();
        GppContext other$gppContext = other.getGppContext();
        if (this$gppContext == null ? other$gppContext != null : !this$gppContext.equals(other$gppContext)) {
            return false;
        }
        PrivacyContext this$privacyContext = this.getPrivacyContext();
        PrivacyContext other$privacyContext = other.getPrivacyContext();
        if (this$privacyContext == null ? other$privacyContext != null : !this$privacyContext.equals(other$privacyContext)) {
            return false;
        }
        ActivityInfrastructure this$activityInfrastructure = this.getActivityInfrastructure();
        ActivityInfrastructure other$activityInfrastructure = other.getActivityInfrastructure();
        if (this$activityInfrastructure == null ? other$activityInfrastructure != null : !this$activityInfrastructure.equals(other$activityInfrastructure)) {
            return false;
        }
        List this$warnings = this.getWarnings();
        List other$warnings = other.getWarnings();
        return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        result = result * 59 + (this.isDebug() ? 79 : 97);
        RoutingContext $routingContext = this.getRoutingContext();
        result = result * 59 + ($routingContext == null ? 43 : $routingContext.hashCode());
        UidsCookie $uidsCookie = this.getUidsCookie();
        result = result * 59 + ($uidsCookie == null ? 43 : $uidsCookie.hashCode());
        CookieSyncRequest $cookieSyncRequest = this.getCookieSyncRequest();
        result = result * 59 + ($cookieSyncRequest == null ? 43 : $cookieSyncRequest.hashCode());
        BiddersContext $biddersContext = this.getBiddersContext();
        result = result * 59 + ($biddersContext == null ? 43 : $biddersContext.hashCode());
        UsersyncMethodChooser $usersyncMethodChooser = this.getUsersyncMethodChooser();
        result = result * 59 + ($usersyncMethodChooser == null ? 43 : $usersyncMethodChooser.hashCode());
        Timeout $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : $timeout.hashCode());
        Account $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        GppContext $gppContext = this.getGppContext();
        result = result * 59 + ($gppContext == null ? 43 : $gppContext.hashCode());
        PrivacyContext $privacyContext = this.getPrivacyContext();
        result = result * 59 + ($privacyContext == null ? 43 : $privacyContext.hashCode());
        ActivityInfrastructure $activityInfrastructure = this.getActivityInfrastructure();
        result = result * 59 + ($activityInfrastructure == null ? 43 : $activityInfrastructure.hashCode());
        List $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        return result;
    }

    public String toString() {
        return "CookieSyncContext(routingContext=" + this.getRoutingContext() + ", uidsCookie=" + this.getUidsCookie() + ", cookieSyncRequest=" + this.getCookieSyncRequest() + ", biddersContext=" + this.getBiddersContext() + ", usersyncMethodChooser=" + this.getUsersyncMethodChooser() + ", timeout=" + this.getTimeout() + ", account=" + this.getAccount() + ", gppContext=" + this.getGppContext() + ", privacyContext=" + this.getPrivacyContext() + ", activityInfrastructure=" + this.getActivityInfrastructure() + ", limit=" + this.getLimit() + ", debug=" + this.isDebug() + ", warnings=" + this.getWarnings() + ")";
    }
}

