/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.zeroclickfraud;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.zeroclickfraud.ExtImpZeroclickfraud;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZeroclickfraudBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpZeroclickfraud>> ZEROCLICKFRAUD_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String HOST = "{{Host}}";
    private static final String SOURCE_ID = "{{SourceId}}";
    private final String endpointTemplate;
    private final JacksonMapper mapper;

    public ZeroclickfraudBidder(String endpointTemplate, JacksonMapper mapper) {
        this.endpointTemplate = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointTemplate));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        HashMap<ExtImpZeroclickfraud, List> extToImps = new HashMap<ExtImpZeroclickfraud, List>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpZeroclickfraud extImpZeroclickfraud = this.parseAndValidateImpExt(imp.getExt());
                extToImps.computeIfAbsent(extImpZeroclickfraud, ext -> new ArrayList()).add(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
        }
        List<HttpRequest> httpRequests = extToImps.entrySet().stream().map(entry -> this.makeHttpRequest((ExtImpZeroclickfraud)entry.getKey(), (List)entry.getValue(), bidRequest)).toList();
        return Result.of(httpRequests, Collections.emptyList());
    }

    private ExtImpZeroclickfraud parseAndValidateImpExt(ObjectNode extNode) {
        ExtImpZeroclickfraud extImpZeroclickfraud;
        try {
            extImpZeroclickfraud = (ExtImpZeroclickfraud)((ExtPrebid)this.mapper.mapper().convertValue((Object)extNode, ZEROCLICKFRAUD_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        Integer sourceId = extImpZeroclickfraud.getSourceId();
        if (sourceId == null || sourceId < 1) {
            throw new PreBidException("Invalid/Missing SourceId");
        }
        if (StringUtils.isBlank((CharSequence)extImpZeroclickfraud.getHost())) {
            throw new PreBidException("Invalid/Missing Host");
        }
        return extImpZeroclickfraud;
    }

    private HttpRequest<BidRequest> makeHttpRequest(ExtImpZeroclickfraud extImpZeroclickfraud, List<Imp> imps, BidRequest bidRequest) {
        String uri = this.endpointTemplate.replace("{{Host}}", extImpZeroclickfraud.getHost()).replace("{{SourceId}}", extImpZeroclickfraud.getSourceId().toString());
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(imps).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)uri, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)ZeroclickfraudBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())), Collections.emptyList());
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : ZeroclickfraudBidder.bidsFromResponse((BidResponse)bidResponse, (List)bidRequest.getImp());
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<Imp> imps) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)ZeroclickfraudBidder.getBidType((String)bid.getImpid(), (List)imps), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            return BidType.banner;
        }
        return BidType.banner;
    }
}

