/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.yandex;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.yandex.ExtImpYandex;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class YandexBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpYandex>> YANDEX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String PAGE_ID_MACRO = "{{PageId}}";
    private static final String IMP_ID_MACRO = "{{ImpId}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public YandexBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> bidRequests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        String referer = YandexBidder.getReferer((BidRequest)request);
        String currency = YandexBidder.getCurrency((BidRequest)request);
        for (Imp imp : request.getImp()) {
            try {
                ExtImpYandex extImpYandex = this.parseAndValidateImpExt(imp.getExt(), imp.getId());
                Imp modifiedImp = YandexBidder.modifyImp((Imp)imp);
                String modifiedUrl = this.modifyUrl(extImpYandex, referer, currency);
                BidRequest modifiedRequest = request.toBuilder().imp(Collections.singletonList(modifiedImp)).build();
                bidRequests.add(this.buildHttpRequest(modifiedRequest, modifiedUrl));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(bidRequests, errors);
    }

    private static String getReferer(BidRequest request) {
        return Optional.ofNullable(request.getSite()).map(Site::getPage).orElse(null);
    }

    private static String getCurrency(BidRequest request) {
        List currencies = request.getCur();
        String currency = CollectionUtils.isNotEmpty((Collection)currencies) ? (String)currencies.get(0) : null;
        return StringUtils.defaultString((String)currency);
    }

    private ExtImpYandex parseAndValidateImpExt(ObjectNode impExtNode, String impId) {
        ExtImpYandex extImpYandex;
        try {
            extImpYandex = (ExtImpYandex)((ExtPrebid)this.mapper.mapper().convertValue((Object)impExtNode, YANDEX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("imp #%s: %s".formatted(impId, e.getMessage()));
        }
        Integer pageId = extImpYandex.getPageId();
        if (pageId == 0) {
            throw new PreBidException("imp #%s: wrong value for page_id param".formatted(impId));
        }
        Integer yandexImpId = extImpYandex.getImpId();
        if (yandexImpId == 0) {
            throw new PreBidException("imp #%s: wrong value for imp_id param".formatted(impId));
        }
        return extImpYandex;
    }

    private static Imp modifyImp(Imp imp) {
        if (imp.getBanner() != null) {
            return imp.toBuilder().banner(YandexBidder.modifyBanner((Banner)imp.getBanner())).build();
        }
        if (imp.getXNative() != null) {
            return imp;
        }
        throw new PreBidException("Yandex only supports banner and native types. Ignoring imp id #%s".formatted(imp.getId()));
    }

    private static Banner modifyBanner(Banner banner) {
        Integer weight = banner.getW();
        Integer height = banner.getH();
        List format = banner.getFormat();
        if (weight == null || height == null || weight == 0 || height == 0) {
            if (CollectionUtils.isNotEmpty((Collection)format)) {
                Format firstFormat = (Format)format.get(0);
                return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
            }
            throw new PreBidException("Invalid sizes provided for Banner %sx%s".formatted(weight, height));
        }
        return banner;
    }

    private String modifyUrl(ExtImpYandex extImpYandex, String referer, String currency) {
        URIBuilder uriBuilder;
        String resolvedUrl = this.endpointUrl.replace("{{PageId}}", HttpUtil.encodeUrl((String)extImpYandex.getPageId().toString())).replace("{{ImpId}}", HttpUtil.encodeUrl((String)extImpYandex.getImpId().toString()));
        try {
            uriBuilder = new URIBuilder(resolvedUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(this.endpointUrl, e.getMessage()));
        }
        YandexBidder.addParameterIfNotBlank((URIBuilder)uriBuilder, (String)"target-ref", (String)referer);
        YandexBidder.addParameterIfNotBlank((URIBuilder)uriBuilder, (String)"ssp-cur", (String)currency);
        return uriBuilder.toString();
    }

    private static void addParameterIfNotBlank(URIBuilder uriBuilder, String parameter, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            uriBuilder.addParameter(parameter, value);
        }
    }

    private HttpRequest<BidRequest> buildHttpRequest(BidRequest outgoingRequest, String url) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(YandexBidder.headers((BidRequest)outgoingRequest)).body(this.mapper.encodeToBytes((Object)outgoingRequest)).payload((Object)outgoingRequest).build();
    }

    private static MultiMap headers(BidRequest bidRequest) {
        MultiMap headers = HttpUtil.headers();
        Device device = bidRequest.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_REAL_IP_HEADER, (CharSequence)device.getIp());
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)YandexBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return YandexBidder.bidsFromResponse((BidResponse)bidResponse, (List)bidRequest.getImp());
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<Imp> imps) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)YandexBidder.getBidType((String)bid.getImpid(), (List)imps), (String)bidResponse.getCur())).collect(Collectors.toList());
    }

    private static BidType getBidType(String bidImpId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!bidImpId.equals(imp.getId())) continue;
            return YandexBidder.resolveImpType((Imp)imp);
        }
        throw new PreBidException("Invalid bid imp ID #%s does not match any imp IDs from the original bid request".formatted(bidImpId));
    }

    private static BidType resolveImpType(Imp imp) {
        if (imp.getXNative() != null) {
            return BidType.xNative;
        }
        if (imp.getBanner() != null) {
            return BidType.banner;
        }
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        if (imp.getAudio() != null) {
            return BidType.audio;
        }
        throw new PreBidException("Processing an invalid impression; cannot resolve impression type for imp #%s".formatted(imp.getId()));
    }
}

