/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.ucfunnel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ucfunnel.ExtImpUcfunnel;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class UcfunnelBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpUcfunnel>> UCFUNNEL_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public UcfunnelBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        if (CollectionUtils.isEmpty((Collection)request.getImp())) {
            return Result.withError((BidderError)BidderError.badInput((String)"No valid impressions in the bid request"));
        }
        String partnerId = null;
        try {
            ExtImpUcfunnel extImpUcfunnel = this.parseImpExt((Imp)request.getImp().get(0));
            String adUnitId = extImpUcfunnel.getAdunitid();
            partnerId = extImpUcfunnel.getPartnerid();
            if (StringUtils.isEmpty((CharSequence)partnerId) || StringUtils.isEmpty((CharSequence)adUnitId)) {
                errors.add(BidderError.badInput((String)"No PartnerId or AdUnitId in the bid request"));
                return Result.withErrors(errors);
            }
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
        }
        String requestUrl = "%s/%s/request".formatted(this.endpointUrl, HttpUtil.encodeUrl((String)partnerId));
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)request, (String)requestUrl, (JacksonMapper)this.mapper)), errors);
    }

    private ExtImpUcfunnel parseImpExt(Imp imp) {
        try {
            return (ExtImpUcfunnel)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), UCFUNNEL_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.decodeBodyToBidResponse(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        for (SeatBid seatBid : bidResponse.getSeatbid()) {
            for (Bid bid : seatBid.getBid()) {
                BidType bidType = UcfunnelBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp());
                if (bidType != BidType.banner && bidType != BidType.video) continue;
                BidderBid bidderBid = BidderBid.of((Bid)bid, (BidType)bidType, (String)bidResponse.getCur());
                bidderBids.add(bidderBid);
            }
        }
        return Result.withValues(bidderBids);
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getAudio() == null) continue;
            return BidType.audio;
        }
        return BidType.xNative;
    }
}

