/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.teads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.teads.TeadsImpExtKV;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.teads.TeadsImpExt;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidMeta;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TeadsBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, TeadsImpExt>> TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final TypeReference<ExtPrebid<ExtBidPrebid, ObjectNode>> EXT_PREBID_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public TeadsBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        try {
            List modifiedImps = request.getImp().stream().map(arg_0 -> this.modifyImp(arg_0)).collect(Collectors.toList());
            HttpRequest httpRequest = this.makeHttpRequest(request.toBuilder().imp(modifiedImps).build());
            return Result.withValue((Object)httpRequest);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
    }

    private Imp modifyImp(Imp imp) {
        TeadsImpExt impExt = this.parseImpExt(imp);
        if (Objects.equals(impExt.getPlacementId(), 0)) {
            throw new PreBidException("placementId should not be 0");
        }
        ObjectNode modifiedImpExt = (ObjectNode)this.mapper.mapper().convertValue((Object)TeadsImpExtKV.of((TeadsImpExt)impExt), ObjectNode.class);
        return imp.toBuilder().tagid(String.valueOf(impExt.getPlacementId())).banner(TeadsBidder.modifyBanner((Banner)imp.getBanner())).ext(modifiedImpExt).build();
    }

    private static Banner modifyBanner(Banner banner) {
        List format;
        if (banner != null && CollectionUtils.isNotEmpty((Collection)(format = banner.getFormat()))) {
            Format firstFormat = (Format)format.get(0);
            return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
        }
        return banner;
    }

    private TeadsImpExt parseImpExt(Imp imp) {
        try {
            return (TeadsImpExt)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(HttpUtil.headers()).impIds(BidderUtil.impIds((BidRequest)bidRequest)).body(this.mapper.encodeToBytes((Object)bidRequest)).payload((Object)bidRequest).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)"Bad Server Response"));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        Map impMap = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        return bidResponse.getSeatbid().stream().flatMap(seatBid -> Optional.ofNullable(seatBid.getBid()).orElse(List.of()).stream()).map(bid -> this.makeBid(impMap, bid, bidResponse.getCur())).toList();
    }

    private BidderBid makeBid(Map<String, Imp> impMap, Bid bid, String currency) {
        BidType bidType = Optional.ofNullable(impMap.get(bid.getImpid())).map(imp -> imp.getVideo() == null ? BidType.banner : BidType.video).orElseThrow(() -> new PreBidException("Bid for the Imp " + bid.getImpid() + " wasn't found"));
        ExtBidPrebid prebid = this.parseExtBidPrebidMeta(bid);
        ExtBidPrebidMeta meta = prebid.getMeta();
        if (StringUtils.isBlank((CharSequence)meta.getRendererName())) {
            throw new PreBidException("RendererName should not be empty");
        }
        if (StringUtils.isBlank((CharSequence)meta.getRendererVersion())) {
            throw new PreBidException("RendererVersion should not be empty");
        }
        ExtBidPrebidMeta modifiedMeta = ExtBidPrebidMeta.builder().rendererName(meta.getRendererName()).rendererVersion(meta.getRendererVersion()).build();
        ExtBidPrebid modifiedPrebid = prebid.toBuilder().meta(modifiedMeta).build();
        ObjectNode modifiedBidExt = (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtPrebid.of((Object)modifiedPrebid, null));
        return BidderBid.of((Bid)bid.toBuilder().ext(modifiedBidExt).build(), (BidType)bidType, (String)currency);
    }

    private ExtBidPrebid parseExtBidPrebidMeta(Bid bid) {
        try {
            return (ExtBidPrebid)((ExtPrebid)this.mapper.mapper().convertValue((Object)bid.getExt(), EXT_PREBID_TYPE_REFERENCE)).getPrebid();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }
}

