/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.smilewanted;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmileWantedBidder
implements Bidder<BidRequest> {
    private static final String SW_INTEGRATION_TYPE = "prebid_server";
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final int DEFAULT_AT = 1;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public SmileWantedBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        BidRequest outgoingRequest = request.toBuilder().at(Integer.valueOf(1)).build();
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(SmileWantedBidder.createHeaders()).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build());
    }

    private static MultiMap createHeaders() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5").add("sw-integration-type", "prebid_server");
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)SmileWantedBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse), Collections.emptyList());
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return SmileWantedBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        SeatBid firstSeatBid = (SeatBid)bidResponse.getSeatbid().get(0);
        return CollectionUtils.emptyIfNull((Collection)firstSeatBid.getBid()).stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)SmileWantedBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impid, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impid) || imp.getVideo() == null) continue;
            return BidType.video;
        }
        return BidType.banner;
    }
}

