/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.smartx;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmartxBidder
implements Bidder<BidRequest> {
    private static final String X_OPENRTB_VERSION = "2.5";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public SmartxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)bidRequest, (MultiMap)SmartxBidder.resolveHeaders((BidRequest)bidRequest), (String)this.endpointUrl, (JacksonMapper)this.mapper));
    }

    private static MultiMap resolveHeaders(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getUa)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIpv6)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIp)));
        return headers;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)SmartxBidder.extractBids((BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null) {
            throw new PreBidException("Bad Server Response");
        }
        if (CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        return SmartxBidder.bidsFromResponse((BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.video, (String)bidResponse.getCur())).toList();
    }
}

