/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.sharethrough;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.sharethrough.ExtImpSharethrough;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.version.PrebidVersionProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class SharethroughBidder
implements Bidder<BidRequest> {
    private static final String ADAPTER_VERSION = "10.0";
    private static final String BID_CURRENCY = "USD";
    private static final JsonPointer BID_TYPE_POINTER = JsonPointer.valueOf((String)"/prebid/type");
    private static final TypeReference<ExtPrebid<?, ExtImpSharethrough>> SHARETHROUGH_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final CurrencyConversionService currencyConversionService;
    private final PrebidVersionProvider prebidVersionProvider;
    private final JacksonMapper mapper;

    public SharethroughBidder(String endpointUrl, CurrencyConversionService currencyConversionService, PrebidVersionProvider prebidVersionProvider, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.prebidVersionProvider = Objects.requireNonNull(prebidVersionProvider);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Imp originalImpression : request.getImp()) {
            List impressionsByMediaType = this.splitImpressionsByMediaType(originalImpression, errors);
            for (Imp impression : impressionsByMediaType) {
                Price bidFloorPrice;
                ExtImpSharethrough extImpSharethrough;
                try {
                    extImpSharethrough = this.parseImpExt(impression);
                    bidFloorPrice = this.resolveBidFloor(impression, request);
                }
                catch (PreBidException e) {
                    errors.add(BidderError.badInput((String)e.getMessage()));
                    continue;
                }
                Imp modifiedImp = SharethroughBidder.modifyImp((Imp)impression, (String)extImpSharethrough.getPkey(), (Price)bidFloorPrice);
                BidRequest modifiedBidRequest = this.modifyRequest(request, modifiedImp, extImpSharethrough);
                httpRequests.add(this.makeHttpRequest(modifiedBidRequest));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private List<Imp> splitImpressionsByMediaType(Imp impression, List<BidderError> errors) {
        ArrayList<Imp> splitImpressions = new ArrayList<Imp>();
        Banner banner = impression.getBanner();
        Video video = impression.getVideo();
        Native xNative = impression.getXNative();
        if (ObjectUtils.allNull((Object[])new Object[]{video, banner, xNative})) {
            errors.add(BidderError.badInput((String)"Invalid MediaType. Sharethrough only supports Banner, Video and Native."));
            return Collections.emptyList();
        }
        if (video != null) {
            splitImpressions.add(impression.toBuilder().banner(null).xNative(null).audio(null).build());
        }
        if (banner != null) {
            splitImpressions.add(impression.toBuilder().video(null).xNative(null).audio(null).build());
        }
        if (xNative != null) {
            splitImpressions.add(impression.toBuilder().banner(null).video(null).audio(null).build());
        }
        return splitImpressions;
    }

    private ExtImpSharethrough parseImpExt(Imp imp) {
        try {
            return (ExtImpSharethrough)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), SHARETHROUGH_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Price resolveBidFloor(Imp imp, BidRequest bidRequest) {
        Price initialBidFloorPrice = Price.of((String)imp.getBidfloorcur(), (BigDecimal)imp.getBidfloor());
        return BidderUtil.isValidPrice((Price)initialBidFloorPrice) ? this.convertBidFloor(initialBidFloorPrice, bidRequest) : initialBidFloorPrice;
    }

    private Price convertBidFloor(Price bidFloorPrice, BidRequest bidRequest) {
        BigDecimal convertedPrice = this.currencyConversionService.convertCurrency(bidFloorPrice.getValue(), bidRequest, bidFloorPrice.getCurrency(), "USD");
        return Price.of((String)"USD", (BigDecimal)convertedPrice);
    }

    private static Imp modifyImp(Imp imp, String tagId, Price bidFloorPrice) {
        return imp.toBuilder().tagid(tagId).bidfloor(bidFloorPrice.getValue()).bidfloorcur(bidFloorPrice.getCurrency()).build();
    }

    private BidRequest modifyRequest(BidRequest bidRequest, Imp imp, ExtImpSharethrough extImpSharethrough) {
        return bidRequest.toBuilder().imp(Collections.singletonList(imp)).bcat(SharethroughBidder.union((List)bidRequest.getBcat(), (List)extImpSharethrough.getBcat())).badv(SharethroughBidder.union((List)bidRequest.getBadv(), (List)extImpSharethrough.getBadv())).source(this.modifySource(bidRequest.getSource())).build();
    }

    private static List<String> union(List<String> first, List<String> second) {
        if (CollectionUtils.isEmpty(first)) {
            return second;
        }
        if (CollectionUtils.isEmpty(second)) {
            return first;
        }
        return ListUtils.union(first, second);
    }

    private Source modifySource(Source source) {
        return source != null ? source.toBuilder().ext((ExtSource)ObjectUtil.getIfNotNullOrDefault((Object)source.getExt(), arg_0 -> this.modifyExtSource(arg_0), () -> this.createExtSource())).build() : Source.builder().ext(this.createExtSource()).build();
    }

    private ExtSource modifyExtSource(ExtSource ext) {
        ExtSource copy = ExtSource.of((SupplyChain)ext.getSchain());
        copy.addProperties(ext.getProperties());
        copy.addProperty("str", (JsonNode)TextNode.valueOf((String)"10.0"));
        copy.addProperty("version", (JsonNode)TextNode.valueOf((String)this.prebidVersionProvider.getNameVersionRecord()));
        return copy;
    }

    private ExtSource createExtSource() {
        ExtSource extSource = ExtSource.of(null);
        extSource.addProperty("str", (JsonNode)TextNode.valueOf((String)"10.0"));
        extSource.addProperty("version", (JsonNode)TextNode.valueOf((String)this.prebidVersionProvider.getNameVersionRecord()));
        return extSource;
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request) {
        return BidderUtil.defaultRequest((BidRequest)request, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList errors = new ArrayList();
        return Result.of((Object)this.extractBids(bidResponse, errors), errors);
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.constructBidderBid(bid, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid constructBidderBid(Bid bid, List<BidderError> errors) {
        JsonNode bidTypeNode;
        ObjectNode extNode = bid.getExt();
        JsonNode jsonNode = bidTypeNode = extNode != null ? extNode.at(BID_TYPE_POINTER) : null;
        if (bidTypeNode == null || !bidTypeNode.isTextual()) {
            errors.add(BidderError.badServerResponse((String)("Failed to parse bid media type for impression " + bid.getImpid())));
            return null;
        }
        BidType bidType = this.parseBidType(bidTypeNode, errors);
        return bidType != null ? BidderBid.of((Bid)bid, (BidType)bidType, (String)"USD") : null;
    }

    private BidType parseBidType(JsonNode bidTypeNode, List<BidderError> errors) {
        try {
            return (BidType)this.mapper.mapper().convertValue((Object)bidTypeNode, BidType.class);
        }
        catch (IllegalArgumentException ignore) {
            errors.add(BidderError.badServerResponse((String)("invalid BidType: " + bidTypeNode.asText())));
            return null;
        }
    }
}

