/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.salunamedia;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class SaLunamediaBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public SaLunamediaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)request, (String)this.endpointUrl, (JacksonMapper)this.mapper));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)this.extractBids(bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        ObjectNode firstBidExt;
        List bids;
        List seatBids;
        List list = seatBids = bidResponse != null ? bidResponse.getSeatbid() : null;
        if (CollectionUtils.isEmpty((Collection)seatBids)) {
            throw new PreBidException("Empty SeatBid");
        }
        SeatBid firstSeatBid = (SeatBid)seatBids.get(0);
        List list2 = bids = firstSeatBid != null ? firstSeatBid.getBid() : null;
        if (CollectionUtils.isEmpty((Collection)bids)) {
            throw new PreBidException("Empty SeatBid.Bids");
        }
        Bid firstBid = (Bid)bids.get(0);
        ObjectNode objectNode = firstBidExt = firstBid != null ? firstBid.getExt() : null;
        if (firstBidExt == null) {
            throw new PreBidException("Missing BidExt");
        }
        return Collections.singletonList(BidderBid.of((Bid)firstBid, (BidType)this.getBidType(firstBidExt), (String)bidResponse.getCur()));
    }

    private BidType getBidType(ObjectNode bidExt) {
        try {
            return (BidType)this.mapper.mapper().convertValue((Object)bidExt.get("mediaType"), BidType.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }
}

