/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.rubicon;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Content;
import com.iab.openrtb.request.Data;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Eid;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Metric;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Segment;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.Uid;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.ViewabilityVendors;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.PriceFloorInfo;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.rubicon.RubiconBidder;
import org.prebid.server.bidder.rubicon.proto.request.RubiconAppExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconBannerExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconBannerExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconDeviceExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconDeviceExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconExtPrebidBidders;
import org.prebid.server.bidder.rubicon.proto.request.RubiconExtPrebidBiddersBidder;
import org.prebid.server.bidder.rubicon.proto.request.RubiconExtPrebidBiddersBidderDebug;
import org.prebid.server.bidder.rubicon.proto.request.RubiconImpExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconImpExtPrebid;
import org.prebid.server.bidder.rubicon.proto.request.RubiconImpExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconImpExtRpRtb;
import org.prebid.server.bidder.rubicon.proto.request.RubiconImpExtRpTrack;
import org.prebid.server.bidder.rubicon.proto.request.RubiconNative;
import org.prebid.server.bidder.rubicon.proto.request.RubiconPubExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconPubExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconSiteExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconSiteExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconTargeting;
import org.prebid.server.bidder.rubicon.proto.request.RubiconTargetingExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconTargetingExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconUserExt;
import org.prebid.server.bidder.rubicon.proto.request.RubiconUserExtRp;
import org.prebid.server.bidder.rubicon.proto.request.RubiconVideoExt;
import org.prebid.server.bidder.rubicon.proto.response.RubiconBid;
import org.prebid.server.bidder.rubicon.proto.response.RubiconBidResponse;
import org.prebid.server.bidder.rubicon.proto.response.RubiconSeatBid;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.floors.PriceFloorResolver;
import org.prebid.server.floors.model.PriceFloorResult;
import org.prebid.server.floors.model.PriceFloorRules;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtDeal;
import org.prebid.server.proto.openrtb.ext.request.ExtDealLine;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtImpContextDataAdserver;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebidFloors;
import org.prebid.server.proto.openrtb.ext.request.ExtPublisher;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidMultiBid;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;
import org.prebid.server.proto.openrtb.ext.request.rubicon.ExtImpRubicon;
import org.prebid.server.proto.openrtb.ext.request.rubicon.ExtImpRubiconDebug;
import org.prebid.server.proto.openrtb.ext.request.rubicon.RubiconVideoParams;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidMeta;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RubiconBidder
implements Bidder<BidRequest> {
    private static final Logger logger = LoggerFactory.getLogger(RubiconBidder.class);
    private static final String TK_XINT_QUERY_PARAMETER = "tk_xint";
    private static final String PREBID_SERVER_USER_AGENT = "prebid-server/1.0";
    private static final String SOURCE_RUBICON = "rubiconproject.com";
    private static final String FPD_GPID_FIELD = "gpid";
    private static final String FPD_SKADN_FIELD = "skadn";
    private static final String FPD_DATA_FIELD = "data";
    private static final String FPD_DATA_PBADSLOT_FIELD = "pbadslot";
    private static final String FPD_ADSERVER_FIELD = "adserver";
    private static final String FPD_ADSERVER_NAME_GAM = "gam";
    private static final String FPD_KEYWORDS_FIELD = "keywords";
    private static final String DFP_ADUNIT_CODE_FIELD = "dfp_ad_unit_code";
    private static final String STYPE_FIELD = "stype";
    private static final String PREBID_EXT = "prebid";
    private static final String PPUID_STYPE = "ppuid";
    private static final String SHA256EMAIL_STYPE = "sha256email";
    private static final String DMP_STYPE = "dmp";
    private static final String XAPI_CURRENCY = "USD";
    private static final Set<Integer> USER_SEGTAXES = Set.of(Integer.valueOf(4));
    private static final Set<Integer> SITE_SEGTAXES = Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(6));
    private static final String SEGTAX_BLAH_ATTRIBUTE = "segtaxBLAH";
    private static final Set<String> STYPE_TO_REMOVE = new HashSet<String>(Arrays.asList("ppuid", "sha256email", "dmp"));
    private static final TypeReference<ExtPrebid<ExtImpPrebid, ExtImpRubicon>> RUBICON_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final TypeReference<ExtPrebid<ExtBidPrebid, ObjectNode>> EXT_PREBID_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final boolean DEFAULT_MULTIFORMAT_VALUE = false;
    private static final int SEGTAX_BLAH_MAX_SIZE = 100;
    private final String endpointUrl;
    private final Set<String> supportedVendors;
    private final boolean generateBidId;
    private final CurrencyConversionService currencyConversionService;
    private final PriceFloorResolver floorResolver;
    private final JacksonMapper mapper;
    private final MultiMap headers;

    public RubiconBidder(String endpoint, String xapiUsername, String xapiPassword, List<String> supportedVendors, boolean generateBidId, CurrencyConversionService currencyConversionService, PriceFloorResolver floorResolver, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpoint));
        this.supportedVendors = Set.copyOf((Collection)Objects.requireNonNull(supportedVendors));
        this.generateBidId = generateBidId;
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.floorResolver = Objects.requireNonNull(floorResolver);
        this.mapper = Objects.requireNonNull(mapper);
        this.headers = RubiconBidder.headers((String)Objects.requireNonNull(xapiUsername), (String)Objects.requireNonNull(xapiPassword));
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList httpRequests = new ArrayList();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List imps = this.extractValidImps(bidRequest, errors);
        if (CollectionUtils.isEmpty((Collection)imps)) {
            errors.add(BidderError.badInput((String)"There are no valid impressions to create bid request to rubicon bidder"));
            return Result.withErrors(errors);
        }
        Map impToImpExt = this.parseRubiconImpExts(imps, errors);
        String language = RubiconBidder.firstImpExtLanguage(impToImpExt.values());
        String uri = this.makeUri(bidRequest);
        for (Map.Entry impToExt : impToImpExt.entrySet()) {
            try {
                Imp imp = (Imp)impToExt.getKey();
                ExtImpRubicon impExt = (ExtImpRubicon)impToExt.getValue();
                List<BidRequest> impBidRequests = RubiconBidder.isMultiformatEnabled((ExtImpRubicon)impExt) ? this.createMultiFormatRequests(bidRequest, imp, impExt, language, errors) : List.of(this.createSingleRequest(bidRequest, imp, impExt, null, language, errors));
                httpRequests.addAll(this.createImpHttpRequests(imp, impBidRequests, uri));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private List<BidRequest> createMultiFormatRequests(BidRequest bidRequest, Imp imp, ExtImpRubicon impExt, String language, List<BidderError> errors) {
        Map impByType = this.splitByMediaType(imp);
        Set formats = impByType.keySet();
        if (formats.size() == 1) {
            return Collections.singletonList(this.createSingleRequest(bidRequest, imp, impExt, null, language, errors));
        }
        ArrayList<BidRequest> bidRequests = new ArrayList<BidRequest>();
        for (Imp singleFormatImp : impByType.values()) {
            try {
                bidRequests.add(this.createSingleRequest(bidRequest, singleFormatImp, impExt, formats, language, errors));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return bidRequests;
    }

    private Map<ImpMediaType, Imp> splitByMediaType(Imp imp) {
        HashMap<ImpMediaType, Imp> impByType = new HashMap<ImpMediaType, Imp>();
        if (imp.getBanner() != null) {
            impByType.put(ImpMediaType.banner, imp.toBuilder().video(null).xNative(null).audio(null).build());
        }
        if (imp.getVideo() != null) {
            impByType.put(ImpMediaType.video, imp.toBuilder().banner(null).xNative(null).audio(null).build());
        }
        if (imp.getXNative() != null) {
            impByType.put(ImpMediaType.xNative, imp.toBuilder().banner(null).video(null).audio(null).build());
        }
        if (imp.getAudio() != null) {
            impByType.put(ImpMediaType.audio, imp.toBuilder().banner(null).video(null).xNative(null).build());
        }
        return impByType;
    }

    private List<HttpRequest<BidRequest>> createImpHttpRequests(Imp imp, List<BidRequest> impBidRequests, String uri) {
        if (RubiconBidder.hasDeals((Imp)imp)) {
            return impBidRequests.stream().map(request -> this.createDealsRequests(request, uri)).flatMap(Collection::stream).toList();
        }
        return impBidRequests.stream().map(request -> this.createHttpRequest(request, uri)).toList();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList errors = new ArrayList();
            RubiconBidResponse bidResponse = (RubiconBidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), RubiconBidResponse.class);
            return Result.of((Object)this.extractBids(bidRequest, (BidRequest)httpCall.getRequest().getPayload(), bidResponse, errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    public Map<String, String> extractTargeting(ObjectNode extBidBidder) {
        RubiconTargetingExt rubiconTargetingExt;
        try {
            rubiconTargetingExt = (RubiconTargetingExt)this.mapper.mapper().convertValue((Object)extBidBidder, RubiconTargetingExt.class);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Error adding rubicon specific targeting to amp response", (Throwable)e);
            return Collections.emptyMap();
        }
        RubiconTargetingExtRp rp = rubiconTargetingExt.getRp();
        List targetings = rp != null ? rp.getTargeting() : null;
        return targetings != null ? targetings.stream().filter(targeting -> !CollectionUtils.isEmpty((Collection)targeting.getValues())).collect(Collectors.toMap(RubiconTargeting::getKey, targeting -> (String)targeting.getValues().get(0))) : Collections.emptyMap();
    }

    private List<Imp> extractValidImps(BidRequest bidRequest, List<BidderError> errors) {
        Map<Boolean, List<Imp>> isValidToImps = bidRequest.getImp().stream().collect(Collectors.groupingBy(RubiconBidder::isValidType));
        isValidToImps.getOrDefault(false, Collections.emptyList()).stream().map(arg_0 -> this.impTypeErrorMessage(arg_0)).forEach(errors::add);
        return isValidToImps.getOrDefault(true, Collections.emptyList());
    }

    private static boolean isValidType(Imp imp) {
        return ObjectUtils.anyNotNull((Object[])new Object[]{imp.getVideo(), imp.getBanner(), imp.getXNative()});
    }

    private BidderError impTypeErrorMessage(Imp imp) {
        BidType type = RubiconBidder.resolveExpectedBidType((Imp)imp);
        return BidderError.badInput((String)"Impression with id %s rejected with invalid type `%s`. Allowed types are [banner, video, native]".formatted(imp.getId(), type != null ? type.name() : "unknown"));
    }

    private static BidType resolveExpectedBidType(Imp imp) {
        if (imp.getBanner() != null) {
            return BidType.banner;
        }
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        if (imp.getAudio() != null) {
            return BidType.audio;
        }
        if (imp.getXNative() != null) {
            return BidType.xNative;
        }
        return null;
    }

    private static MultiMap headers(String xapiUsername, String xapiPassword) {
        return HttpUtil.headers().add(HttpUtil.AUTHORIZATION_HEADER, (CharSequence)RubiconBidder.authHeader((String)xapiUsername, (String)xapiPassword)).add(HttpUtil.USER_AGENT_HEADER, (CharSequence)"prebid-server/1.0");
    }

    private static String authHeader(String xapiUsername, String xapiPassword) {
        return "Basic " + Base64.getEncoder().encodeToString((xapiUsername + ":" + xapiPassword).getBytes());
    }

    private Map<Imp, ExtImpRubicon> parseRubiconImpExts(List<Imp> imps, List<BidderError> errors) {
        HashMap<Imp, ExtImpRubicon> impToImpExt = new HashMap<Imp, ExtImpRubicon>();
        for (Imp imp : imps) {
            try {
                impToImpExt.put(imp, this.parseRubiconExt(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return impToImpExt;
    }

    private ExtImpRubicon parseRubiconExt(Imp imp) {
        try {
            return (ExtImpRubicon)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), RUBICON_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isMultiformatEnabled(ExtImpRubicon extImp) {
        return Optional.ofNullable(extImp).map(ExtImpRubicon::getBidOnMultiFormat).orElse(false);
    }

    private static String firstImpExtLanguage(Collection<ExtImpRubicon> rubiconImpExts) {
        return rubiconImpExts.stream().filter(Objects::nonNull).map(ExtImpRubicon::getVideo).filter(Objects::nonNull).map(RubiconVideoParams::getLanguage).filter(StringUtils::isNotBlank).findFirst().orElse(null);
    }

    private BidRequest createSingleRequest(BidRequest bidRequest, Imp imp, ExtImpRubicon extImpRubicon, Set<ImpMediaType> formats, String impLanguage, List<BidderError> errors) {
        return bidRequest.toBuilder().imp(Collections.singletonList(this.makeImp(imp, extImpRubicon, bidRequest, formats, errors))).user(this.downgradeUserConsent(this.makeUser(bidRequest.getUser(), extImpRubicon))).device(this.makeDevice(bidRequest.getDevice())).site(this.makeSite(bidRequest.getSite(), impLanguage, extImpRubicon)).app(this.makeApp(bidRequest.getApp(), extImpRubicon)).source(RubiconBidder.makeSource((Source)bidRequest.getSource(), (String)extImpRubicon.getPchain())).cur(null).regs(RubiconBidder.makeRegs((Regs)bidRequest.getRegs())).ext(null).build();
    }

    private String makeUri(BidRequest bidRequest) {
        String tkXint = this.tkXintValue(bidRequest);
        if (StringUtils.isNotBlank((CharSequence)tkXint)) {
            try {
                return new URIBuilder(this.endpointUrl).setParameter("tk_xint", tkXint).build().toString();
            }
            catch (URISyntaxException e) {
                throw new PreBidException("Cant add the tk_xint value for url: " + tkXint, (Throwable)e);
            }
        }
        return this.endpointUrl;
    }

    private String tkXintValue(BidRequest bidRequest) {
        ExtRequest requestExt = bidRequest.getExt();
        ExtRequestPrebid prebidExt = requestExt != null ? requestExt.getPrebid() : null;
        String integration = prebidExt != null ? prebidExt.getIntegration() : null;
        return StringUtils.stripToNull((String)integration);
    }

    private RubiconExtPrebidBiddersBidder extPrebidBiddersRubicon(ExtRequest extRequest) {
        ObjectNode biddersNode;
        ExtRequestPrebid prebid = extRequest == null ? null : extRequest.getPrebid();
        ObjectNode objectNode = biddersNode = prebid == null ? null : prebid.getBidders();
        if (biddersNode != null) {
            try {
                RubiconExtPrebidBidders bidders = (RubiconExtPrebidBidders)this.mapper.mapper().convertValue((Object)biddersNode, RubiconExtPrebidBidders.class);
                return bidders == null ? null : bidders.getBidder();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private Imp makeImp(Imp imp, ExtImpRubicon extImpRubicon, BidRequest bidRequest, Set<ImpMediaType> formats, List<BidderError> errors) {
        BigDecimal resolvedBidFloor;
        App app = bidRequest.getApp();
        Site site = bidRequest.getSite();
        ExtRequest extRequest = bidRequest.getExt();
        ImpMediaType impType = RubiconBidder.impType((Imp)imp);
        ArrayList priceFloorsWarnings = new ArrayList();
        PriceFloorResult priceFloorResult = this.resolvePriceFloors(bidRequest, imp, impType, priceFloorsWarnings);
        Set resolvedFormats = (Set)ObjectUtils.defaultIfNull((Object)extImpRubicon.getFormats(), formats);
        BigDecimal ipfFloor = (BigDecimal)ObjectUtil.getIfNotNull((Object)priceFloorResult, PriceFloorResult::getFloorValue);
        String ipfCurrency = ipfFloor != null ? RubiconBidder.resolveCurrencyFromFloorResult((String)((String)ObjectUtil.getIfNotNull((Object)priceFloorResult, PriceFloorResult::getCurrency)), (BidRequest)bidRequest, (Imp)imp, errors) : null;
        Imp.ImpBuilder builder = imp.toBuilder().metric(this.makeMetrics(imp)).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)this.makeImpExt(imp, bidRequest, extImpRubicon, resolvedFormats, site, app, extRequest, ipfCurrency, priceFloorResult)));
        BigDecimal bigDecimal = resolvedBidFloor = ipfFloor != null ? this.convertToXAPICurrency(ipfFloor, ipfCurrency, imp, bidRequest) : this.resolveBidFloorFromImp(imp, bidRequest, errors);
        if (resolvedBidFloor != null) {
            builder.bidfloorcur("USD").bidfloor(resolvedBidFloor);
        }
        switch (3.$SwitchMap$org$prebid$server$proto$openrtb$ext$request$ImpMediaType[impType.ordinal()]) {
            case 1: {
                builder.banner(null).xNative(null).rwdd(null).video(this.makeVideo(imp, extImpRubicon.getVideo(), RubiconBidder.referer((Site)site)));
                break;
            }
            case 2: {
                builder.banner(this.makeBanner(imp)).xNative(null).video(null);
                break;
            }
            default: {
                builder.video(null).xNative(this.makeNative(imp));
            }
        }
        this.processWarnings(errors, priceFloorsWarnings);
        return builder.build();
    }

    private PriceFloorResult resolvePriceFloors(BidRequest bidRequest, Imp imp, ImpMediaType mediaType, List<String> warnings) {
        return this.floorResolver.resolve(bidRequest, RubiconBidder.extractFloorRules((BidRequest)bidRequest), imp, mediaType, null, warnings);
    }

    private static PriceFloorRules extractFloorRules(BidRequest bidRequest) {
        ExtRequestPrebid prebid = (ExtRequestPrebid)ObjectUtil.getIfNotNull((Object)bidRequest.getExt(), ExtRequest::getPrebid);
        return (PriceFloorRules)ObjectUtil.getIfNotNull((Object)prebid, ExtRequestPrebid::getFloors);
    }

    private List<Metric> makeMetrics(Imp imp) {
        List metrics = imp.getMetric();
        if (metrics == null) {
            return null;
        }
        ArrayList<Metric> modifiedMetrics = new ArrayList<Metric>();
        for (Metric metric : metrics) {
            if (this.isMetricSupported(metric)) {
                modifiedMetrics.add(metric.toBuilder().vendor("seller-declared").build());
                continue;
            }
            modifiedMetrics.add(metric);
        }
        return modifiedMetrics;
    }

    private boolean isMetricSupported(Metric metric) {
        return this.supportedVendors.contains(metric.getVendor()) && Objects.equals(metric.getType(), "viewability");
    }

    private BigDecimal resolveBidFloorFromImp(Imp imp, BidRequest bidRequest, List<BidderError> errors) {
        BigDecimal resolvedBidFloorPrice = RubiconBidder.resolveBidFloorPrice((Imp)imp);
        if (resolvedBidFloorPrice == null) {
            return null;
        }
        return this.convertToXAPICurrency(resolvedBidFloorPrice, RubiconBidder.resolveBidFloorCurrency((Imp)imp, (BidRequest)bidRequest, errors), imp, bidRequest);
    }

    private BigDecimal convertToXAPICurrency(BigDecimal value, String fromCurrency, Imp imp, BidRequest bidRequest) {
        return ObjectUtils.notEqual((Object)fromCurrency, (Object)"USD") ? this.convertBidFloorCurrency(value, fromCurrency, imp, bidRequest) : value;
    }

    private static BigDecimal resolveBidFloorPrice(Imp imp) {
        BigDecimal bidFloor = imp.getBidfloor();
        return BidderUtil.isValidPrice((BigDecimal)bidFloor) ? bidFloor : null;
    }

    private static String resolveBidFloorCurrency(Imp imp, BidRequest bidRequest, List<BidderError> errors) {
        String bidFloorCurrency = imp.getBidfloorcur();
        if (StringUtils.isBlank((CharSequence)bidFloorCurrency)) {
            if (RubiconBidder.isDebugEnabled((BidRequest)bidRequest)) {
                errors.add(BidderError.badInput((String)"Imp `%s` floor provided with no currency, assuming %s".formatted(imp.getId(), "USD")));
            }
            return "USD";
        }
        return bidFloorCurrency;
    }

    private static String resolveCurrencyFromFloorResult(String floorCurrency, BidRequest bidRequest, Imp imp, List<BidderError> errors) {
        if (StringUtils.isBlank((CharSequence)floorCurrency)) {
            if (RubiconBidder.isDebugEnabled((BidRequest)bidRequest)) {
                errors.add(BidderError.badInput((String)"Ipf for imp `%s` provided floor with no currency, assuming %s".formatted(imp.getId(), "USD")));
            }
            return "USD";
        }
        return floorCurrency;
    }

    private static boolean isDebugEnabled(BidRequest bidRequest) {
        if (Objects.equals(bidRequest.getTest(), 1)) {
            return true;
        }
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        return extRequestPrebid != null && Objects.equals(extRequestPrebid.getDebug(), 1);
    }

    private BigDecimal convertBidFloorCurrency(BigDecimal bidFloor, String bidFloorCurrency, Imp imp, BidRequest bidRequest) {
        try {
            return this.currencyConversionService.convertCurrency(bidFloor, bidRequest, bidFloorCurrency, "USD");
        }
        catch (PreBidException e) {
            throw new PreBidException("Unable to convert provided bid floor currency from %s to %s for imp `%s` with a reason: %s".formatted(bidFloorCurrency, "USD", imp.getId(), e.getMessage()));
        }
    }

    private RubiconImpExt makeImpExt(Imp imp, BidRequest bidRequest, ExtImpRubicon rubiconImpExt, Set<ImpMediaType> formats, Site site, App app, ExtRequest extRequest, String ipfResolvedCurrency, PriceFloorResult priceFloorResult) {
        RubiconImpExtPrebid rubiconImpExtPrebid = priceFloorResult != null ? this.makeRubiconExtPrebid(priceFloorResult, ipfResolvedCurrency, imp, bidRequest) : null;
        RubiconImpExtRpRtb rubiconImpExtRpRtb = CollectionUtils.isNotEmpty(formats) ? RubiconImpExtRpRtb.of(formats) : null;
        RubiconImpExtRp rubiconImpExtRp = RubiconImpExtRp.of((Integer)rubiconImpExt.getZoneId(), (JsonNode)this.makeTarget(imp, rubiconImpExt, site, app), (RubiconImpExtRpTrack)RubiconImpExtRpTrack.of((String)"", (String)""), (RubiconImpExtRpRtb)rubiconImpExtRpRtb);
        return RubiconImpExt.builder().rp(rubiconImpExtRp).viewabilityvendors(this.mapVendorsNamesToUrls(imp.getMetric())).maxbids(this.getMaxBids(extRequest)).gpid(this.getGpid(imp.getExt())).skadn(this.getSkadn(imp.getExt())).prebid(rubiconImpExtPrebid).build();
    }

    private JsonNode makeTarget(Imp imp, ExtImpRubicon rubiconImpExt, Site site, App app) {
        ObjectNode result = this.mapper.mapper().createObjectNode();
        this.populateFirstPartyDataAttributes(rubiconImpExt.getInventory(), result);
        this.mergeFirstPartyDataFromSite(site, result);
        this.mergeFirstPartyDataFromApp(app, result);
        this.mergeFirstPartyDataFromImp(imp, rubiconImpExt, result);
        return result.size() > 0 ? result : null;
    }

    private RubiconImpExtPrebid makeRubiconExtPrebid(PriceFloorResult priceFloorResult, String currency, Imp imp, BidRequest bidRequest) {
        ObjectNode impExt = imp.getExt();
        ExtImpPrebid extImpPrebid = this.extImpPrebid(impExt.get("prebid"));
        ExtImpPrebidFloors floors = extImpPrebid != null ? extImpPrebid.getFloors() : null;
        return RubiconImpExtPrebid.of((ExtImpPrebidFloors)ExtImpPrebidFloors.of((String)priceFloorResult.getFloorRule(), (BigDecimal)this.convertToXAPICurrency(priceFloorResult.getFloorRuleValue(), currency, imp, bidRequest), (BigDecimal)this.convertToXAPICurrency(priceFloorResult.getFloorValue(), currency, imp, bidRequest), (BigDecimal)(floors != null ? floors.getFloorMin() : null), (String)(floors != null ? floors.getFloorMinCur() : null)));
    }

    private ExtImpPrebid extImpPrebid(JsonNode extImpPrebid) {
        try {
            return (ExtImpPrebid)this.mapper.mapper().treeToValue((TreeNode)extImpPrebid, ExtImpPrebid.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding imp.ext.prebid: " + e.getMessage(), (Throwable)e);
        }
    }

    private void mergeFirstPartyDataFromSite(Site site, ObjectNode result) {
        ExtSite siteExt;
        ExtSite extSite = siteExt = site != null ? site.getExt() : null;
        if (siteExt != null) {
            this.populateFirstPartyDataAttributes(siteExt.getData(), result);
        }
    }

    private void mergeFirstPartyDataFromApp(App app, ObjectNode result) {
        ExtApp appExt;
        ExtApp extApp = appExt = app != null ? app.getExt() : null;
        if (appExt != null) {
            this.populateFirstPartyDataAttributes(appExt.getData(), result);
        }
    }

    private void mergeFirstPartyDataFromImp(Imp imp, ExtImpRubicon rubiconImpExt, ObjectNode result) {
        this.mergeFirstPartyDataKeywords(imp, result);
        this.mergeFirstPartyDataFromData(imp, result);
        this.mergeCollectionAttributeIntoArray(result, (Object)rubiconImpExt, ExtImpRubicon::getKeywords, "keywords");
    }

    private void mergeFirstPartyDataFromData(Imp imp, ObjectNode result) {
        ObjectNode dataNode = this.toObjectNode(imp.getExt().get("data"));
        this.populateFirstPartyDataAttributes(dataNode, result);
        this.overrideFirstPartyDataAttributes(dataNode, result);
    }

    private void overrideFirstPartyDataAttributes(ObjectNode dataNode, ObjectNode result) {
        JsonNode pbadslotNode = dataNode.get("pbadslot");
        if (pbadslotNode != null && pbadslotNode.isTextual()) {
            result.set("pbadslot", pbadslotNode);
        } else {
            String resolvedDfpAdUnitCode = this.getAdSlotFromAdServer((JsonNode)dataNode);
            if (resolvedDfpAdUnitCode != null) {
                result.set("dfp_ad_unit_code", (JsonNode)TextNode.valueOf((String)resolvedDfpAdUnitCode));
            }
        }
    }

    private void mergeFirstPartyDataKeywords(Imp imp, ObjectNode result) {
        String dataKeywords = RubiconBidder.getTextValueFromNodeByPath((JsonNode)imp.getExt().get("data"), (String)"keywords");
        if (StringUtils.isNotBlank((CharSequence)dataKeywords)) {
            this.mergeIntoArray(result, "keywords", dataKeywords.split(","));
        }
    }

    private <S, T extends Collection<? extends String>> void mergeCollectionAttributeIntoArray(ObjectNode result, S source, Function<S, T> getter, String fieldName) {
        Collection attribute;
        Collection collection = attribute = source != null ? (Collection)getter.apply(source) : null;
        if (CollectionUtils.isNotEmpty((Collection)attribute)) {
            this.mergeIntoArray(result, fieldName, attribute);
        }
    }

    private <S, T extends String> void mergeStringAttributeIntoArray(ObjectNode result, S source, Function<S, T> getter, String fieldName) {
        String attribute;
        String string = attribute = source != null ? (String)getter.apply(source) : null;
        if (StringUtils.isNotBlank((CharSequence)attribute)) {
            this.mergeIntoArray(result, fieldName, new String[]{attribute});
        }
    }

    private void mergeIntoArray(ObjectNode result, String arrayField, String ... values) {
        this.mergeIntoArray(result, arrayField, Arrays.asList(values));
    }

    private void mergeIntoArray(ObjectNode result, String arrayField, Collection<? extends String> values) {
        JsonNode existingArray = result.get(arrayField);
        LinkedHashSet existingArrayValues = existingArray != null && RubiconBidder.isTextualArray((JsonNode)existingArray) ? RubiconBidder.stringArrayToStringSet((JsonNode)existingArray) : new LinkedHashSet();
        existingArrayValues.addAll(values);
        result.set(arrayField, (JsonNode)this.stringsToStringArray(existingArrayValues.toArray(new String[0])));
    }

    private static String getTextValueFromNodeByPath(JsonNode node, String path) {
        JsonNode nodeByPath = node != null ? node.get(path) : null;
        return nodeByPath != null && nodeByPath.isTextual() ? nodeByPath.textValue() : null;
    }

    private static String getTextValueFromNode(JsonNode node) {
        return node != null && node.isTextual() ? node.textValue() : null;
    }

    private void populateFirstPartyDataAttributes(ObjectNode sourceNode, ObjectNode targetNode) {
        if (sourceNode == null || sourceNode.isNull()) {
            return;
        }
        Iterator fieldNames = sourceNode.fieldNames();
        while (fieldNames.hasNext()) {
            String currentFieldName = (String)fieldNames.next();
            JsonNode currentField = sourceNode.get(currentFieldName);
            if (RubiconBidder.isTextualArray((JsonNode)currentField)) {
                this.mergeIntoArray(targetNode, currentFieldName, (Collection)RubiconBidder.stringArrayToStringSet((JsonNode)currentField));
                continue;
            }
            if (currentField.isTextual()) {
                this.mergeIntoArray(targetNode, currentFieldName, new String[]{currentField.textValue()});
                continue;
            }
            if (currentField.isIntegralNumber()) {
                this.mergeIntoArray(targetNode, currentFieldName, new String[]{Long.toString(currentField.longValue())});
                continue;
            }
            if (currentField.isBoolean()) {
                this.mergeIntoArray(targetNode, currentFieldName, new String[]{Boolean.toString(currentField.booleanValue())});
                continue;
            }
            if (RubiconBidder.isBooleanArray((JsonNode)currentField)) {
                this.mergeIntoArray(targetNode, currentFieldName, (Collection)RubiconBidder.booleanArrayToStringList((JsonNode)currentField));
                continue;
            }
            if (!RubiconBidder.isIntegerArray((JsonNode)currentField)) continue;
            this.mergeIntoArray(targetNode, currentFieldName, (Collection)RubiconBidder.integerArrayToStringList((JsonNode)currentField));
        }
    }

    private static boolean isTextualArray(JsonNode node) {
        return node.isArray() && StreamSupport.stream(node.spliterator(), false).allMatch(JsonNode::isTextual);
    }

    private static boolean isBooleanArray(JsonNode node) {
        return node.isArray() && StreamSupport.stream(node.spliterator(), false).allMatch(JsonNode::isBoolean);
    }

    private static boolean isIntegerArray(JsonNode node) {
        return node.isArray() && StreamSupport.stream(node.spliterator(), false).allMatch(JsonNode::isIntegralNumber);
    }

    private ArrayNode stringsToStringArray(String ... values) {
        return this.stringsToStringArray(Arrays.asList(values));
    }

    private ArrayNode stringsToStringArray(Collection<String> values) {
        ArrayNode arrayNode = this.mapper.mapper().createArrayNode();
        values.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        return arrayNode;
    }

    private static LinkedHashSet<String> stringArrayToStringSet(JsonNode stringArray) {
        return StreamSupport.stream(stringArray.spliterator(), false).map(JsonNode::asText).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static List<String> booleanArrayToStringList(JsonNode booleanArray) {
        return StreamSupport.stream(booleanArray.spliterator(), false).map(JsonNode::booleanValue).map(value -> Boolean.toString(value)).toList();
    }

    private static List<String> integerArrayToStringList(JsonNode booleanArray) {
        return StreamSupport.stream(booleanArray.spliterator(), false).map(JsonNode::intValue).map(value -> Integer.toString(value)).toList();
    }

    private List<String> mapVendorsNamesToUrls(List<Metric> metrics) {
        if (metrics == null) {
            return null;
        }
        List<String> vendorsUrls = metrics.stream().filter(arg_0 -> this.isMetricSupported(arg_0)).map(metric -> ViewabilityVendors.valueOf((String)metric.getVendor()).getUrl()).toList();
        return vendorsUrls.isEmpty() ? null : vendorsUrls;
    }

    private Integer getMaxBids(ExtRequest extRequest) {
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        List multibids = extRequestPrebid != null ? extRequestPrebid.getMultibid() : null;
        ExtRequestPrebidMultiBid extRequestPrebidMultiBid = CollectionUtils.isNotEmpty((Collection)multibids) ? (ExtRequestPrebidMultiBid)multibids.get(0) : null;
        Integer multibidMaxBids = extRequestPrebidMultiBid != null ? extRequestPrebidMultiBid.getMaxBids() : null;
        return multibidMaxBids != null ? multibidMaxBids : 1;
    }

    private String getGpid(ObjectNode impExt) {
        JsonNode gpidNode = impExt.get("gpid");
        return gpidNode != null && gpidNode.isTextual() ? gpidNode.asText() : null;
    }

    private ObjectNode getSkadn(ObjectNode impExt) {
        JsonNode skadnNode = impExt.get("skadn");
        return skadnNode != null && skadnNode.isObject() ? (ObjectNode)skadnNode : null;
    }

    private String getAdSlot(Imp imp) {
        ObjectNode dataNode = this.toObjectNode(imp.getExt().get("data"));
        return this.getAdSlotFromAdServer((JsonNode)dataNode);
    }

    private String getAdSlotFromAdServer(JsonNode dataNode) {
        ExtImpContextDataAdserver adServer = this.extImpContextDataAdserver(dataNode);
        return adServer != null && Objects.equals(adServer.getName(), "gam") ? adServer.getAdslot() : null;
    }

    private ExtImpContextDataAdserver extImpContextDataAdserver(JsonNode contextData) {
        JsonNode adServerNode;
        JsonNode jsonNode = adServerNode = contextData != null ? contextData.get("adserver") : null;
        if (adServerNode == null || adServerNode.isNull()) {
            return null;
        }
        try {
            return (ExtImpContextDataAdserver)this.mapper.mapper().convertValue((Object)adServerNode, ExtImpContextDataAdserver.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static ImpMediaType impType(Imp imp) {
        Video video = imp.getVideo();
        Banner banner = imp.getBanner();
        Native xNative = imp.getXNative();
        if (video != null && (banner == null && xNative == null || RubiconBidder.isFullyPopulatedVideo((Video)video))) {
            return ImpMediaType.video;
        }
        if (banner == null && xNative != null) {
            return ImpMediaType.xNative;
        }
        return ImpMediaType.banner;
    }

    private static boolean isFullyPopulatedVideo(Video video) {
        return video.getMimes() != null && video.getProtocols() != null && video.getMaxduration() != null && video.getLinearity() != null && video.getApi() != null;
    }

    private static String referer(Site site) {
        return site != null ? site.getPage() : null;
    }

    private Video makeVideo(Imp imp, RubiconVideoParams rubiconVideoParams, String referer) {
        String videoType;
        Video video = imp.getVideo();
        Integer skip = rubiconVideoParams != null ? rubiconVideoParams.getSkip() : null;
        Integer skipDelay = rubiconVideoParams != null ? rubiconVideoParams.getSkipdelay() : null;
        Integer rewarded = imp.getRwdd();
        String string = videoType = rewarded != null && rewarded == 1 ? "rewarded" : null;
        if (skip == null && skipDelay == null && videoType == null) {
            return video;
        }
        return video.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)RubiconVideoExt.of((Integer)skip, (Integer)skipDelay, (String)videoType))).build();
    }

    private Banner makeBanner(Imp imp) {
        Banner banner = imp.getBanner();
        Integer width = banner.getW();
        Integer height = banner.getH();
        List format = banner.getFormat();
        if ((width == null || height == null) && CollectionUtils.isEmpty((Collection)format)) {
            throw new PreBidException("rubicon imps must have at least one size element [w, h, format]");
        }
        return banner.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)RubiconBannerExt.of((RubiconBannerExtRp)RubiconBannerExtRp.of((String)"text/html")))).build();
    }

    private Native makeNative(Imp imp) {
        Native xNative = imp.getXNative();
        String version = (String)ObjectUtil.getIfNotNull((Object)xNative, Native::getVer);
        if (StringUtils.equalsAny((CharSequence)version, (CharSequence[])new CharSequence[]{"1.0", "1.1"})) {
            return xNative;
        }
        String nativeRequest = xNative.getRequest();
        JsonNode requestNode = this.nodeFromString(nativeRequest);
        try {
            this.validateNativeRequest(requestNode);
        }
        catch (PreBidException e) {
            throw new PreBidException(String.format("Error in native object for imp with id %s: %s", imp.getId(), e.getMessage()));
        }
        return ((RubiconNative.RubiconNativeBuilder)((RubiconNative.RubiconNativeBuilder)((RubiconNative.RubiconNativeBuilder)((RubiconNative.RubiconNativeBuilder)((RubiconNative.RubiconNativeBuilder)RubiconNative.builder().requestNative((ObjectNode)requestNode).request(xNative.getRequest())).ver(xNative.getVer())).api(xNative.getApi())).battr(xNative.getBattr())).ext(xNative.getExt())).build();
    }

    public final JsonNode nodeFromString(String stringValue) {
        try {
            return StringUtils.isNotBlank((CharSequence)stringValue) ? this.mapper.mapper().readTree(stringValue) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void validateNativeRequest(JsonNode requestNode) {
        if (requestNode == null) {
            throw new PreBidException("Request can not be parsed");
        }
        JsonNode eventtrackers = requestNode.get("eventtrackers");
        if (eventtrackers == null || !eventtrackers.isArray()) {
            throw new PreBidException("Eventtrackers are not present or not of array type");
        }
        JsonNode context = requestNode.get("context");
        if (context != null && !context.isInt()) {
            throw new PreBidException("Context is not of int type");
        }
        JsonNode placement = requestNode.get("plcmttype");
        if (placement == null || !placement.isInt()) {
            throw new PreBidException("Plcmttype is not present or not of int type");
        }
    }

    private User makeUser(User user, ExtImpRubicon rubiconImpExt) {
        ObjectNode userExtData;
        String userId = user != null ? user.getId() : null;
        List userEids = user != null ? user.getEids() : null;
        String resolvedId = userId == null ? RubiconBidder.resolveUserId((List)userEids) : null;
        String userBuyeruid = user != null ? user.getBuyeruid() : null;
        String resolvedBuyeruid = userBuyeruid != null ? userBuyeruid : RubiconBidder.resolveBuyeruidFromEids((List)userEids);
        ExtUser extUser = user != null ? user.getExt() : null;
        boolean hasStypeToRemove = RubiconBidder.hasStypeToRemove((List)userEids);
        List resolvedUserEids = hasStypeToRemove ? RubiconBidder.prepareUserEids((List)userEids) : userEids;
        boolean hasDataToRemove = ObjectUtil.getIfNotNull((Object)user, User::getData) != null;
        RubiconUserExtRp userExtRp = this.rubiconUserExtRp(user, rubiconImpExt);
        ObjectNode objectNode = userExtData = extUser != null ? extUser.getData() : null;
        if (userExtRp == null && userExtData == null && resolvedUserEids == null && resolvedId == null && Objects.equals(userBuyeruid, resolvedBuyeruid) && !hasStypeToRemove) {
            return hasDataToRemove ? user.toBuilder().data(null).build() : user;
        }
        ExtUser userExt = ExtUser.builder().eids(resolvedUserEids).fcapIds(extUser != null ? extUser.getFcapIds() : null).build();
        RubiconUserExt rubiconUserExt = RubiconUserExt.builder().rp(userExtRp).build();
        User.UserBuilder userBuilder = user != null ? user.toBuilder() : User.builder();
        return userBuilder.id((String)ObjectUtils.defaultIfNull((Object)resolvedId, (Object)userId)).buyeruid(resolvedBuyeruid).gender(null).yob(null).geo(null).data(null).eids(null).ext((ExtUser)this.mapper.fillExtension((FlexibleExtension)userExt, (Object)rubiconUserExt)).build();
    }

    private User downgradeUserConsent(User user) {
        if (user == null || user.getConsent() == null) {
            return user;
        }
        ExtUser extUser = user.getExt();
        ExtUser newUserExt = Optional.ofNullable(extUser).map(ExtUser::toBuilder).orElseGet(ExtUser::builder).consent(user.getConsent()).build();
        if (extUser != null) {
            newUserExt.addProperties(user.getExt().getProperties());
        }
        return user.toBuilder().consent(null).ext(newUserExt).build();
    }

    private static String resolveUserId(List<Eid> userEids) {
        return CollectionUtils.emptyIfNull(userEids).stream().map(userEid -> RubiconBidder.getIdFromFirstUuidWithStypePpuid((List)userEid.getUids())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String getIdFromFirstUuidWithStypePpuid(List<Uid> extUserEidUids) {
        return CollectionUtils.emptyIfNull(extUserEidUids).stream().filter(Objects::nonNull).filter(extUserEidUid -> Objects.equals("ppuid", RubiconBidder.getUserEidUidStype((Uid)extUserEidUid))).map(Uid::getId).findFirst().orElse(null);
    }

    private static String getUserEidUidStype(Uid uid) {
        ObjectNode uidExt = uid != null ? uid.getExt() : null;
        JsonNode stype = uidExt != null ? uidExt.path("stype") : null;
        return stype != null && !stype.isMissingNode() ? stype.asText() : null;
    }

    private static boolean hasStypeToRemove(List<Eid> userEids) {
        return CollectionUtils.emptyIfNull(userEids).stream().filter(Objects::nonNull).map(Eid::getUids).filter(Objects::nonNull).flatMap(Collection::stream).map(RubiconBidder::getUserEidUidStype).filter(Objects::nonNull).anyMatch(STYPE_TO_REMOVE::contains);
    }

    private static List<Eid> prepareUserEids(List<Eid> userEids) {
        return CollectionUtils.emptyIfNull(userEids).stream().filter(Objects::nonNull).map(RubiconBidder::prepareExtUserEid).toList();
    }

    private static Eid prepareExtUserEid(Eid extUserEid) {
        List<Uid> extUserEidUids = CollectionUtils.emptyIfNull((Collection)extUserEid.getUids()).stream().filter(Objects::nonNull).map(RubiconBidder::cleanExtUserEidUidStype).toList();
        return Eid.of((String)extUserEid.getSource(), extUserEidUids, (ObjectNode)extUserEid.getExt());
    }

    private static Uid cleanExtUserEidUidStype(Uid extUserEidUid) {
        ObjectNode extUserEidUidExt = extUserEidUid.getExt();
        if (extUserEidUidExt == null || !STYPE_TO_REMOVE.contains(RubiconBidder.getUserEidUidStype((Uid)extUserEidUid))) {
            return extUserEidUid;
        }
        ObjectNode extUserEidUidExtCopy = extUserEidUidExt.deepCopy();
        extUserEidUidExtCopy.remove("stype");
        return Uid.of((String)extUserEidUid.getId(), (Integer)extUserEidUid.getAtype(), (ObjectNode)extUserEidUidExtCopy);
    }

    private static String resolveBuyeruidFromEids(List<Eid> eids) {
        return CollectionUtils.emptyIfNull(eids).stream().filter(Objects::nonNull).filter(eid -> "rubiconproject.com".equals(eid.getSource())).map(Eid::getUids).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(Uid::getId).findFirst().orElse(null);
    }

    private RubiconUserExtRp rubiconUserExtRp(User user, ExtImpRubicon rubiconImpExt) {
        JsonNode target = this.rubiconUserExtRpTarget(rubiconImpExt.getVisitor(), user);
        return target != null ? RubiconUserExtRp.of((JsonNode)target) : null;
    }

    private JsonNode rubiconUserExtRpTarget(ObjectNode visitor, User user) {
        ObjectNode result = this.existingRubiconUserExtRpTarget(user);
        this.populateFirstPartyDataAttributes(visitor, result);
        if (user != null) {
            this.mergeFirstPartyDataFromUser(user.getExt(), result);
            RubiconBidder.enrichWithIabAttribute((ObjectNode)result, (List)user.getData(), (Set)USER_SEGTAXES);
            RubiconBidder.enrichWithSegtaxBlahAttribute((ObjectNode)result, (List)user.getData(), (Set)USER_SEGTAXES);
        }
        return !result.isEmpty() ? result : null;
    }

    private ObjectNode existingRubiconUserExtRpTarget(User user) {
        ExtUser userExt = user != null ? user.getExt() : null;
        RubiconUserExt userRubiconExt = userExt != null ? (RubiconUserExt)this.mapper.mapper().convertValue((Object)userExt, RubiconUserExt.class) : null;
        RubiconUserExtRp userRubiconRpExt = userRubiconExt != null ? userRubiconExt.getRp() : null;
        JsonNode target = userRubiconRpExt != null ? userRubiconRpExt.getTarget() : null;
        return target != null && target.isObject() ? (ObjectNode)target : this.mapper.mapper().createObjectNode();
    }

    private void mergeFirstPartyDataFromUser(ExtUser userExt, ObjectNode result) {
        if (userExt != null) {
            this.populateFirstPartyDataAttributes(userExt.getData(), result);
        }
    }

    private static void enrichWithIabAttribute(ObjectNode target, List<Data> data, Set<Integer> segtaxValues) {
        List<String> iabValue = CollectionUtils.emptyIfNull(data).stream().filter(Objects::nonNull).filter(dataRecord -> RubiconBidder.containsSegtaxValue((ObjectNode)dataRecord.getExt(), (Set)segtaxValues)).map(Data::getSegment).filter(Objects::nonNull).flatMap(segments -> segments.stream().map(Segment::getId)).filter(Objects::nonNull).toList();
        if (CollectionUtils.isNotEmpty(iabValue)) {
            ArrayNode iab = target.putArray("iab");
            iabValue.forEach(arg_0 -> ((ArrayNode)iab).add(arg_0));
        }
    }

    private static void enrichWithSegtaxBlahAttribute(ObjectNode target, List<Data> data, Set<Integer> segtaxValues) {
        List validDataSegments = RubiconBidder.getValidDataSegments((List)CollectionUtils.emptyIfNull(data).stream().filter(Objects::nonNull).filter(dataRecord -> !RubiconBidder.containsSegtaxValue((ObjectNode)dataRecord.getExt(), (Set)segtaxValues)).map(Data::getSegment).filter(CollectionUtils::isNotEmpty).collect(Collectors.toCollection(ArrayList::new)));
        if (CollectionUtils.isEmpty((Collection)validDataSegments)) {
            return;
        }
        List values = RubiconBidder.resolveSegtaxBlahValues((List)validDataSegments);
        ArrayNode segtaxBlah = target.putArray("segtaxBLAH");
        values.forEach(arg_0 -> ((ArrayNode)segtaxBlah).add(arg_0));
    }

    private static List<List<Segment>> getValidDataSegments(List<List<Segment>> dataSegments) {
        return dataSegments.stream().map(RubiconBidder::getValidOnlySegments).filter(CollectionUtils::isNotEmpty).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Segment> getValidOnlySegments(List<Segment> segments) {
        return segments.stream().filter(segment -> StringUtils.isNotBlank((CharSequence)segment.getId())).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<String> resolveSegtaxBlahValues(List<List<Segment>> segments) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            int segmentsIndex = i % segments.size();
            List<Segment> currentSegments = segments.get(segmentsIndex);
            values.add(RubiconBidder.getAndRemoveLastSegment(currentSegments).getId());
            if (!CollectionUtils.isEmpty(currentSegments)) continue;
            segments.remove(segmentsIndex);
            if (CollectionUtils.isEmpty(segments)) break;
        }
        return values;
    }

    private static Segment getAndRemoveLastSegment(List<Segment> list) {
        int lastElementIndex = list.size() - 1;
        Segment lastSegment = list.get(lastElementIndex);
        list.remove(lastElementIndex);
        return lastSegment;
    }

    private static boolean containsSegtaxValue(ObjectNode ext, Set<Integer> segtaxValues) {
        JsonNode taxonomyName = ext != null ? ext.get("segtax") : null;
        return taxonomyName != null && taxonomyName.isInt() && segtaxValues.contains(taxonomyName.intValue());
    }

    private void processWarnings(List<BidderError> errors, List<String> priceFloorsWarnings) {
        if (CollectionUtils.isNotEmpty(priceFloorsWarnings)) {
            priceFloorsWarnings.forEach(warning -> errors.add(BidderError.badInput((String)warning)));
        }
    }

    private Device makeDevice(Device device) {
        return device == null ? null : device.toBuilder().ext((ExtDevice)this.mapper.fillExtension((FlexibleExtension)ExtDevice.empty(), (Object)RubiconDeviceExt.of((RubiconDeviceExtRp)RubiconDeviceExtRp.of((BigDecimal)device.getPxratio())))).build();
    }

    private Site makeSite(Site site, String impLanguage, ExtImpRubicon rubiconImpExt) {
        if (site == null && StringUtils.isBlank((CharSequence)impLanguage)) {
            return null;
        }
        return site == null ? Site.builder().content(RubiconBidder.makeSiteContent(null, (String)impLanguage)).build() : site.toBuilder().publisher(this.makePublisher(rubiconImpExt)).content(RubiconBidder.makeSiteContent((Content)site.getContent(), (String)impLanguage)).ext(this.makeSiteExt(site, rubiconImpExt)).build();
    }

    private static Content makeSiteContent(Content siteContent, String impLanguage) {
        String resolvedLanguage;
        boolean hasDataToRemove = ObjectUtil.getIfNotNull((Object)siteContent, Content::getData) != null;
        String contentLanguage = (String)ObjectUtil.getIfNotNull((Object)siteContent, Content::getLanguage);
        String string = resolvedLanguage = StringUtils.isBlank((CharSequence)contentLanguage) && StringUtils.isNotBlank((CharSequence)impLanguage) ? impLanguage : null;
        return resolvedLanguage != null || hasDataToRemove ? Optional.ofNullable(siteContent).map(Content::toBuilder).orElseGet(Content::builder).data(null).language(resolvedLanguage != null ? resolvedLanguage : contentLanguage).build() : siteContent;
    }

    private Publisher makePublisher(ExtImpRubicon rubiconImpExt) {
        return Publisher.builder().ext(this.makePublisherExt(rubiconImpExt)).build();
    }

    private ExtPublisher makePublisherExt(ExtImpRubicon rubiconImpExt) {
        return (ExtPublisher)this.mapper.fillExtension((FlexibleExtension)ExtPublisher.empty(), (Object)RubiconPubExt.of((RubiconPubExtRp)RubiconPubExtRp.of((Integer)rubiconImpExt.getAccountId())));
    }

    private ExtSite makeSiteExt(Site site, ExtImpRubicon rubiconImpExt) {
        ExtSite extSite = site != null ? site.getExt() : null;
        Integer siteExtAmp = extSite != null ? extSite.getAmp() : null;
        Content siteContent = site != null ? site.getContent() : null;
        List siteContentData = siteContent != null ? siteContent.getData() : null;
        ObjectNode target = null;
        if (CollectionUtils.isNotEmpty((Collection)siteContentData)) {
            target = this.existingRubiconSiteExtRpTargetOrEmptyNode(extSite);
            RubiconBidder.enrichWithIabAttribute((ObjectNode)target, (List)siteContentData, (Set)SITE_SEGTAXES);
            RubiconBidder.enrichWithSegtaxBlahAttribute((ObjectNode)target, (List)siteContentData, (Set)SITE_SEGTAXES);
        }
        return (ExtSite)this.mapper.fillExtension((FlexibleExtension)ExtSite.of((Integer)siteExtAmp, null), (Object)RubiconSiteExt.of((RubiconSiteExtRp)RubiconSiteExtRp.of((Integer)rubiconImpExt.getSiteId(), target != null && !target.isEmpty() ? target : null)));
    }

    private ObjectNode existingRubiconSiteExtRpTargetOrEmptyNode(ExtSite siteExt) {
        RubiconSiteExt rubiconSiteExt = siteExt != null ? (RubiconSiteExt)this.mapper.mapper().convertValue((Object)siteExt, RubiconSiteExt.class) : null;
        RubiconSiteExtRp rubiconSiteExtRp = rubiconSiteExt != null ? rubiconSiteExt.getRp() : null;
        JsonNode target = rubiconSiteExtRp != null ? rubiconSiteExtRp.getTarget() : null;
        return target != null && target.isObject() ? (ObjectNode)target : this.mapper.mapper().createObjectNode();
    }

    private App makeApp(App app, ExtImpRubicon rubiconImpExt) {
        return app == null ? null : app.toBuilder().publisher(this.makePublisher(rubiconImpExt)).ext(this.makeAppExt(rubiconImpExt)).build();
    }

    private ExtApp makeAppExt(ExtImpRubicon rubiconImpExt) {
        return (ExtApp)this.mapper.fillExtension((FlexibleExtension)ExtApp.of(null, null), (Object)RubiconAppExt.of((RubiconSiteExtRp)RubiconSiteExtRp.of((Integer)rubiconImpExt.getSiteId(), null)));
    }

    private static Source makeSource(Source source, String pchain) {
        SupplyChain supplyChain;
        boolean isPchainEmpty = StringUtils.isEmpty((CharSequence)pchain);
        SupplyChain supplyChain2 = supplyChain = source != null ? source.getSchain() : null;
        if (isPchainEmpty && supplyChain == null) {
            return source;
        }
        ExtSource extSource = source != null ? source.getExt() : null;
        ExtSource resolvedExtSource = supplyChain != null ? (ExtSource)RubiconBidder.copyProperties((FlexibleExtension)extSource, (FlexibleExtension)ExtSource.of((SupplyChain)supplyChain)) : extSource;
        Source.SourceBuilder builder = source != null ? source.toBuilder() : Source.builder();
        return builder.pchain(!isPchainEmpty ? pchain : null).schain(null).ext(resolvedExtSource).build();
    }

    private static <T extends FlexibleExtension> T copyProperties(T source, T target) {
        Optional.ofNullable(source).map(FlexibleExtension::getProperties).ifPresent(arg_0 -> target.addProperties(arg_0));
        return target;
    }

    private static Regs makeRegs(Regs regs) {
        if (regs == null) {
            return null;
        }
        Integer gdpr = regs.getGdpr();
        String usPrivacy = regs.getUsPrivacy();
        if (gdpr == null && usPrivacy == null) {
            return regs;
        }
        ExtRegs originalExtRegs = regs.getExt();
        String gpc = originalExtRegs != null ? originalExtRegs.getGpc() : null;
        ExtRegs extRegs = (ExtRegs)RubiconBidder.copyProperties((FlexibleExtension)originalExtRegs, (FlexibleExtension)ExtRegs.of((Integer)gdpr, (String)usPrivacy, (String)gpc));
        return regs.toBuilder().gdpr(null).usPrivacy(null).ext(extRegs).build();
    }

    private HttpRequest<BidRequest> createHttpRequest(BidRequest bidRequest, String uri) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(uri).body(this.mapper.encodeToBytes((Object)bidRequest)).headers(this.headers).payload((Object)bidRequest).impIds(BidderUtil.impIds((BidRequest)bidRequest)).build();
    }

    private static boolean hasDeals(Imp imp) {
        return imp.getPmp() != null && CollectionUtils.isNotEmpty((Collection)imp.getPmp().getDeals());
    }

    private List<HttpRequest<BidRequest>> createDealsRequests(BidRequest bidRequest, String uri) {
        Imp singleImp = (Imp)bidRequest.getImp().get(0);
        return singleImp.getPmp().getDeals().stream().map(deal -> (ExtDeal)this.mapper.mapper().convertValue((Object)deal.getExt(), ExtDeal.class)).filter(Objects::nonNull).map(ExtDeal::getLine).filter(Objects::nonNull).map(lineItem -> this.createLineItemBidRequest(lineItem, bidRequest, singleImp)).map(request -> this.createHttpRequest(request, uri)).toList();
    }

    private BidRequest createLineItemBidRequest(ExtDealLine lineItem, BidRequest bidRequest, Imp imp) {
        Imp dealsImp = imp.toBuilder().banner(RubiconBidder.modifyBanner((Banner)imp.getBanner(), (List)lineItem.getSizes())).ext(this.modifyRubiconImpExt(imp.getExt(), bidRequest.getExt(), lineItem.getExtLineItemId(), this.getAdSlot(imp))).build();
        return bidRequest.toBuilder().imp(Collections.singletonList(dealsImp)).build();
    }

    private static Banner modifyBanner(Banner banner, List<Format> sizes) {
        return CollectionUtils.isEmpty(sizes) || banner == null ? banner : banner.toBuilder().format(sizes).build();
    }

    private ObjectNode modifyRubiconImpExt(ObjectNode impExtNode, ExtRequest extRequest, String extLineItemId, String adSlot) {
        RubiconImpExt rubiconImpExt = (RubiconImpExt)this.mapper.mapper().convertValue((Object)impExtNode, RubiconImpExt.class);
        RubiconImpExtRp impExtRp = rubiconImpExt.getRp();
        ObjectNode targetNode = impExtRp.getTarget() == null || impExtRp.getTarget().isNull() ? this.mapper.mapper().createObjectNode() : (ObjectNode)impExtRp.getTarget();
        ObjectNode modifiedTargetNode = targetNode.put("line_item", extLineItemId);
        RubiconImpExtRp modifiedImpExtRp = RubiconImpExtRp.of((Integer)impExtRp.getZoneId(), (JsonNode)modifiedTargetNode, (RubiconImpExtRpTrack)impExtRp.getTrack(), (RubiconImpExtRpRtb)impExtRp.getRtb());
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)rubiconImpExt.toBuilder().rp(modifiedImpExtRp).maxbids(this.getMaxBids(extRequest)).gpid(adSlot).prebid(null).build());
    }

    private List<BidderBid> extractBids(BidRequest prebidRequest, BidRequest bidRequest, RubiconBidResponse bidResponse, List<BidderError> errors) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : this.bidsFromResponse(prebidRequest, bidRequest, bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidRequest prebidRequest, BidRequest bidRequest, RubiconBidResponse bidResponse, List<BidderError> errors) {
        Map idToImp = prebidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        Map idToRubiconImp = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        Float cpmOverrideFromRequest = this.cpmOverrideFromRequest(prebidRequest);
        BidType bidType = RubiconBidder.bidType((BidRequest)bidRequest);
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(seatBid -> this.updateSeatBids(seatBid, errors)).map(RubiconSeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> this.updateBid(bid, (Imp)idToImp.get(bid.getImpid()), cpmOverrideFromRequest, bidResponse)).map(bid -> RubiconBidder.createBidderBid((Bid)bid, (Imp)((Imp)idToRubiconImp.get(bid.getImpid())), (BidType)bidType, (String)bidResponse.getCur())).toList();
    }

    private RubiconSeatBid updateSeatBids(RubiconSeatBid seatBid, List<BidderError> errors) {
        String buyer = seatBid.getBuyer();
        int networkId = NumberUtils.toInt((String)buyer, (int)0);
        if (networkId <= 0) {
            return seatBid;
        }
        List<RubiconBid> updatedBids = seatBid.getBid().stream().map(bid -> this.insertNetworkIdToMeta(bid, networkId, errors)).filter(Objects::nonNull).toList();
        return seatBid.toBuilder().bid(updatedBids).build();
    }

    private RubiconBid insertNetworkIdToMeta(RubiconBid bid, int networkId, List<BidderError> errors) {
        ExtPrebid extPrebid;
        ObjectNode bidExt = bid.getExt();
        try {
            extPrebid = this.getExtPrebid(bidExt, bid.getId());
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        ExtBidPrebid extBidPrebid = extPrebid != null ? (ExtBidPrebid)extPrebid.getPrebid() : null;
        ExtBidPrebidMeta meta = extBidPrebid != null ? extBidPrebid.getMeta() : null;
        ExtBidPrebidMeta updatedMeta = meta != null ? meta.toBuilder().networkId(Integer.valueOf(networkId)).build() : ExtBidPrebidMeta.builder().networkId(Integer.valueOf(networkId)).build();
        ExtBidPrebid modifiedExtBidPrebid = extBidPrebid != null ? extBidPrebid.toBuilder().meta(updatedMeta).build() : ExtBidPrebid.builder().meta(updatedMeta).build();
        ObjectNode updatedBidExt = bidExt != null ? bidExt : this.mapper.mapper().createObjectNode();
        updatedBidExt.set("prebid", this.mapper.mapper().valueToTree((Object)modifiedExtBidPrebid));
        return bid.toBuilder().ext(updatedBidExt).build();
    }

    private ExtPrebid<ExtBidPrebid, ObjectNode> getExtPrebid(ObjectNode bidExt, String bidId) {
        try {
            return bidExt != null ? (ExtPrebid)this.mapper.mapper().convertValue((Object)bidExt, EXT_PREBID_TYPE_REFERENCE) : null;
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Invalid ext passed in bid with id: " + bidId);
        }
    }

    private Bid updateBid(RubiconBid bid, Imp imp, Float cpmOverrideFromRequest, RubiconBidResponse bidResponse) {
        String bidId = bid.getId();
        if (this.generateBidId) {
            bidId = UUID.randomUUID().toString();
        } else if (Objects.equals(bid.getId(), "0")) {
            bidId = bidResponse.getBidid();
        }
        Float cpmOverride = (Float)ObjectUtils.defaultIfNull((Object)this.cpmOverrideFromImp(imp), (Object)cpmOverrideFromRequest);
        BigDecimal bidPrice = cpmOverride != null ? new BigDecimal(String.valueOf(cpmOverride)) : bid.getPrice();
        RubiconBid updatedRubiconBid = bid.toBuilder().id(bidId).adm(this.resolveAdm(bid.getAdm(), bid.getAdmNative())).price(bidPrice).build();
        return this.bidFromRubiconBid(updatedRubiconBid);
    }

    private String resolveAdm(String bidAdm, ObjectNode admobject) {
        if (StringUtils.isNotBlank((CharSequence)bidAdm)) {
            return bidAdm;
        }
        return admobject != null ? admobject.toString() : null;
    }

    private Bid bidFromRubiconBid(RubiconBid rubiconBid) {
        try {
            return (Bid)this.mapper.mapper().convertValue((Object)rubiconBid, Bid.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Error converting rubiconBid to  ortbBid: " + e.getMessage(), (Throwable)e);
        }
    }

    private static BidderBid createBidderBid(Bid bid, Imp imp, BidType bidType, String currency) {
        return BidderBid.builder().bid(bid).type(bidType).bidCurrency(currency).priceFloorInfo(imp != null ? PriceFloorInfo.of((BigDecimal)imp.getBidfloor(), (String)imp.getBidfloorcur()) : null).build();
    }

    private Float cpmOverrideFromRequest(BidRequest bidRequest) {
        RubiconExtPrebidBiddersBidder bidder = this.extPrebidBiddersRubicon(bidRequest.getExt());
        RubiconExtPrebidBiddersBidderDebug debug = bidder != null ? bidder.getDebug() : null;
        return debug != null ? debug.getCpmoverride() : null;
    }

    private Float cpmOverrideFromImp(Imp imp) {
        return Optional.ofNullable(imp).map(arg_0 -> this.parseRubiconExt(arg_0)).map(ExtImpRubicon::getDebug).map(ExtImpRubiconDebug::getCpmoverride).orElse(null);
    }

    private static BidType bidType(BidRequest bidRequest) {
        ImpMediaType impMediaType = RubiconBidder.impType((Imp)((Imp)bidRequest.getImp().get(0)));
        return switch (3.$SwitchMap$org$prebid$server$proto$openrtb$ext$request$ImpMediaType[impMediaType.ordinal()]) {
            case 1 -> BidType.video;
            case 2 -> BidType.banner;
            case 3 -> BidType.xNative;
            default -> throw new PreBidException("Unsupported bid mediaType");
        };
    }

    private ObjectNode toObjectNode(JsonNode node) {
        return node != null && node.isObject() ? (ObjectNode)node : this.mapper.mapper().createObjectNode();
    }
}

