/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.pangle;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.pangle.model.BidExt;
import org.prebid.server.bidder.pangle.model.NetworkIds;
import org.prebid.server.bidder.pangle.model.PangleBidExt;
import org.prebid.server.bidder.pangle.model.WrappedImpExtBidder;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.pangle.ExtImpPangle;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class PangleBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public PangleBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                WrappedImpExtBidder extBidder = this.parseImpExt(imp);
                ExtImpPangle extImpPangle = extBidder.getBidder();
                Integer adType = PangleBidder.resolveAdType((Imp)imp, (WrappedImpExtBidder)extBidder);
                Imp modifiedImp = this.modifyImp(imp, adType, extBidder, extImpPangle);
                requests.add(this.createRequest(request, modifiedImp, extBidder.getBidder().getToken()));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private WrappedImpExtBidder parseImpExt(Imp imp) {
        try {
            return (WrappedImpExtBidder)this.mapper.mapper().convertValue((Object)imp.getExt(), WrappedImpExtBidder.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("failed unmarshalling imp ext (err)" + e.getMessage());
        }
    }

    private static int resolveAdType(Imp imp, WrappedImpExtBidder extBidder) {
        if (imp.getVideo() != null) {
            Integer isRewardedInventory;
            ExtImpPrebid extPrebid = extBidder != null ? extBidder.getPrebid() : null;
            Integer n = isRewardedInventory = extPrebid != null ? extPrebid.getIsRewardedInventory() : null;
            if (Objects.equals(isRewardedInventory, 1)) {
                return 7;
            }
            if (Objects.equals(imp.getInstl(), 1)) {
                return 8;
            }
        }
        if (imp.getBanner() != null) {
            if (Objects.equals(imp.getInstl(), 1)) {
                return 2;
            }
            return 1;
        }
        if (imp.getXNative() != null && StringUtils.isNotBlank((CharSequence)imp.getXNative().getRequest())) {
            return 5;
        }
        throw new PreBidException("not a supported adtype");
    }

    private Imp modifyImp(Imp imp, Integer adType, WrappedImpExtBidder extBidder, ExtImpPangle bidderImpExt) {
        NetworkIds modifiedNetworkIds = PangleBidder.getNetworkIds((ExtImpPangle)bidderImpExt);
        WrappedImpExtBidder updatedImpExt = extBidder.toBuilder().adType(adType).isPrebid(Boolean.valueOf(true)).networkids(modifiedNetworkIds == null ? extBidder.getNetworkids() : modifiedNetworkIds).build();
        return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().convertValue((Object)updatedImpExt, ObjectNode.class)).build();
    }

    private static NetworkIds getNetworkIds(ExtImpPangle bidderImpExt) {
        if (bidderImpExt != null) {
            String appid = bidderImpExt.getAppid();
            String placementid = bidderImpExt.getPlacementid();
            if (StringUtils.isNotEmpty((CharSequence)appid) && StringUtils.isNotEmpty((CharSequence)placementid)) {
                return NetworkIds.of((String)appid, (String)placementid);
            }
            if (StringUtils.isNotEmpty((CharSequence)appid) || StringUtils.isNotEmpty((CharSequence)placementid)) {
                throw new PreBidException("only one of appid or placementid is provided");
            }
        }
        return null;
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, Imp imp, String token) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(imp)).build();
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(PangleBidder.makeHeaders((String)token)).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build();
    }

    private static MultiMap makeHeaders(String token) {
        return HttpUtil.headers().add("TOKEN", token);
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            ArrayList errors = new ArrayList();
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)this.extractBids(bidResponse, errors), errors);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).flatMap(Collection::stream).map(bid -> this.createBid(bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid createBid(Bid bid, String currency, List<BidderError> errors) {
        Integer adType;
        try {
            adType = this.getAdTypeFromBidExt(bid);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
        BidType bidType = PangleBidder.resolveBidType((Integer)adType, errors);
        return BidderBid.of((Bid)bid, (BidType)bidType, (String)currency);
    }

    private static BidType resolveBidType(Integer adType, List<BidderError> errors) {
        return switch (adType) {
            case 1, 2 -> BidType.banner;
            case 5 -> BidType.xNative;
            case 7, 8 -> BidType.video;
            default -> {
                errors.add(BidderError.badServerResponse((String)"unrecognized adtype in response"));
                yield null;
            }
        };
    }

    private Integer getAdTypeFromBidExt(Bid bid) {
        Integer adType;
        PangleBidExt bidExt;
        if (bid == null) {
            throw new PreBidException("the bid request object is not present");
        }
        try {
            bidExt = (PangleBidExt)this.mapper.mapper().convertValue((Object)bid.getExt(), PangleBidExt.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("invalid bid ext");
        }
        BidExt pangleBidExt = bidExt != null ? bidExt.getPangle() : null;
        Integer n = adType = pangleBidExt != null ? pangleBidExt.getAdType() : null;
        if (adType == null) {
            throw new PreBidException("missing pangleExt/adtype in bid ext");
        }
        return adType;
    }
}

