/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.marsmedia;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.marsmedia.ExtImpMarsmedia;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class MarsmediaBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpMarsmedia>> MARSMEDIA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public MarsmediaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        BidRequest outgoingRequest;
        String firstImpZone;
        try {
            firstImpZone = this.resolveExtZone((Imp)bidRequest.getImp().get(0));
            outgoingRequest = MarsmediaBidder.createRequest((BidRequest)bidRequest);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        String uri = "%s&zone=%s".formatted(this.endpointUrl, firstImpZone);
        MultiMap headers = MarsmediaBidder.resolveHeaders((Device)bidRequest.getDevice());
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).uri(uri).headers(headers).body(this.mapper.encodeToBytes((Object)outgoingRequest)).payload((Object)outgoingRequest).build());
    }

    private String resolveExtZone(Imp imp) {
        ExtImpMarsmedia extImpMarsmedia;
        try {
            extImpMarsmedia = (ExtImpMarsmedia)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MARSMEDIA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ext.bidder not provided");
        }
        String zoneId = extImpMarsmedia.getZoneId();
        if (StringUtils.isBlank((CharSequence)zoneId)) {
            throw new PreBidException("ZoneId is empty");
        }
        return zoneId;
    }

    private static BidRequest createRequest(BidRequest request) {
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            Banner banner = imp.getBanner();
            if (banner != null) {
                if (CollectionUtils.isNotEmpty((Collection)banner.getFormat())) {
                    validImps.add(imp.toBuilder().banner(MarsmediaBidder.updateBanner((Banner)banner)).build());
                    continue;
                }
                if (banner.getW() != null && banner.getH() != null) {
                    validImps.add(imp);
                    continue;
                }
                throw new PreBidException("No valid banner format in the bid request");
            }
            if (imp.getVideo() == null) continue;
            validImps.add(imp);
        }
        if (validImps.isEmpty()) {
            throw new PreBidException("No valid impression in the bid request");
        }
        return request.toBuilder().at(Integer.valueOf(1)).imp(validImps).build();
    }

    private static Banner updateBanner(Banner banner) {
        Format firstFormat = (Format)banner.getFormat().get(0);
        return banner.toBuilder().w((Integer)ObjectUtils.defaultIfNull((Object)firstFormat.getW(), (Object)0)).h((Integer)ObjectUtils.defaultIfNull((Object)firstFormat.getH(), (Object)0)).build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)MarsmediaBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())), Collections.emptyList());
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : MarsmediaBidder.bidsFromResponse((List)bidResponse.getSeatbid(), (List)bidRequest.getImp(), (String)bidResponse.getCur());
    }

    private static List<BidderBid> bidsFromResponse(List<SeatBid> seatbid, List<Imp> imps, String currency) {
        SeatBid firstSeatBid = seatbid.get(0);
        return firstSeatBid != null ? firstSeatBid.getBid().stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)MarsmediaBidder.getBidType((String)bid.getImpid(), (List)imps), (String)currency)).toList() : Collections.emptyList();
    }

    private static BidType getBidType(String impid, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impid)) continue;
            return imp.getVideo() != null ? BidType.video : BidType.banner;
        }
        return BidType.banner;
    }
}

