/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.logicad;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.logicad.ExtImpLogicad;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogicadBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpLogicad>> LOGICAD_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public LogicadBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList errors = new ArrayList();
        ArrayList httpRequests = new ArrayList();
        try {
            Map impToExtImp = this.getExtImpToImps(request, errors);
            httpRequests.addAll(this.buildAdapterRequests(request, impToExtImp));
        }
        catch (PreBidException e) {
            return Result.of(Collections.emptyList(), errors);
        }
        return Result.of(httpRequests, errors);
    }

    private Map<ExtImpLogicad, List<Imp>> getExtImpToImps(BidRequest request, List<BidderError> errors) {
        HashMap<ExtImpLogicad, List<Imp>> result = new HashMap<ExtImpLogicad, List<Imp>>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpLogicad extImpLogicad = this.parseAndValidateImpExt(imp);
                Imp updatedImp = LogicadBidder.updateImp((Imp)imp, (String)extImpLogicad.getTid());
                result.putIfAbsent(extImpLogicad, new ArrayList());
                ((List)result.get(extImpLogicad)).add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (result.isEmpty()) {
            throw new PreBidException("No appropriate impressions");
        }
        return result;
    }

    private ExtImpLogicad parseAndValidateImpExt(Imp imp) {
        ExtImpLogicad extImp;
        try {
            extImp = (ExtImpLogicad)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), LOGICAD_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)extImp.getTid())) {
            throw new PreBidException("No tid value provided");
        }
        return extImp;
    }

    private static Imp updateImp(Imp imp, String tid) {
        return imp.toBuilder().tagid(tid).ext(null).build();
    }

    private List<HttpRequest<BidRequest>> buildAdapterRequests(BidRequest bidRequest, Map<ExtImpLogicad, List<Imp>> extImpToImps) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Map.Entry<ExtImpLogicad, List<Imp>> entry : extImpToImps.entrySet()) {
            BidRequest updatedBidRequest = bidRequest.toBuilder().imp(entry.getValue()).build();
            HttpRequest createdBidRequest = HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes((Object)updatedBidRequest)).headers(HttpUtil.headers()).payload((Object)bidRequest).build();
            httpRequests.add((HttpRequest<BidRequest>)createdBidRequest);
        }
        return httpRequests;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)LogicadBidder.extractBids((BidResponse)bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return LogicadBidder.bidsFromResponse((BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().map(SeatBid::getBid).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)bidResponse.getCur())).toList();
    }
}

