/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.jixie;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class JixieBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public JixieBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(JixieBidder.resolveHeaders((Device)request.getDevice(), (Site)request.getSite())).payload((Object)request).body(this.mapper.encodeToBytes((Object)request)).build());
    }

    private static MultiMap resolveHeaders(Device device, Site site) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
        }
        if (site != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.REFERER_HEADER, (CharSequence)site.getPage());
        }
        return headers;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)JixieBidder.extractBids((BidResponse)bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return JixieBidder.bidsFromResponse((BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)JixieBidder.getBidType((String)bid.getAdm()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String adm) {
        return StringUtils.containsAny((CharSequence)adm, (CharSequence[])new CharSequence[]{"<?xml", "<vast"}) ? BidType.video : BidType.banner;
    }
}

