/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.invibes;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.invibes.model.InvibesBidParams;
import org.prebid.server.bidder.invibes.model.InvibesBidRequest;
import org.prebid.server.bidder.invibes.model.InvibesBidderResponse;
import org.prebid.server.bidder.invibes.model.InvibesInternalParams;
import org.prebid.server.bidder.invibes.model.InvibesPlacementProperty;
import org.prebid.server.bidder.invibes.model.InvibesTypedBid;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.invibes.ExtImpInvibes;
import org.prebid.server.proto.openrtb.ext.request.invibes.model.InvibesDebug;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class InvibesBidder
implements Bidder<InvibesBidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpInvibes>> INVIBES_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String INVIBES_BID_VERSION = "4";
    private static final String ADAPTER_VERSION = "prebid_1.0.0";
    private static final String URL_HOST_MACRO = "{{ZoneID}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public InvibesBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<InvibesBidRequest>>> makeHttpRequests(BidRequest request) {
        if (request.getSite() == null) {
            return Result.withError((BidderError)BidderError.badInput((String)"Site not specified"));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        String consentString = this.resolveConsentString(request.getUser());
        Boolean gdprApplies = this.resolveGDPRApplies(request.getRegs());
        InvibesInternalParams invibesInternalParams = new InvibesInternalParams();
        invibesInternalParams.setBidParams(InvibesBidParams.builder().properties(new HashMap()).placementIds(new ArrayList()).bidVersion("4").build());
        for (Imp imp : request.getImp()) {
            ExtImpInvibes extImpInvibes;
            try {
                extImpInvibes = this.parseImpExt(imp);
                this.validateImp(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            this.updateInvibesInternalParams(invibesInternalParams, extImpInvibes, imp);
        }
        invibesInternalParams.setIsAmp(Boolean.valueOf(InvibesBidder.isAmp((BidRequest)request)));
        List placementIds = invibesInternalParams.getBidParams().getPlacementIds();
        if (CollectionUtils.isEmpty((Collection)placementIds)) {
            return Result.of(Collections.emptyList(), errors);
        }
        invibesInternalParams.setGdpr(gdprApplies);
        invibesInternalParams.setGdprConsent(consentString);
        try {
            HttpRequest httpRequest = this.makeRequest(invibesInternalParams, request);
            return Result.of(Collections.singletonList(httpRequest), errors);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
    }

    private ExtImpInvibes parseImpExt(Imp imp) {
        try {
            return (ExtImpInvibes)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), INVIBES_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Error parsing invibesExt parameters in impression with id: " + imp.getId());
        }
    }

    private void validateImp(Imp imp) {
        if (imp.getBanner() == null) {
            throw new PreBidException("Banner not specified in impression with id: " + imp.getId());
        }
    }

    private String resolveConsentString(User user) {
        ExtUser extUser = user != null ? user.getExt() : null;
        return extUser != null ? extUser.getConsent() : "";
    }

    private Boolean resolveGDPRApplies(Regs regs) {
        ExtRegs extRegs = regs != null ? regs.getExt() : null;
        Integer gdpr = extRegs != null ? extRegs.getGdpr() : null;
        return gdpr == null || gdpr == 1;
    }

    private void updateInvibesInternalParams(InvibesInternalParams invibesInternalParams, ExtImpInvibes invibesExt, Imp imp) {
        String invibesDebugTestBvid;
        String impExtPlacementId = invibesExt.getPlacementId();
        InvibesBidParams bidParams = invibesInternalParams.getBidParams();
        List updatedPlacementIds = bidParams.getPlacementIds();
        if (StringUtils.isNotBlank((CharSequence)impExtPlacementId)) {
            updatedPlacementIds.add(impExtPlacementId.trim());
        }
        Banner banner = imp.getBanner();
        List adFormats = this.resolveAdFormats(banner);
        bidParams.getProperties().put(impExtPlacementId, InvibesPlacementProperty.builder().impId(imp.getId()).formats(adFormats).build());
        InvibesBidParams updatedBidParams = bidParams.toBuilder().placementIds(updatedPlacementIds).build();
        invibesInternalParams.setDomainId(invibesExt.getDomainId());
        invibesInternalParams.setBidParams(updatedBidParams);
        InvibesDebug invibesDebug = invibesExt.getDebug();
        String string = invibesDebugTestBvid = invibesDebug != null ? invibesDebug.getTestBvid() : null;
        if (StringUtils.isNotBlank((CharSequence)invibesDebugTestBvid)) {
            invibesInternalParams.setTestBvid(invibesDebugTestBvid);
        }
        if (invibesDebug != null) {
            invibesInternalParams.setTestLog(invibesDebug.getTestLog());
        }
    }

    private List<Format> resolveAdFormats(Banner currentBanner) {
        if (currentBanner.getFormat() != null) {
            return currentBanner.getFormat();
        }
        Integer formatW = currentBanner.getW();
        Integer formatH = currentBanner.getH();
        return formatW != null && formatH != null ? Collections.singletonList(Format.builder().w(formatW).h(formatH).build()) : Collections.emptyList();
    }

    private HttpRequest<InvibesBidRequest> makeRequest(InvibesInternalParams invibesParams, BidRequest request) {
        String subdomain = InvibesBidder.resolveHost((Integer)invibesParams.getDomainId());
        String url = this.endpointUrl.replace("{{ZoneID}}", subdomain);
        InvibesBidRequest parameter = this.resolveParameter(invibesParams, request);
        Device device = request.getDevice();
        Site site = request.getSite();
        MultiMap headers = InvibesBidder.resolveHeaders((Device)device, (Site)site);
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(headers).payload((Object)parameter).body(this.mapper.encodeToBytes((Object)parameter)).build();
    }

    private InvibesBidRequest resolveParameter(InvibesInternalParams invibesParams, BidRequest request) {
        User user = request.getUser();
        String buyeruid = user != null ? user.getBuyeruid() : null;
        String lid = StringUtils.isNotBlank((CharSequence)buyeruid) ? buyeruid : "";
        return this.createRequest(invibesParams, lid, request.getDevice(), request.getSite());
    }

    private InvibesBidRequest createRequest(InvibesInternalParams invibesParams, String lid, Device device, Site site) {
        String testBvid = invibesParams.getTestBvid();
        Boolean testLog = invibesParams.getTestLog();
        return InvibesBidRequest.builder().isTestBid(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)testBvid))).bidParamsJson(this.mapper.encodeToString((Object)invibesParams.getBidParams())).location(site.getPage()).lid(lid).kw(site.getKeywords()).isAmp(invibesParams.getIsAmp()).width(InvibesBidder.resolveWidth((Device)device)).height(InvibesBidder.resolveHeight((Device)device)).gdprConsent(invibesParams.getGdprConsent()).gdpr(invibesParams.getGdpr()).bvid(testBvid).invibBVLog(testLog).videoAdDebug(testLog).build();
    }

    private static String resolveHeight(Device device) {
        Integer height = device != null ? device.getH() : null;
        return height != null && height > 0 ? height.toString() : null;
    }

    private static String resolveWidth(Device device) {
        Integer width = device != null ? device.getW() : null;
        return width != null && width > 0 ? width.toString() : null;
    }

    private static String resolveHost(Integer domainId) {
        if (domainId == 0 || domainId == 1 || domainId == 1001) {
            return "bid";
        }
        if (domainId < 1002) {
            return "bid" + domainId;
        }
        return "bid" + (domainId - 1000);
    }

    private static MultiMap resolveHeaders(Device device, Site site) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
        }
        if (site != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.REFERER_HEADER, (CharSequence)site.getPage());
        }
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)"Aver", (CharSequence)"prebid_1.0.0");
        return headers;
    }

    private static boolean isAmp(BidRequest request) {
        return Optional.ofNullable(request.getExt()).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getAmp).isPresent();
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<InvibesBidRequest> httpCall, BidRequest bidRequest) {
        try {
            InvibesBidderResponse bidResponse = (InvibesBidderResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), InvibesBidderResponse.class);
            if (bidResponse != null && StringUtils.isNotBlank((CharSequence)bidResponse.getError())) {
                return Result.withError((BidderError)BidderError.badServerResponse((String)"Server error: %s.".formatted(bidResponse.getError())));
            }
            return Result.of((Object)this.extractBids(bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(InvibesBidderResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getTypedBids()) ? Collections.emptyList() : this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(InvibesBidderResponse bidResponse) {
        return bidResponse.getTypedBids().stream().filter(Objects::nonNull).map(InvibesTypedBid::getBid).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)bidResponse.getCurrency())).toList();
    }
}

