/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.intertech;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.intertech.ExtImpIntertech;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class IntertechBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpIntertech>> INTERTECH_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String PAGE_ID_MACRO = "{{page_id}}";
    private static final String IMP_ID_MACRO = "{{imp_id}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public IntertechBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> bidRequests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        String referer = this.getReferer(request);
        String cur = this.getCur(request);
        List impList = request.getImp();
        for (Imp imp : impList) {
            try {
                ExtImpIntertech extImpIntertech = this.parseAndValidateImpExt(imp.getExt(), imp.getId());
                Imp modifiedImp = IntertechBidder.modifyImp((Imp)imp);
                String modifiedUrl = this.modifyUrl(extImpIntertech, referer, cur);
                BidRequest modifiedRequest = request.toBuilder().imp(Collections.singletonList(modifiedImp)).build();
                bidRequests.add(this.buildHttpRequest(modifiedRequest, modifiedUrl));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(bidRequests, errors);
    }

    private String getReferer(BidRequest request) {
        Site site = request.getSite();
        return site != null ? site.getPage() : null;
    }

    private String getCur(BidRequest request) {
        List curs = request.getCur();
        return curs != null && !curs.isEmpty() ? (String)curs.get(0) : "";
    }

    private ExtImpIntertech parseAndValidateImpExt(ObjectNode impExtNode, String impId) {
        ExtImpIntertech extImpIntertech;
        try {
            extImpIntertech = (ExtImpIntertech)((ExtPrebid)this.mapper.mapper().convertValue((Object)impExtNode, INTERTECH_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("imp #%s: %s".formatted(impId, e.getMessage()));
        }
        Integer pageId = extImpIntertech.getPageId();
        if (pageId == null || pageId == 0) {
            throw new PreBidException("imp #%s: missing param page_id".formatted(impId));
        }
        Integer intertechImpId = extImpIntertech.getImpId();
        if (intertechImpId == null || intertechImpId == 0) {
            throw new PreBidException("imp #%s: missing param imp_id".formatted(impId));
        }
        return extImpIntertech;
    }

    private static Imp modifyImp(Imp imp) {
        if (imp.getBanner() != null) {
            return imp.toBuilder().banner(IntertechBidder.updateBanner((Banner)imp.getBanner())).build();
        }
        if (imp.getXNative() != null) {
            return imp;
        }
        throw new PreBidException("Intertech only supports banner and native types. Ignoring imp id=%s".formatted(imp.getId()));
    }

    private static Banner updateBanner(Banner banner) {
        if (banner == null) {
            return null;
        }
        Integer w = banner.getW();
        Integer h = banner.getH();
        List format = banner.getFormat();
        if (w == null || h == null || w == 0 || h == 0) {
            if (CollectionUtils.isNotEmpty((Collection)format)) {
                Format firstFormat = (Format)format.get(0);
                return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
            }
            throw new PreBidException("Invalid sizes provided for Banner %sx%s".formatted(w, h));
        }
        return banner;
    }

    private String modifyUrl(ExtImpIntertech extImpIntertech, String referer, String cur) {
        String resolvedUrl = this.endpointUrl.replace("{{page_id}}", HttpUtil.encodeUrl((String)extImpIntertech.getPageId().toString())).replace("{{imp_id}}", HttpUtil.encodeUrl((String)extImpIntertech.getImpId().toString()));
        StringBuilder uri = new StringBuilder(resolvedUrl);
        if (StringUtils.isNotBlank((CharSequence)referer)) {
            uri.append("&target-ref=").append(HttpUtil.encodeUrl((String)referer));
        }
        if (StringUtils.isNotBlank((CharSequence)cur)) {
            uri.append("&ssp-cur=").append(cur);
        }
        return uri.toString();
    }

    private HttpRequest<BidRequest> buildHttpRequest(BidRequest outgoingRequest, String url) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(IntertechBidder.headers((BidRequest)outgoingRequest)).body(this.mapper.encodeToBytes((Object)outgoingRequest)).payload((Object)outgoingRequest).build();
    }

    private static MultiMap headers(BidRequest bidRequest) {
        MultiMap headers = HttpUtil.headers();
        Device device = bidRequest.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)"X-Real-Ip", (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> bidderCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(bidderCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)IntertechBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)bidderCall.getRequest().getPayload())));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        List seatBids;
        List list = seatBids = bidResponse != null ? bidResponse.getSeatbid() : null;
        if (seatBids == null) {
            return Collections.emptyList();
        }
        if (seatBids.isEmpty()) {
            throw new PreBidException("SeatBids is empty");
        }
        return IntertechBidder.bidsFromResponse((BidResponse)bidResponse, (List)bidRequest.getImp());
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<Imp> imps) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)IntertechBidder.getBidType((String)bid.getImpid(), (List)imps), (String)bidResponse.getCur())).collect(Collectors.toList());
    }

    private static BidType getBidType(String bidImpId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!bidImpId.equals(imp.getId())) continue;
            return IntertechBidder.resolveImpType((Imp)imp);
        }
        throw new PreBidException("Invalid bid imp ID %s does not match any imp IDs from the original bid request".formatted(bidImpId));
    }

    private static BidType resolveImpType(Imp imp) {
        if (imp.getXNative() != null) {
            return BidType.xNative;
        }
        if (imp.getBanner() != null) {
            return BidType.banner;
        }
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        if (imp.getAudio() != null) {
            return BidType.audio;
        }
        throw new PreBidException("Processing an invalid impression; cannot resolve impression type");
    }
}

