/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.User;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.huaweiads.ClientTimeFormatter;
import org.prebid.server.bidder.huaweiads.HuaweiUtils;
import org.prebid.server.bidder.huaweiads.model.request.Device;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.huaweiads.ExtUserDataDeviceIdHuaweiAds;

public class HuaweiDeviceBuilder {
    private static final TypeReference<ExtUserDataDeviceIdHuaweiAds> EXT_USER_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String DEFAULT_MODEL_NAME = "HUAWEI";
    private final JacksonMapper mapper;
    private final ClientTimeFormatter clientTimeFormatter;

    public HuaweiDeviceBuilder(JacksonMapper mapper, ClientTimeFormatter clientTimeFormatter) {
        this.mapper = Objects.requireNonNull(mapper);
        this.clientTimeFormatter = clientTimeFormatter;
    }

    public Device build(com.iab.openrtb.request.Device device, User user, String countryCode) throws PreBidException {
        Device deviceId = this.makeDeviceWithDeviceId(device, user);
        if (device == null) {
            return deviceId;
        }
        String tracking = device.getDnt() != null ? String.valueOf(1 - device.getDnt()) : null;
        return deviceId.toBuilder().type(device.getDevicetype()).userAgent(device.getUa()).os(device.getOs()).version(device.getOsv()).maker(device.getMake()).model(HuaweiUtils.getIfNotBlank((String)device.getModel()).orElse(DEFAULT_MODEL_NAME)).height(device.getH()).width(device.getW()).language(device.getLanguage()).pxratio(device.getPxratio()).belongCountry(countryCode).localeCountry(countryCode).ip(device.getIp()).isTrackingEnabled(tracking != null && StringUtils.isNotBlank((CharSequence)deviceId.getOaid()) ? tracking : null).gaidTrackingEnabled(tracking != null && StringUtils.isNotBlank((CharSequence)deviceId.getGaid()) ? tracking : null).build();
    }

    private Device makeDeviceWithDeviceId(com.iab.openrtb.request.Device device, User user) {
        boolean isOaidEmpty;
        Optional<Device> deviceIfa = Optional.ofNullable(device).flatMap(dev -> HuaweiUtils.getIfNotBlank((String)dev.getIfa()));
        if (user == null || user.getExt() == null) {
            return deviceIfa.map(gaid -> Device.builder().gaid(gaid).clientTime(this.clientTimeFormatter.now()).build()).orElseThrow(() -> new PreBidException("getDeviceID: openRTBRequest.User.Ext is nil and device.Gaid is not specified."));
        }
        ExtUserDataDeviceIdHuaweiAds userData = this.parseUserExtData(user.getExt());
        boolean isImeiEmpty = userData == null || CollectionUtils.isEmpty((Collection)userData.getImei());
        boolean isGaidEmpty = userData == null || CollectionUtils.isEmpty((Collection)userData.getGaid());
        boolean bl = isOaidEmpty = userData == null || CollectionUtils.isEmpty((Collection)userData.getOaid());
        if (isImeiEmpty && isOaidEmpty && isGaidEmpty && deviceIfa.isEmpty()) {
            throw new PreBidException("getDeviceID: Imei, Oaid, Gaid are all empty.");
        }
        String gaid2 = isGaidEmpty ? (String)deviceIfa.orElseThrow(() -> new PreBidException("getDeviceID: openRTBRequest.User.Ext is nil and device.Gaid is not specified.")) : (String)userData.getGaid().get(0);
        String oaid = isOaidEmpty ? null : (String)userData.getOaid().get(0);
        String imei = isImeiEmpty ? null : (String)userData.getImei().get(0);
        String clientTime = Optional.ofNullable(userData).map(ExtUserDataDeviceIdHuaweiAds::getClientTime).map(arg_0 -> this.formatClientTime(arg_0)).orElseGet(() -> ((ClientTimeFormatter)this.clientTimeFormatter).now());
        return Device.builder().clientTime(clientTime).oaid(oaid).gaid(gaid2).imei(imei).build();
    }

    private ExtUserDataDeviceIdHuaweiAds parseUserExtData(ExtUser extUser) {
        try {
            return (ExtUserDataDeviceIdHuaweiAds)this.mapper.mapper().convertValue((Object)extUser.getData(), EXT_USER_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private String formatClientTime(List<String> clientTimes) {
        return CollectionUtils.isEmpty(clientTimes) ? null : this.clientTimeFormatter.format(clientTimes.get(0));
    }
}

