/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.User;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.geolocation.CountryCodeMapper;

public class CountryCodeResolver {
    private final CountryCodeMapper countryCodeMapper;

    public CountryCodeResolver(CountryCodeMapper countryCodeMapper) {
        this.countryCodeMapper = Objects.requireNonNull(countryCodeMapper);
    }

    public Optional<String> resolve(BidRequest bidRequest) {
        Optional countryOfDevice = Optional.ofNullable(bidRequest.getDevice()).map(Device::getGeo).map(Geo::getCountry).filter(StringUtils::isNotBlank).flatMap(arg_0 -> this.convertCountryCode(arg_0));
        Optional countryOfUser = Optional.ofNullable(bidRequest.getUser()).map(User::getGeo).map(Geo::getCountry).filter(StringUtils::isNotBlank).flatMap(arg_0 -> this.convertCountryCode(arg_0));
        Optional<String> countryOfMcc = Optional.ofNullable(bidRequest.getDevice()).map(Device::getMccmnc).filter(StringUtils::isNotBlank).map(mccmnc -> mccmnc.split("-")[0]).map(arg_0 -> ((CountryCodeMapper)this.countryCodeMapper).mapMccToAlpha2(arg_0));
        return countryOfDevice.or(() -> countryOfUser).or(() -> countryOfMcc);
    }

    private Optional<String> convertCountryCode(String countryCode) {
        return switch (countryCode.length()) {
            case 1 -> Optional.empty();
            case 2 -> Optional.of(countryCode);
            default -> Optional.ofNullable(this.countryCodeMapper.mapToAlpha2(countryCode));
        };
    }
}

