/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.grid;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.grid.model.request.KeywordSegment;
import org.prebid.server.bidder.grid.model.request.Keywords;
import org.prebid.server.bidder.grid.model.request.KeywordsPublisherItem;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GridKeywordsProcessor {
    private static final TypeReference<Map<String, JsonNode>> MAP_TYPE_REF = new /* Unavailable Anonymous Inner Class!! */;
    private static final String KEYWORDS_PROPERTY = "keywords";
    private static final String USER_PROPERTY = "user";
    private static final String SITE_PROPERTY = "site";
    private final JacksonMapper mapper;

    public GridKeywordsProcessor(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Map<String, JsonNode> modifyWithKeywords(Map<String, JsonNode> extRequestProperties, Keywords keywords) {
        JsonNode keywordsJsonNode = extRequestProperties.get("keywords");
        ObjectNode keywordsNode = GridKeywordsProcessor.isObjectNode((JsonNode)keywordsJsonNode) ? (ObjectNode)keywordsJsonNode : this.mapper.mapper().createObjectNode();
        GridKeywordsProcessor.setIfNotNullOrRemove((ObjectNode)keywordsNode, (String)"user", (JsonNode)GridKeywordsProcessor.stripToNull((ObjectNode)keywords.getUser()));
        GridKeywordsProcessor.setIfNotNullOrRemove((ObjectNode)keywordsNode, (String)"site", (JsonNode)GridKeywordsProcessor.stripToNull((ObjectNode)keywords.getSite()));
        HashMap<String, JsonNode> modifiedExtRequestProperties = new HashMap<String, JsonNode>(extRequestProperties);
        if (!keywordsNode.isEmpty()) {
            modifiedExtRequestProperties.put("keywords", (JsonNode)keywordsNode);
        } else {
            modifiedExtRequestProperties.remove("keywords");
        }
        return modifiedExtRequestProperties;
    }

    private static void setIfNotNullOrRemove(ObjectNode node, String key, JsonNode value) {
        if (value != null) {
            node.set(key, value);
        } else {
            node.remove(key);
        }
    }

    public Keywords resolveKeywordsFromOpenRtb(String userKeywords, String siteKeywords) {
        return Keywords.of((ObjectNode)this.resolveKeywordsSectionFromOpenRtb(userKeywords), (ObjectNode)this.resolveKeywordsSectionFromOpenRtb(siteKeywords));
    }

    public ObjectNode resolveKeywordsSectionFromOpenRtb(String keywords) {
        List<KeywordSegment> segments = Arrays.stream(keywords.split(",")).filter(StringUtils::isNotEmpty).map(keyword -> KeywordSegment.of((String)"keywords", (String)keyword)).toList();
        ObjectNode publisherNode = this.mapper.mapper().createObjectNode();
        if (!segments.isEmpty()) {
            List<KeywordsPublisherItem> publisherItems = Collections.singletonList(KeywordsPublisherItem.of((String)"keywords", segments));
            return (ObjectNode)publisherNode.set("ortb2", this.mapper.mapper().valueToTree(publisherItems));
        }
        return publisherNode;
    }

    public Keywords resolveKeywords(Keywords keywords) {
        return keywords == null ? Keywords.empty() : Keywords.of((ObjectNode)this.resolveKeywordsSection(keywords.getUser()), (ObjectNode)this.resolveKeywordsSection(keywords.getSite()));
    }

    public ObjectNode resolveKeywordsSection(ObjectNode sectionNode) {
        if (sectionNode == null) {
            return null;
        }
        ObjectNode resolvedSectionNode = this.mapper.mapper().createObjectNode();
        Map sectionMap = this.jsonNodeToMap((JsonNode)sectionNode);
        for (Map.Entry entry : sectionMap.entrySet()) {
            List publisherKeywords;
            JsonNode publisherJsonNode = (JsonNode)entry.getValue();
            if (!GridKeywordsProcessor.isArrayNode((JsonNode)publisherJsonNode) || (publisherKeywords = this.resolvePublisherKeywords(publisherJsonNode)).isEmpty()) continue;
            resolvedSectionNode.set((String)entry.getKey(), this.mapper.mapper().valueToTree((Object)publisherKeywords));
        }
        return resolvedSectionNode;
    }

    public List<KeywordsPublisherItem> resolvePublisherKeywords(JsonNode publisherNode) {
        ArrayList<KeywordsPublisherItem> publishersKeywords = new ArrayList<KeywordsPublisherItem>();
        Iterator publisherNodeElements = publisherNode.elements();
        while (publisherNodeElements.hasNext()) {
            JsonNode publisherValueNode = (JsonNode)publisherNodeElements.next();
            JsonNode publisherNameNode = publisherValueNode.get("name");
            JsonNode segmentsNode = publisherValueNode.get("segments");
            if (!GridKeywordsProcessor.isTextualNode((JsonNode)publisherNameNode)) continue;
            ArrayList segments = new ArrayList(GridKeywordsProcessor.resolvePublisherSegments((JsonNode)segmentsNode));
            segments.addAll(this.resolveAlternativePublisherSegments(publisherValueNode));
            if (segments.isEmpty()) continue;
            publishersKeywords.add(KeywordsPublisherItem.of((String)publisherNameNode.asText(), segments));
        }
        return publishersKeywords;
    }

    public static List<KeywordSegment> resolvePublisherSegments(JsonNode segmentsNode) {
        ArrayList<KeywordSegment> parsedSegments = new ArrayList<KeywordSegment>();
        if (!GridKeywordsProcessor.isArrayNode((JsonNode)segmentsNode)) {
            return parsedSegments;
        }
        Iterator segments = segmentsNode.elements();
        while (segments.hasNext()) {
            KeywordSegment keywordSegment = GridKeywordsProcessor.resolvePublisherSegment((JsonNode)((JsonNode)segments.next()));
            if (keywordSegment == null) continue;
            parsedSegments.add(keywordSegment);
        }
        return parsedSegments;
    }

    public static KeywordSegment resolvePublisherSegment(JsonNode segmentNode) {
        JsonNode nameNode = segmentNode.get("name");
        String name = GridKeywordsProcessor.isTextualNode((JsonNode)nameNode) ? nameNode.asText() : null;
        JsonNode valueNode = segmentNode.get("value");
        String value = GridKeywordsProcessor.isTextualNode((JsonNode)valueNode) ? valueNode.asText() : null;
        return StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isNotEmpty((CharSequence)value) ? KeywordSegment.of((String)name, (String)value) : null;
    }

    public List<KeywordSegment> resolveAlternativePublisherSegments(JsonNode publisherValueNode) {
        return this.jsonNodeToMap(publisherValueNode).entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(publisherEntry -> GridKeywordsProcessor.isArrayNode((JsonNode)((JsonNode)publisherEntry.getValue()))).map(GridKeywordsProcessor::mapPublisherEntryToKeywordSegmentList).flatMap(Collection::stream).toList();
    }

    private static List<KeywordSegment> mapPublisherEntryToKeywordSegmentList(Map.Entry<String, JsonNode> publisherEntry) {
        ArrayList<KeywordSegment> keywordSegments = new ArrayList<KeywordSegment>();
        Iterator publisherEntryElements = publisherEntry.getValue().elements();
        while (publisherEntryElements.hasNext()) {
            JsonNode currentNode = (JsonNode)publisherEntryElements.next();
            if (!currentNode.isTextual()) continue;
            keywordSegments.add(KeywordSegment.of((String)publisherEntry.getKey(), (String)currentNode.asText()));
        }
        return keywordSegments;
    }

    public Keywords merge(Keywords ... keywords) {
        return Keywords.of((ObjectNode)this.mergeSections(this.extractSections(Keywords::getUser, keywords)), (ObjectNode)this.mergeSections(this.extractSections(Keywords::getSite, keywords)));
    }

    public Stream<ObjectNode> extractSections(Function<Keywords, ObjectNode> extractor, Keywords ... keywords) {
        return Arrays.stream(keywords).map(keyword -> GridKeywordsProcessor.stripToNull((ObjectNode)((ObjectNode)ObjectUtil.getIfNotNull((Object)keyword, (Function)extractor)))).filter(Objects::nonNull);
    }

    private ObjectNode mergeSections(Stream<ObjectNode> sections) {
        return sections.reduce(this.mapper.mapper().createObjectNode(), (left, right) -> (ObjectNode)GridKeywordsProcessor.mergeSections((JsonNode)left, (JsonNode)right));
    }

    public static JsonNode mergeSections(JsonNode firstSection, JsonNode secondSection) {
        Iterator updateFieldNames = secondSection.fieldNames();
        while (updateFieldNames.hasNext()) {
            String updateFieldName = (String)updateFieldNames.next();
            JsonNode valueToBeUpdated = firstSection.get(updateFieldName);
            JsonNode updateValue = secondSection.get(updateFieldName);
            if (GridKeywordsProcessor.isArrayNode((JsonNode)valueToBeUpdated) && GridKeywordsProcessor.isArrayNode((JsonNode)updateValue)) {
                ArrayNode arrayToBeUpdated = (ArrayNode)valueToBeUpdated;
                for (JsonNode updateChildNode : updateValue) {
                    arrayToBeUpdated.add(updateChildNode);
                }
                continue;
            }
            if (GridKeywordsProcessor.isObjectNode((JsonNode)valueToBeUpdated)) {
                GridKeywordsProcessor.mergeSections((JsonNode)valueToBeUpdated, (JsonNode)updateValue);
                continue;
            }
            if (!GridKeywordsProcessor.isObjectNode((JsonNode)firstSection)) continue;
            ((ObjectNode)firstSection).replace(updateFieldName, updateValue);
        }
        return firstSection;
    }

    private Map<String, JsonNode> jsonNodeToMap(JsonNode jsonNode) {
        try {
            return GridKeywordsProcessor.isObjectNode((JsonNode)jsonNode) ? (Map)this.mapper.mapper().convertValue((Object)jsonNode, MAP_TYPE_REF) : Collections.emptyMap();
        }
        catch (IllegalArgumentException ignored) {
            return Collections.emptyMap();
        }
    }

    private static ObjectNode stripToNull(ObjectNode objectNode) {
        return objectNode != null && !objectNode.isEmpty() ? objectNode : null;
    }

    private static boolean isArrayNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isArray();
    }

    private static boolean isObjectNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isObject();
    }

    private static boolean isTextualNode(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.isTextual();
    }
}

