/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.gamoshi;

import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.gamoshi.ExtImpGamoshi;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GamoshiBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public GamoshiBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpGamoshi firstImpExt;
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> validImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            if (imp.getBanner() == null && imp.getVideo() == null) {
                errors.add(BidderError.badInput((String)("Gamoshi only supports banner and video media types. Ignoring imp id=" + imp.getId())));
                continue;
            }
            validImps.add(GamoshiBidder.processImp((Imp)imp));
        }
        if (validImps.isEmpty()) {
            errors.add(BidderError.badInput((String)"No valid impressions in the bid request"));
            return Result.of(Collections.emptyList(), errors);
        }
        try {
            firstImpExt = this.parseAndValidateImpExt((Imp)validImps.get(0));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        BidRequest outgoingRequest = request.toBuilder().imp(validImps).build();
        String requestUrl = this.endpointUrl + "/r/" + firstImpExt.getSupplyPartnerId() + "/bidr?bidder=prebid-server";
        MultiMap headers = GamoshiBidder.resolveHeaders((Device)request.getDevice());
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(requestUrl).headers(headers).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build()), errors);
    }

    private static Imp processImp(Imp imp) {
        Banner banner = imp.getBanner();
        if (banner != null && banner.getH() == null && banner.getW() == null && CollectionUtils.isNotEmpty((Collection)banner.getFormat())) {
            Format firstFormat = (Format)banner.getFormat().get(0);
            Banner modifiedBanner = banner.toBuilder().h(firstFormat.getH()).w(firstFormat.getW()).build();
            return imp.toBuilder().banner(modifiedBanner).build();
        }
        return imp;
    }

    private ExtImpGamoshi parseAndValidateImpExt(Imp imp) {
        ExtImpGamoshi extImpGamoshi;
        try {
            extImpGamoshi = (ExtImpGamoshi)this.mapper.mapper().convertValue((Object)imp.getExt().get("bidder"), ExtImpGamoshi.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)extImpGamoshi.getSupplyPartnerId())) {
            throw new PreBidException("supplyPartnerId is empty");
        }
        return extImpGamoshi;
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.4");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)GamoshiBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return GamoshiBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        Map<String, BidType> impIdToBidType = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, GamoshiBidder::getBidType));
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)impIdToBidType.getOrDefault(bid.getImpid(), BidType.banner), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(Imp imp) {
        return imp.getVideo() != null ? BidType.video : BidType.banner;
    }
}

